/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.beans.IntrospectionException;
import java.net.InetAddress;
import org.objectweb.proactive.ActiveObjectCreationException;
import org.objectweb.proactive.ProActive;
import org.objectweb.proactive.core.node.NodeException;
import uchicago.src.reflector.Introspector;
import uchicago.src.sim.engine.BatchController;
import uchicago.src.sim.engine.HomeController;
import uchicago.src.sim.engine.SimEvent;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.parameter.DefaultParameterSetter;
import uchicago.src.sim.util.Random;
import uchicago.src.sim.util.SimUtilities;

public class RemoteBatchController
extends BatchController {
    protected long batchCount;
    protected HomeController control;

    public RemoteBatchController() {
        super(new DefaultParameterSetter());
        this.control = null;
    }

    public RemoteBatchController(HomeController homeController) {
        super(new DefaultParameterSetter());
        this.control = homeController;
    }

    public void setModel(SimModel simModel) {
        simModel.setController(this);
        super.setModel(simModel);
        simModel.addSimEventListener(this);
        String[] stringArray = simModel.getInitParam();
        this.pArray = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, this.pArray, 0, stringArray.length);
        this.pArray[stringArray.length] = "rngSeed";
        this.setModelParameters();
    }

    protected void setModelParameters() {
        this.model.generateNewSeed();
        Random.createUniform();
        Introspector introspector = new Introspector();
        try {
            introspector.introspect(this.model, this.pArray);
        }
        catch (IntrospectionException introspectionException) {
            String string = "Fatal Error setting model parameters";
            System.out.println(string);
            SimUtilities.logException(string, introspectionException);
            introspectionException.printStackTrace();
            System.exit(0);
        }
        try {
            this.batchCount = this.control.nextModel((Introspector)ProActive.turnActive((Object)introspector));
            if (this.batchCount == -1L) {
                this.finished = true;
            }
        }
        catch (ActiveObjectCreationException activeObjectCreationException) {
            activeObjectCreationException.printStackTrace();
        }
        catch (NodeException nodeException) {
            nodeException.printStackTrace();
        }
    }

    public void stopRun() {
        this.model.setup();
        this.runThread = null;
        this.setModelParameters();
        if (this.finished) {
            return;
        }
        this.runFinished = false;
        this.start();
    }

    public long getRunCount() {
        return this.batchCount;
    }

    public void start() {
        this.listenerList.clear();
        try {
            this.startSim();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            System.exit(0);
        }
    }

    public void setModelClass(Class clazz) {
        try {
            this.setModel((SimModel)clazz.newInstance());
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public void setModelClass(String string) {
        try {
            this.setModelClass(Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public void putPersistentObj(Object object, Object object2) {
        this.control.putPersistentObj(object, object2);
    }

    public Object getPersistentObj(Object object) {
        Object object2 = null;
        try {
            object2 = ProActive.getFutureValue((Object)this.control.getPersistentObj(object));
        }
        catch (RuntimeException runtimeException) {
            System.out.println("e.getMessage() = " + runtimeException.getMessage());
            System.out.println("Null Object returned from Persistent Object Store");
        }
        return object2;
    }

    public boolean getPutPersistentObject(Object object, Object object2) {
        return this.control.getPutPersistenceObject(object, object2);
    }

    public Object beginRemoteRun() throws Exception {
        String string = InetAddress.getLocalHost().getHostName();
        System.out.println("Starting remote " + string);
        this.begin();
        System.out.println("Done remote " + string);
        return ProActive.turnActive((Object)new Object());
    }

    public void exitSim() {
        this.fireSimEvent(new SimEvent(this, 2));
    }

    public void quit() {
        System.exit(0);
    }
}

