/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.util.List;
import uchicago.src.sim.engine.ActionQueue;
import uchicago.src.sim.engine.ActionUtilities;
import uchicago.src.sim.engine.BasicAction;
import uchicago.src.sim.engine.RandomScheduleGroup;
import uchicago.src.sim.engine.Schedule;
import uchicago.src.sim.engine.ScheduleGroup;
import uchicago.src.sim.engine.ThreadedAction;

public abstract class ScheduleBase
extends BasicAction {
    public static final Order LAST = new Order(0);
    public static final Order CONCURRENT = new Order(-1);
    protected double repeatInterval = 1.0;
    protected volatile double ticks = 0.0;
    protected ActionQueue actionQueue = new ActionQueue();
    protected ActionQueue lastQueue = new ActionQueue();
    protected ScheduleGroup topGroup;
    protected RandomScheduleGroup randGroup;
    protected ScheduleGroup lastGroup;
    protected ScheduleGroup groupToExecute;
    protected boolean preExecuted = false;
    protected long indexCount = 0L;

    public ScheduleBase() {
        this(1.0);
    }

    public ScheduleBase(double d) {
        this.repeatInterval = d;
        this.topGroup = new ScheduleGroup(this.actionQueue);
        this.lastGroup = new ScheduleGroup(this.lastQueue);
        this.randGroup = new RandomScheduleGroup(this.actionQueue);
        this.topGroup.addBasicAction(this.randGroup);
        this.topGroup.addBasicAction(this.lastGroup);
    }

    public BasicAction scheduleActionAt(double d, BasicAction basicAction) {
        return this.scheduleActionAt(d, basicAction, CONCURRENT, 0.0);
    }

    public BasicAction scheduleActionAt(double d, BasicAction basicAction, Order order) {
        return this.scheduleActionAt(d, basicAction, order, 0.0);
    }

    protected BasicAction scheduleActionAt(double d, BasicAction basicAction, Order order, double d2) {
        if (d == 0.0) {
            d = this.repeatInterval;
        }
        if (d <= this.ticks) {
            return basicAction;
        }
        if (d2 > 0.0) {
            basicAction = new ThreadedAction(basicAction, d2);
        }
        basicAction.setUpdater(2);
        basicAction.nextTime = d;
        if (order == CONCURRENT) {
            this.actionQueue.insert(basicAction);
        } else {
            basicAction.index = ++this.indexCount;
            this.lastQueue.insert(basicAction);
        }
        return basicAction;
    }

    public BasicAction scheduleActionAt(double d, BasicAction basicAction, double d2) {
        return this.scheduleActionAt(d, basicAction, CONCURRENT, d2);
    }

    public BasicAction scheduleActionAtInterval(double d, BasicAction basicAction) {
        return this.scheduleActionAtInterval(d, basicAction, CONCURRENT, 0.0);
    }

    public BasicAction scheduleActionAtInterval(double d, BasicAction basicAction, double d2) {
        return this.scheduleActionAtInterval(d, basicAction, CONCURRENT, d2);
    }

    public BasicAction scheduleActionAtInterval(double d, BasicAction basicAction, Order order) {
        return this.scheduleActionAtInterval(d, basicAction, order, 0.0);
    }

    protected BasicAction scheduleActionAtInterval(double d, BasicAction basicAction, Order order, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Interval must be greater than 0");
        }
        if (d < d2) {
            throw new IllegalArgumentException("Duration must be less than interval");
        }
        if (d2 > 0.0) {
            basicAction = new ThreadedAction(basicAction, d2);
        }
        basicAction.nextTime = this.ticks + d;
        basicAction.intervalTime = d;
        basicAction.setUpdater(1);
        if (order == Schedule.CONCURRENT) {
            this.actionQueue.insert(basicAction);
        } else {
            basicAction.index = ++this.indexCount;
            this.lastQueue.insert(basicAction);
        }
        return basicAction;
    }

    public BasicAction scheduleActionBeginning(double d, BasicAction basicAction) {
        return this.scheduleActionBeginning(d, basicAction, 0.0);
    }

    public BasicAction scheduleActionBeginning(double d, BasicAction basicAction, double d2) {
        if (d == 0.0) {
            d = this.repeatInterval;
        }
        if (this.ticks < d) {
            basicAction.nextTime = d;
            basicAction.intervalTime = this.repeatInterval;
            basicAction.setUpdater(1);
            this.actionQueue.insert(basicAction);
        }
        return basicAction;
    }

    public BasicAction scheduleActionAt(double d, Object object, String string) {
        return this.scheduleActionAt(d, object, string, 0.0);
    }

    public BasicAction scheduleActionAt(double d, Object object, String string, double d2) {
        BasicAction basicAction = ActionUtilities.createActionFor(object, string);
        return this.scheduleActionAt(d, basicAction, d2);
    }

    public BasicAction scheduleActionAt(double d, Object object, String string, Order order) {
        return this.scheduleActionAt(d, object, string, order, 0.0);
    }

    protected BasicAction scheduleActionAt(double d, Object object, String string, Order order, double d2) {
        BasicAction basicAction = ActionUtilities.createActionFor(object, string);
        return this.scheduleActionAt(d, basicAction, order, d2);
    }

    public BasicAction scheduleActionAtInterval(double d, Object object, String string) {
        return this.scheduleActionAtInterval(d, object, string, 0.0);
    }

    public BasicAction scheduleActionAtInterval(double d, Object object, String string, Order order) {
        return this.scheduleActionAtInterval(d, object, string, order, 0.0);
    }

    public BasicAction scheduleActionAtInterval(double d, Object object, String string, double d2) {
        BasicAction basicAction = ActionUtilities.createActionFor(object, string);
        return this.scheduleActionAtInterval(d, basicAction, d2);
    }

    protected BasicAction scheduleActionAtInterval(double d, Object object, String string, Order order, double d2) {
        BasicAction basicAction = ActionUtilities.createActionFor(object, string);
        return this.scheduleActionAtInterval(d, basicAction, order, d2);
    }

    public BasicAction scheduleActionBeginning(double d, Object object, String string) {
        return this.scheduleActionBeginning(d, object, string, 0.0);
    }

    public BasicAction scheduleActionBeginning(double d, Object object, String string, double d2) {
        BasicAction basicAction = ActionUtilities.createActionFor(object, string);
        return this.scheduleActionBeginning(d, basicAction, d2);
    }

    public BasicAction scheduleActionAt(double d, List list, String string) {
        return this.scheduleActionAt(d, list, string, 0.0);
    }

    public BasicAction scheduleActionAt(double d, List list, String string, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEach(list, string);
        return this.scheduleActionAt(d, basicAction, d2);
    }

    public BasicAction scheduleActionAtRnd(double d, List list, String string) {
        return this.scheduleActionAtRnd(d, list, string, 0.0);
    }

    public BasicAction scheduleActionAtRnd(double d, List list, String string, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEachRnd(list, string);
        return this.scheduleActionAt(d, basicAction, d2);
    }

    public BasicAction scheduleActionAt(double d, List list, String string, Order order) {
        return this.scheduleActionAt(d, list, string, order, 0.0);
    }

    protected BasicAction scheduleActionAt(double d, List list, String string, Order order, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEach(list, string);
        return this.scheduleActionAt(d, basicAction, order, d2);
    }

    public BasicAction scheduleActionAtRnd(double d, List list, String string, Order order) {
        return this.scheduleActionAtRnd(d, list, string, order, 0.0);
    }

    protected BasicAction scheduleActionAtRnd(double d, List list, String string, Order order, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEachRnd(list, string);
        return this.scheduleActionAt(d, basicAction, order, d2);
    }

    public BasicAction scheduleActionAtInterval(double d, List list, String string, Order order) {
        return this.scheduleActionAtInterval(d, list, string, order, 0.0);
    }

    protected BasicAction scheduleActionAtInterval(double d, List list, String string, Order order, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEach(list, string);
        return this.scheduleActionAtInterval(d, basicAction, order, d2);
    }

    public BasicAction scheduleActionAtIntervalRnd(double d, List list, String string, Order order) {
        return this.scheduleActionAtIntervalRnd(d, list, string, order, 0.0);
    }

    protected BasicAction scheduleActionAtIntervalRnd(double d, List list, String string, Order order, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEachRnd(list, string);
        return this.scheduleActionAtInterval(d, basicAction, order, d2);
    }

    public BasicAction scheduleActionAtInterval(double d, List list, String string) {
        return this.scheduleActionAtInterval(d, list, string, 0.0);
    }

    public BasicAction scheduleActionAtInterval(double d, List list, String string, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEach(list, string);
        return this.scheduleActionAtInterval(d, basicAction, d2);
    }

    public BasicAction scheduleActionAtIntervalRnd(double d, List list, String string) {
        return this.scheduleActionAtIntervalRnd(d, list, string, 0.0);
    }

    public BasicAction scheduleActionAtIntervalRnd(double d, List list, String string, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEachRnd(list, string);
        return this.scheduleActionAtInterval(d, basicAction, d2);
    }

    public BasicAction scheduleActionBeginning(double d, List list, String string) {
        return this.scheduleActionBeginning(d, list, string, 0.0);
    }

    public BasicAction scheduleActionBeginning(double d, List list, String string, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEach(list, string);
        return this.scheduleActionBeginning(d, basicAction, d2);
    }

    public BasicAction scheduleActionBeginningRnd(double d, List list, String string) {
        return this.scheduleActionBeginningRnd(d, list, string, 0.0);
    }

    public BasicAction scheduleActionBeginningRnd(double d, List list, String string, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEachRnd(list, string);
        return this.scheduleActionBeginning(d, basicAction, d2);
    }

    public BasicAction scheduleActionAt(double d, List list, Class clazz, String string) {
        return this.scheduleActionAt(d, list, clazz, string, 0.0);
    }

    public BasicAction scheduleActionAt(double d, List list, Class clazz, String string, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEach(list, clazz, string);
        return this.scheduleActionAt(d, basicAction, d2);
    }

    public BasicAction scheduleActionAtRnd(double d, List list, Class clazz, String string) {
        return this.scheduleActionAtRnd(d, list, clazz, string, 0.0);
    }

    public BasicAction scheduleActionAtRnd(double d, List list, Class clazz, String string, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEachRnd(list, clazz, string);
        return this.scheduleActionAt(d, basicAction, d2);
    }

    public BasicAction scheduleActionAt(double d, List list, Class clazz, String string, Order order) {
        return this.scheduleActionAt(d, list, clazz, string, order, 0.0);
    }

    protected BasicAction scheduleActionAt(double d, List list, Class clazz, String string, Order order, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEach(list, clazz, string);
        return this.scheduleActionAt(d, basicAction, order, d2);
    }

    public BasicAction scheduleActionAtRnd(double d, List list, Class clazz, String string, Order order) {
        return this.scheduleActionAtRnd(d, list, clazz, string, order, 0.0);
    }

    public BasicAction scheduleActionAtRnd(double d, List list, Class clazz, String string, Order order, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEachRnd(list, clazz, string);
        return this.scheduleActionAt(d, basicAction, order, d2);
    }

    public BasicAction scheduleActionAtIntervalRnd(double d, List list, Class clazz, String string) {
        return this.scheduleActionAtIntervalRnd(d, list, clazz, string, 0.0);
    }

    public BasicAction scheduleActionAtIntervalRnd(double d, List list, Class clazz, String string, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEachRnd(list, clazz, string);
        return this.scheduleActionAtInterval(d, basicAction, d2);
    }

    public BasicAction scheduleActionAtInterval(double d, List list, Class clazz, String string, Order order) {
        return this.scheduleActionAtInterval(d, list, clazz, string, order, 0.0);
    }

    protected BasicAction scheduleActionAtInterval(double d, List list, Class clazz, String string, Order order, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEach(list, clazz, string);
        return this.scheduleActionAtInterval(d, basicAction, order, d2);
    }

    public BasicAction scheduleActionAtIntervalRnd(double d, List list, Class clazz, String string, Order order) {
        return this.scheduleActionAtIntervalRnd(d, list, clazz, string, order, 0.0);
    }

    protected BasicAction scheduleActionAtIntervalRnd(double d, List list, Class clazz, String string, Order order, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEachRnd(list, clazz, string);
        return this.scheduleActionAtInterval(d, basicAction, order, d2);
    }

    public BasicAction scheduleActionBeginning(double d, List list, Class clazz, String string) {
        return this.scheduleActionBeginning(d, list, clazz, string, 0.0);
    }

    public BasicAction scheduleActionBeginning(double d, List list, Class clazz, String string, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEach(list, clazz, string);
        return this.scheduleActionBeginning(d, basicAction, d2);
    }

    public BasicAction scheduleActionBeginningRnd(double d, List list, Class clazz, String string) {
        return this.scheduleActionBeginningRnd(d, list, clazz, string, 0.0);
    }

    public BasicAction scheduleActionBeginningRnd(double d, List list, Class clazz, String string, double d2) {
        BasicAction basicAction = ActionUtilities.createActionForEachRnd(list, clazz, string);
        return this.scheduleActionBeginning(d, basicAction, d2);
    }

    public synchronized long getCurrentTime() {
        return (long)this.ticks;
    }

    public synchronized double getCurrentTimeDouble() {
        return this.ticks;
    }

    private synchronized void setTicks(double d) {
        this.ticks = d;
    }

    public void preExecute() {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        if (this.actionQueue.size() > 0) {
            d = this.actionQueue.peekMin().nextTime;
        }
        if (this.lastQueue.size() > 0) {
            d2 = this.lastQueue.peekMin().nextTime;
        }
        if (d == Double.POSITIVE_INFINITY && d2 == Double.POSITIVE_INFINITY) {
            this.randGroup.clear();
            this.groupToExecute = this.randGroup;
            this.preExecuted = true;
            return;
        }
        if (d < d2) {
            this.fillGroup(d, this.randGroup, this.actionQueue);
            this.groupToExecute = this.randGroup;
        } else if (d2 < d) {
            this.fillGroup(d2, this.lastGroup, this.lastQueue);
            this.lastGroup.indexSort();
            this.groupToExecute = this.lastGroup;
        } else {
            this.fillGroup(d, this.randGroup, this.actionQueue);
            this.fillGroup(d2, this.lastGroup, this.lastQueue);
            this.lastGroup.indexSort();
            this.groupToExecute = this.topGroup;
        }
        this.preExecuted = true;
    }

    private void fillGroup(double d, ScheduleGroup scheduleGroup, ActionQueue actionQueue) {
        double d2 = d;
        scheduleGroup.clear();
        actionQueue.popMin().addToGroup(scheduleGroup);
        if (actionQueue.size() > 0) {
            d = actionQueue.peekMin().nextTime;
            while (d == d2) {
                actionQueue.popMin().addToGroup(scheduleGroup);
                if (actionQueue.size() == 0) break;
                d = actionQueue.peekMin().nextTime;
            }
        }
        if (scheduleGroup.size() > 0) {
            this.setTicks(d2);
        }
    }

    public BasicAction removeAction(BasicAction basicAction) {
        if (this.actionQueue.voidAction(basicAction)) {
            return basicAction;
        }
        return null;
    }

    public void removeActionAt(double d, final BasicAction basicAction) {
        this.scheduleActionAt(d, new BasicAction(){

            public void execute() {
                ScheduleBase.this.removeAction(basicAction);
            }
        }, Schedule.LAST, 0.0);
    }

    public static class Order {
        private int val;

        private Order(int n) {
            this.val = n;
        }
    }
}

