/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import uchicago.src.sim.engine.BatchController;
import uchicago.src.sim.engine.Controller;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.gui.FrameFactory;
import uchicago.src.sim.parameter.ParameterSetter;
import uchicago.src.sim.parameter.ParameterSetterFactory;
import uchicago.src.sim.util.SimUtilities;

public class SimInit {
    public static final String VERSION = "2.2";
    private static boolean noGui = false;
    private boolean exitOnExit = true;
    private static final String USAGE = "\nUsage:\t [-ng -b] [fully_qualified_name_of_model_class] [parameter file | run count]\ne.g java -cp .;sim.jar uchicago.src.sim.SimInit uchicago.src.sim.heatBugs.HeatBugModel\n";
    private int numRuns = 1;

    private void open() {
        Controller controller = new Controller();
        controller.setModel(null);
        controller.display();
    }

    private void open(String string) throws IllegalAccessException {
        this.open(string, false, "");
    }

    public void setNumRuns(int n) {
        this.numRuns = n;
    }

    private void open(String string, boolean bl, String string2) throws IllegalAccessException {
        SimModel simModel = null;
        try {
            Class<?> clazz = Class.forName(string);
            simModel = (SimModel)clazz.newInstance();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Model does not implement the SimModel interface");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Can't find " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Can't instantiate " + string);
        }
        this.load(simModel, bl, string2);
    }

    private void load(SimModel simModel, boolean bl, String string) {
        if (!bl) {
            FrameFactory.load(simModel.getClass().getName());
            Controller controller = null;
            if (string.length() == 0) {
                controller = new Controller();
            } else {
                ParameterSetter parameterSetter = null;
                try {
                    parameterSetter = ParameterSetterFactory.createParameterSetter(string);
                }
                catch (Exception exception) {
                    SimUtilities.showError("Error reading parameter file", exception);
                    System.exit(0);
                }
                controller = new Controller(parameterSetter);
            }
            simModel.setController(controller);
            controller.setExitOnExit(this.exitOnExit);
            controller.setModel(simModel);
            simModel.addSimEventListener(controller);
            if (noGui) {
                controller.loadAndStart();
            } else {
                controller.display();
            }
        } else {
            ParameterSetter parameterSetter = null;
            if (string != null && string.trim().length() > 0) {
                try {
                    parameterSetter = ParameterSetterFactory.createParameterSetter(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    SimUtilities.showError("Initialization error", exception);
                    System.exit(0);
                }
            } else {
                parameterSetter = ParameterSetterFactory.createSingleSetParameterSetter(this.numRuns);
            }
            BatchController batchController = new BatchController(parameterSetter);
            simModel.setController(batchController);
            batchController.setModel(simModel);
            simModel.addSimEventListener(batchController);
            batchController.begin();
        }
    }

    public void loadModel(SimModel simModel, String string, boolean bl) {
        if (string == null) {
            string = "";
        }
        this.load(simModel, bl, string);
    }

    public void setExitOnExit(boolean bl) {
        this.exitOnExit = bl;
    }

    public static void main(String[] stringArray) {
        try {
            SimInit simInit = new SimInit();
            if (stringArray.length == 0) {
                simInit.open();
            } else if (stringArray[0].startsWith("-")) {
                if (stringArray[0].equals("-ng")) {
                    noGui = true;
                    simInit.open(stringArray[1]);
                } else if (stringArray[0].equals("-v")) {
                    System.out.println("RePast Version: 2.2");
                    System.exit(0);
                } else if (stringArray[0].equals("-b")) {
                    if (stringArray.length < 2) {
                        System.out.println("Model argument is missing.\nSpecify a model class name");
                        System.exit(0);
                    } else if (stringArray.length == 2) {
                        simInit.open(stringArray[1], true, "");
                    } else {
                        try {
                            simInit.numRuns = Integer.parseInt(stringArray[2]);
                            simInit.open(stringArray[1], true, "");
                        }
                        catch (NumberFormatException numberFormatException) {
                            simInit.open(stringArray[1], true, stringArray[2]);
                        }
                    }
                } else {
                    System.out.println("Invalid option");
                    System.out.println(USAGE);
                    System.exit(0);
                }
            } else if (stringArray.length > 1) {
                simInit.open(stringArray[0], false, stringArray[1]);
            } else {
                simInit.open(stringArray[0]);
            }
        }
        catch (Exception exception) {
            SimUtilities.showError("Initialization error", exception);
            exception.printStackTrace();
            System.exit(0);
        }
    }
}

