/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import cern.jet.random.Uniform;
import java.util.Hashtable;
import java.util.Vector;
import uchicago.src.reflector.Introspector;
import uchicago.src.sim.engine.IController;
import uchicago.src.sim.engine.ModelManipulator;
import uchicago.src.sim.engine.PropertyEvent;
import uchicago.src.sim.engine.PropertyListener;
import uchicago.src.sim.engine.SimEvent;
import uchicago.src.sim.engine.SimEventListener;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.gui.DisplaySurface;
import uchicago.src.sim.gui.MediaProducer;
import uchicago.src.sim.gui.ProducerNamePair;
import uchicago.src.sim.util.Random;
import uchicago.src.sim.util.SimUtilities;

public abstract class SimModelImpl
implements SimModel {
    private static final int NUMERIC = 1;
    private static final int STRING = 2;
    private static final int BOOLEAN = 3;
    private static final int OBJECT = 4;
    private Vector listenerList = new Vector();
    private Vector propertyListeners = new Vector();
    private IController controller;
    private Vector producers = new Vector();
    protected Hashtable descriptors = new Hashtable(5);
    protected ModelManipulator modelManipulator = new ModelManipulator();

    public SimModelImpl() {
        this.generateNewSeed();
    }

    public void generateNewSeed() {
        Uniform.staticSetRandomEngine(Random.generateNewSeed());
        Random.createUniform();
        this.fireSimEvent(new SimEvent(this, 3));
    }

    public void setRngSeed(long l) {
        Uniform.makeDefaultGenerator();
        Uniform.staticSetRandomEngine(Random.getGenerator(l));
        Random.createUniform();
        this.fireSimEvent(new SimEvent(this, 3));
    }

    public long getRngSeed() {
        return Random.getSeed();
    }

    public double getTickCount() {
        return this.controller.getCurrentTime();
    }

    public void setController(IController iController) {
        this.controller = iController;
    }

    public IController getController() {
        return this.controller;
    }

    public String getPropertiesValues() {
        Introspector introspector = new Introspector();
        String string = System.getProperty("line.separator");
        try {
            introspector.introspect(this, this.getInitParam());
            return "RngSeed: " + Random.getSeed() + string + introspector.getPropertiesValues();
        }
        catch (Exception exception) {
            SimUtilities.showError("Unable to return model parameters and values", exception);
            exception.printStackTrace();
            System.exit(0);
            return "";
        }
    }

    public ModelManipulator getModelManipulator() {
        return this.modelManipulator;
    }

    public Vector getMediaProducers() {
        return this.producers;
    }

    public void registerDisplaySurface(String string, DisplaySurface displaySurface) {
        if (!this.listenerList.contains(displaySurface)) {
            this.addSimEventListener(displaySurface);
        }
        this.registerMediaProducer(string, displaySurface);
    }

    public void registerMediaProducer(String string, MediaProducer mediaProducer) {
        ProducerNamePair producerNamePair = new ProducerNamePair(string, mediaProducer);
        int n = 0;
        n = this.producers.indexOf(producerNamePair);
        if (n != -1) {
            this.producers.remove(n);
        }
        this.producers.add(producerNamePair);
    }

    public void clearMediaProducers() {
        for (int i = 0; i < this.producers.size(); ++i) {
            ProducerNamePair producerNamePair = (ProducerNamePair)this.producers.get(i);
            if (!(producerNamePair.getProducer() instanceof DisplaySurface)) continue;
            this.removeSimEventListener((SimEventListener)((Object)producerNamePair.getProducer()));
        }
        this.producers.clear();
    }

    public void clearPropertyListeners() {
        this.propertyListeners.clear();
    }

    public Hashtable getParameterDescriptors() {
        return this.descriptors;
    }

    public void addSimEventListener(SimEventListener simEventListener) {
        if (!this.listenerList.contains(simEventListener)) {
            this.listenerList.add(simEventListener);
        }
    }

    public void removeSimEventListener(SimEventListener simEventListener) {
        this.listenerList.remove(simEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSimEvent(SimEvent simEvent) {
        Vector vector;
        Vector vector2 = this.listenerList;
        synchronized (vector2) {
            vector = (Vector)this.listenerList.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            SimEventListener simEventListener = (SimEventListener)vector.elementAt(i);
            simEventListener.simEventPerformed(simEvent);
        }
    }

    protected void addPropertyListener(PropertyListener propertyListener) {
        this.propertyListeners.add(propertyListener);
    }

    protected void removePropertyListener(PropertyListener propertyListener) {
        this.propertyListeners.remove(propertyListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyEvent(PropertyEvent propertyEvent, int n) {
        Vector vector;
        Vector vector2 = this.propertyListeners;
        synchronized (vector2) {
            vector = (Vector)this.propertyListeners.clone();
        }
        switch (n) {
            case 1: {
                for (int i = 0; i < vector.size(); ++i) {
                    PropertyListener propertyListener = (PropertyListener)vector.get(i);
                    propertyListener.numericPropertyChanged(propertyEvent);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < vector.size(); ++i) {
                    PropertyListener propertyListener = (PropertyListener)vector.get(i);
                    propertyListener.stringPropertyChanged(propertyEvent);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < vector.size(); ++i) {
                    PropertyListener propertyListener = (PropertyListener)vector.get(i);
                    propertyListener.booleanPropertyChanged(propertyEvent);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < vector.size(); ++i) {
                    PropertyListener propertyListener = (PropertyListener)vector.get(i);
                    propertyListener.objectPropertyChanged(propertyEvent);
                }
                break;
            }
        }
    }

    public void pause() {
        this.firePauseSim();
    }

    public void stop() {
        this.fireStopSim();
    }

    public void fireNumericPropertyEvent(PropertyEvent propertyEvent) {
        this.firePropertyEvent(propertyEvent, 1);
    }

    public void fireStringPropertyEvent(PropertyEvent propertyEvent) {
        this.firePropertyEvent(propertyEvent, 2);
    }

    public void fireBooleanPropertyEvent(PropertyEvent propertyEvent) {
        this.firePropertyEvent(propertyEvent, 3);
    }

    public void fireObjectPropertyEvent(PropertyEvent propertyEvent) {
        this.firePropertyEvent(propertyEvent, 4);
    }

    protected void fireStopSim() {
        this.fireSimEvent(new SimEvent(this, 0));
    }

    protected void firePauseSim() {
        this.fireSimEvent(new SimEvent(this, 1));
    }

    protected void fireEndSim() {
        this.fireSimEvent(new SimEvent(this, 2));
    }
}

