/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uchicago.src.guiUtils.GuiUtilities;
import uchicago.src.sim.util.SimUtilities;

public class LoadModelDialog {
    private JDialog dialog = null;
    private JTextField fldClassPath = new JTextField();
    private JButton btnArchiveBrowse = new JButton("Browse");
    private JLabel lblPath = new JLabel("Model Archive/Path: ");
    private JLabel lblModel = new JLabel("Model Name: ", 2);
    private JTextField fldModel = new JTextField();
    private JButton load = new JButton("Load");
    private JButton cancel = new JButton("Cancel");
    private JPanel mainPanel = new JPanel();
    private JFrame frame = null;
    private String modelName = "";
    private URL[] urls = null;
    private Action archiveBrowse = new AbstractAction("browse"){

        public void actionPerformed(ActionEvent actionEvent) {
            FileDialog fileDialog = new FileDialog((Frame)LoadModelDialog.this.frame, "Class Path", 0);
            fileDialog.show();
            String string = fileDialog.getFile();
            if (string == null) {
                return;
            }
            string = fileDialog.getDirectory() + string;
            fileDialog.dispose();
            LoadModelDialog.this.fldClassPath.setText(string);
        }
    };

    public LoadModelDialog() {
        this.guiInit();
        this.addListeners();
    }

    private void guiInit() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.load);
        jPanel.add(this.cancel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this.lblPath, gridBagConstraints);
        gridBagConstraints.gridy = -1;
        jPanel2.add((Component)this.lblModel, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.fldClassPath, gridBagConstraints);
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this.fldModel, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this.btnArchiveBrowse, gridBagConstraints);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)jPanel2, "Center");
        this.mainPanel.add((Component)jPanel, "South");
    }

    private void addListeners() {
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoadModelDialog.this.exit();
            }
        });
        this.btnArchiveBrowse.addActionListener(this.archiveBrowse);
        this.load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoadModelDialog.this.doLoad();
            }
        });
    }

    private void exit() {
        this.dialog.dispose();
    }

    public void display(JFrame jFrame) {
        this.frame = jFrame;
        this.dialog = new JDialog(jFrame, "Load Model", true);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LoadModelDialog.this.exit();
            }
        });
        Container container = this.dialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.mainPanel, "Center");
        this.dialog.setSize(455, 125);
        GuiUtilities.centerComponentOnScreen(this.dialog);
        this.dialog.setVisible(true);
    }

    public String getModelName() {
        return this.modelName;
    }

    public URL[] getUrls() {
        return this.urls;
    }

    private String fixPath(String string) {
        File file = new File(string);
        if (!((string = file.getAbsolutePath()).endsWith(".jar") || string.endsWith(".zip") || string.endsWith("/"))) {
            string = string + "/";
        }
        return string;
    }

    private void processPath(String string) throws MalformedURLException {
        String string2 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        if (stringTokenizer.countTokens() == 0) {
            System.out.println("no tokens");
            this.urls = new URL[1];
            string = this.fixPath(string);
            this.urls[0] = new URL("file:/" + string);
        } else {
            this.urls = new URL[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                string3 = this.fixPath(string3);
                this.urls[n++] = new URL("file:/" + string);
            }
        }
    }

    private void doLoad() {
        String string = this.fldClassPath.getText();
        this.modelName = this.fldModel.getText();
        if (this.modelName.length() < 1 || string.length() < 1) {
            SimUtilities.showMessage("Missing model name, class path or archive");
            return;
        }
        try {
            this.processPath(string);
        }
        catch (MalformedURLException malformedURLException) {
            SimUtilities.showMessage("Badly formed archive or path name");
            return;
        }
        this.exit();
    }
}

