/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gis;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;

public class GisUtilities {
    private static GeometryFactory gf;
    public static final int METERS = 6367000;
    public static final int KILOMETERS = 6367;
    public static final int MILES = 3956;

    public static GeometryFactory getGeometryFactory() {
        if (gf == null) {
            gf = new GeometryFactory();
        }
        return gf;
    }

    public static double polygonArea(Coordinate[] coordinateArray, int n) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            int n2 = (i + 1) % n;
            d += coordinateArray[i].x * coordinateArray[n2].y;
            d -= coordinateArray[i].y * coordinateArray[n2].x;
        }
        return (d /= 2.0) < 0.0 ? -d : d;
    }

    public static Coordinate getPolygonCenterOfMass(Geometry geometry) {
        Coordinate[] coordinateArray = geometry.getCoordinates();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = GisUtilities.polygonArea(coordinateArray, coordinateArray.length);
        Coordinate coordinate = new Coordinate();
        double d4 = 0.0;
        if (coordinateArray.length < 3) {
            return coordinateArray[0];
        }
        for (int i = 0; i < coordinateArray.length; ++i) {
            int n = (i + 1) % coordinateArray.length;
            d4 = coordinateArray[i].x * coordinateArray[n].y - coordinateArray[n].x * coordinateArray[i].y;
            d += (coordinateArray[i].x + coordinateArray[n].x) * d4;
            d2 += (coordinateArray[i].y + coordinateArray[n].y) * d4;
        }
        if ((d3 *= 6.0) == 0.0) {
            System.out.println("no area");
        }
        d4 = 1.0 / d3;
        coordinate.x = (d *= d4) * -1.0;
        coordinate.y = (d2 *= d4) * -1.0;
        return coordinate;
    }

    public static double getDistance(Coordinate coordinate, Coordinate coordinate2, int n) {
        double d = coordinate.x;
        double d2 = coordinate2.x;
        double d3 = coordinate.y;
        double d4 = coordinate2.y;
        return GisUtilities.getDistance(d, d2, d3, d4, n);
    }

    public static double getDistance(Coordinate coordinate, Coordinate coordinate2) {
        return GisUtilities.getDistance(coordinate, coordinate2, 6367);
    }

    public static double getDistance(double d, double d2, double d3, double d4) {
        return GisUtilities.getDistance(d, d2, d3, d4, 6367);
    }

    public static double getDistance(double d, double d2, double d3, double d4, int n) {
        double d5 = (d *= Math.PI / 180) - (d2 *= Math.PI / 180);
        double d6 = (d3 *= Math.PI / 180) - (d4 *= Math.PI / 180);
        double d7 = Math.pow(Math.sin(d6 / 2.0), 2.0) + Math.cos(d3) * Math.cos(d4) * Math.pow(Math.sin(d5 / 2.0), 2.0);
        double d8 = 2.0 * Math.atan2(Math.sqrt(d7), Math.sqrt(1.0 - d7));
        return (double)n * d8;
    }
}

