/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gis;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.util.Enumeration;
import java.util.Hashtable;
import org.geotools.feature.Feature;
import org.geotools.feature.IllegalFeatureException;
import uchicago.src.sim.gis.GisUtilities;
import uchicago.src.sim.gis.LinePoint;
import uchicago.src.sim.gis.PointAdapter;
import uchicago.src.sim.gis.RepastGisFeature;
import uchicago.src.sim.gis.SpatialNode;
import uchicago.src.sim.network.DefaultEdge;
import uchicago.src.sim.util.SimUtilities;

public class LineStringAdapter
extends DefaultEdge
implements RepastGisFeature {
    protected Hashtable attributes;
    protected Geometry geometry;
    protected LinePoint[] points;
    final String type = "LineStringAdapter";
    String label;
    double strength = 0.0;
    protected boolean multi = false;

    public LineStringAdapter(SpatialNode spatialNode, SpatialNode spatialNode2) {
        super(spatialNode, spatialNode2);
        GeometryFactory geometryFactory = GisUtilities.getGeometryFactory();
        Coordinate[] coordinateArray = new Coordinate[]{new Coordinate(spatialNode.getX(), spatialNode.getY()), new Coordinate(spatialNode2.getX(), spatialNode2.getY())};
        this.setGeometry((Geometry)geometryFactory.createLineString(coordinateArray));
    }

    public LineStringAdapter(Feature feature) throws Exception {
        try {
            this.setFeature(feature);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SimUtilities.showError("the feature cannot be created", illegalArgumentException);
        }
        catch (IllegalFeatureException illegalFeatureException) {
            SimUtilities.showError("the feature cannot be created", (Exception)((Object)illegalFeatureException));
        }
    }

    public LineStringAdapter(Geometry geometry, Hashtable hashtable) throws Exception {
        try {
            this.setGeometry(geometry);
            this.setAttributes(hashtable);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SimUtilities.showError("the feature cannot be created", illegalArgumentException);
        }
    }

    public double getLength() {
        double d = 0.0;
        for (int i = 0; i < this.points.length - 1; ++i) {
            d += GisUtilities.getDistance(this.points[i].getX(), this.points[i + 1].getX(), this.points[i].getY(), this.points[i + 1].getY());
        }
        return d;
    }

    public void setGeometry(Geometry geometry) throws IllegalArgumentException {
        if (!geometry.getGeometryType().toLowerCase().equals("linestring") && !geometry.getGeometryType().toLowerCase().equals("multilinestring")) {
            throw new IllegalArgumentException("This is not a linestring, it is a " + geometry.getGeometryType());
        }
        if (geometry.getGeometryType().toLowerCase().startsWith("multi")) {
            this.multi = true;
        }
        LineString lineString = (LineString)geometry;
        super.setFrom(new PointAdapter(lineString.getStartPoint()));
        super.setTo(new PointAdapter(lineString.getEndPoint()));
        Coordinate[] coordinateArray = lineString.getCoordinates();
        this.points = new LinePoint[coordinateArray.length];
        this.points[0] = new LinePoint(coordinateArray[0]);
        this.points[0].setToPoint(this.points[1]);
        if (this.points.length < 3) {
            this.points[1] = new LinePoint(coordinateArray[1]);
            this.points[1].setFromPoint(this.points[0]);
            this.strength += GisUtilities.getDistance(coordinateArray[0], coordinateArray[1]);
        } else {
            for (int i = 1; i < coordinateArray.length - 1; ++i) {
                this.points[i] = new LinePoint(coordinateArray[i]);
                this.strength += GisUtilities.getDistance(coordinateArray[i], coordinateArray[i - 1]);
                this.points[i].setFromPoint(this.points[i - 1]);
                this.points[i].setToPoint(this.points[i + 1]);
            }
            this.points[this.points.length - 1] = new LinePoint(coordinateArray[this.points.length - 1]);
            this.points[this.points.length - 1].setFromPoint(this.points[this.points.length - 2]);
            this.strength += GisUtilities.getDistance(coordinateArray[this.points.length - 1], coordinateArray[this.points.length - 2]);
        }
    }

    public void setFeature(Feature feature) throws Exception {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(feature.getSchema().attributeTotal());
        for (int i = 1; i < feature.getSchema().attributeTotal(); ++i) {
            String string = feature.getSchema().getAttributeType(i).getName();
            Object object = feature.getAttribute(string);
            hashtable.put(string, object);
        }
        this.setAttributes(hashtable);
        this.setGeometry(feature.getDefaultGeometry());
    }

    public void setAttributes(Hashtable hashtable) {
        this.attributes = hashtable;
    }

    public String[] getAttributeNames() {
        Enumeration enumeration = this.attributes.keys();
        String[] stringArray = new String[this.attributes.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public void addAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public boolean intersects(RepastGisFeature repastGisFeature) {
        return this.geometry.intersects(repastGisFeature.getGeometry());
    }

    public boolean touches(RepastGisFeature repastGisFeature) {
        return this.geometry.touches(repastGisFeature.getGeometry());
    }

    public boolean within(RepastGisFeature repastGisFeature) {
        return this.geometry.within(repastGisFeature.getGeometry());
    }

    public boolean crosses(RepastGisFeature repastGisFeature) {
        return this.geometry.within(repastGisFeature.getGeometry());
    }

    public boolean overlaps(RepastGisFeature repastGisFeature) {
        return this.geometry.overlaps(repastGisFeature.getGeometry());
    }

    public boolean disjoint(RepastGisFeature repastGisFeature) {
        return this.geometry.disjoint(repastGisFeature.getGeometry());
    }
}

