/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gis;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import org.geotools.feature.Feature;
import org.geotools.feature.IllegalFeatureException;
import uchicago.src.sim.gis.RepastGisFeature;
import uchicago.src.sim.gis.SpatialNode;
import uchicago.src.sim.network.DefaultNode;
import uchicago.src.sim.util.SimUtilities;

public class PointAdapter
extends DefaultNode
implements RepastGisFeature,
SpatialNode {
    protected Hashtable attributes;
    protected Geometry geo;
    protected boolean multi = false;
    final String type = "PointAdapter";

    public PointAdapter() {
        this.attributes = new Hashtable();
        this.geo = null;
    }

    public PointAdapter(Point point) {
        this.attributes = new Hashtable();
        this.geo = point;
    }

    public PointAdapter(Feature feature) throws Exception {
        try {
            this.setFeature(feature);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SimUtilities.showError("the feature cannot be created", illegalArgumentException);
        }
        catch (IllegalFeatureException illegalFeatureException) {
            SimUtilities.showError("the feature cannot be created", (Exception)((Object)illegalFeatureException));
        }
    }

    public void setFeature(Feature feature) throws Exception {
        this.attributes = new Hashtable(feature.getSchema().attributeTotal());
        for (int i = 1; i < feature.getSchema().attributeTotal(); ++i) {
            String string = feature.getSchema().getAttributeType(i).getName();
            Object object = feature.getAttribute(string);
            this.attributes.put(string, object);
        }
        this.setGeometry(feature.getDefaultGeometry());
    }

    public void setGeometry(Geometry geometry) throws IllegalArgumentException {
        if (!geometry.getGeometryType().toLowerCase().equals("point") && !geometry.getGeometryType().toLowerCase().equals("multipoint")) {
            throw new IllegalArgumentException("This is not a point, it is a " + geometry.getGeometryType());
        }
        if (geometry.getGeometryType().toLowerCase().startsWith("multi")) {
            this.multi = true;
        }
        this.geo = geometry;
    }

    public void setAttributes(Hashtable hashtable) {
        this.attributes = hashtable;
    }

    public String[] getAttributeNames() {
        Enumeration enumeration = this.attributes.keys();
        String[] stringArray = new String[this.attributes.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public Geometry getGeometry() {
        return this.geo;
    }

    public double getX() {
        return this.geo.getCoordinates()[0].x;
    }

    public double getY() {
        return this.geo.getCoordinates()[0].y;
    }

    public double getZ() {
        return this.geo.getCoordinates()[0].z;
    }

    public void setX(double d) {
    }

    public void setY(double d) {
    }

    public void setZ(double d) {
    }

    public Coordinate getCoordinates() {
        return this.geo.getCoordinates()[0];
    }

    public void addAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public boolean isMulti() {
        return this.multi;
    }

    public boolean intersects(RepastGisFeature repastGisFeature) {
        return this.geo.intersects(repastGisFeature.getGeometry());
    }

    public boolean touches(RepastGisFeature repastGisFeature) {
        return this.geo.touches(repastGisFeature.getGeometry());
    }

    public boolean within(RepastGisFeature repastGisFeature) {
        return this.geo.within(repastGisFeature.getGeometry());
    }

    public boolean crosses(RepastGisFeature repastGisFeature) {
        return this.geo.within(repastGisFeature.getGeometry());
    }

    public boolean overlaps(RepastGisFeature repastGisFeature) {
        return this.geo.overlaps(repastGisFeature.getGeometry());
    }

    public boolean disjoint(RepastGisFeature repastGisFeature) {
        return this.geo.disjoint(repastGisFeature.getGeometry());
    }
}

