/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gis;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Enumeration;
import java.util.Hashtable;
import org.geotools.feature.Feature;
import org.geotools.feature.IllegalFeatureException;
import uchicago.src.sim.gis.LinePoint;
import uchicago.src.sim.gis.RepastGisFeature;
import uchicago.src.sim.network.DefaultNode;
import uchicago.src.sim.util.SimUtilities;

public class PolygonAdapter
extends DefaultNode
implements RepastGisFeature {
    protected Hashtable attributes;
    protected Geometry geometry;
    protected LinePoint[] points;
    final String type = "PolygonAdapter";
    protected String label;
    protected boolean multi = false;

    public PolygonAdapter() {
        this.attributes = new Hashtable();
        this.geometry = null;
    }

    public PolygonAdapter(Feature feature) {
        try {
            this.setFeature(feature);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SimUtilities.showError("the feature cannot be created", illegalArgumentException);
        }
        catch (IllegalFeatureException illegalFeatureException) {
            SimUtilities.showError("the feature cannot be created", (Exception)((Object)illegalFeatureException));
        }
    }

    public PolygonAdapter(Geometry geometry, Hashtable hashtable) {
        try {
            this.setGeometry(geometry);
            this.setAttributes(hashtable);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SimUtilities.showError("the feature cannot be created", illegalArgumentException);
        }
    }

    public void setFeature(Feature feature) throws IllegalArgumentException, IllegalFeatureException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(feature.getSchema().attributeTotal());
        for (int i = 1; i < feature.getSchema().attributeTotal(); ++i) {
            String string = feature.getSchema().getAttributeType(i).getName();
            Object object = feature.getAttribute(string);
            hashtable.put(string, object);
        }
        this.setAttributes(hashtable);
        this.setGeometry(feature.getDefaultGeometry());
    }

    public String[] getAttributeNames() {
        Enumeration enumeration = this.attributes.keys();
        String[] stringArray = new String[this.attributes.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public void addAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Geometry geometry) throws IllegalArgumentException {
        if (!geometry.getGeometryType().toLowerCase().equals("polygon") && !geometry.getGeometryType().toLowerCase().equals("multipolygon")) {
            throw new IllegalArgumentException("This is not a polygon, it is a " + geometry.getGeometryType());
        }
        if (geometry.getGeometryType().toLowerCase().startsWith("multi")) {
            this.multi = true;
        }
        this.geometry = geometry;
    }

    public void setAttributes(Hashtable hashtable) {
        this.attributes = hashtable;
    }

    public Hashtable getAttributes() {
        return this.attributes;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public boolean intersects(RepastGisFeature repastGisFeature) {
        return this.geometry.intersects(repastGisFeature.getGeometry());
    }

    public boolean touches(RepastGisFeature repastGisFeature) {
        return this.geometry.touches(repastGisFeature.getGeometry());
    }

    public boolean within(RepastGisFeature repastGisFeature) {
        return this.geometry.within(repastGisFeature.getGeometry());
    }

    public boolean crosses(RepastGisFeature repastGisFeature) {
        return this.geometry.within(repastGisFeature.getGeometry());
    }

    public boolean overlaps(RepastGisFeature repastGisFeature) {
        return this.geometry.overlaps(repastGisFeature.getGeometry());
    }

    public boolean disjoint(RepastGisFeature repastGisFeature) {
        return this.geometry.disjoint(repastGisFeature.getGeometry());
    }
}

