/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import cern.colt.map.OpenIntObjectHashMap;
import java.awt.Color;

public class ColorMap {
    public static final Color white = new Color(255, 255, 255);
    public static final Color lightGray = new Color(192, 192, 192);
    public static final Color gray = new Color(128, 128, 128);
    public static final Color darkGray = new Color(64, 64, 64);
    public static final Color black = new Color(0, 0, 0);
    public static final Color red = new Color(255, 0, 0);
    public static final Color pink = new Color(255, 175, 175);
    public static final Color orange = new Color(255, 200, 0);
    public static final Color yellow = new Color(255, 255, 0);
    public static final Color green = new Color(0, 255, 0);
    public static final Color magenta = new Color(255, 0, 255);
    public static final Color cyan = new Color(0, 255, 255);
    public static final Color blue = new Color(0, 0, 255);
    private OpenIntObjectHashMap map = new OpenIntObjectHashMap();

    public void mapColor(Integer n, Color color) {
        this.map.put(n, color);
    }

    public void mapColor(int n, Color color) {
        this.map.put(n, color);
    }

    public void mapColor(int n, double d, double d2, double d3) {
        if (d < 0.0 || d2 < 0.0 || d3 < 0.0) {
            throw new IllegalArgumentException("Red, green, and blue must be >= 0");
        }
        if (d >= 1.0) {
            d = 1.0;
        }
        if (d3 >= 1.0) {
            d3 = 1.0;
        }
        if (d2 >= 1.0) {
            d2 = 1.0;
        }
        int n2 = (int)(255.0 * d);
        int n3 = (int)(255.0 * d2);
        int n4 = (int)(255.0 * d3);
        this.map.put(n, new Color(n2, n3, n4));
    }

    public Color getColor(Integer n) {
        return (Color)this.map.get(n);
    }

    public Color getColor(int n) {
        return (Color)this.map.get(n);
    }
}

