/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;
import java.awt.Color;
import java.util.Hashtable;
import org.geotools.feature.Feature;
import uchicago.src.sim.gis.GisUtilities;
import uchicago.src.sim.gis.LineStringAdapter;
import uchicago.src.sim.gis.SpatialNode;
import uchicago.src.sim.gui.DrawableGisFeature;
import uchicago.src.sim.gui.DrawableMultiFeature;
import uchicago.src.sim.gui.SimGraphics;

public class DrawableLineString
extends LineStringAdapter
implements DrawableGisFeature,
DrawableMultiFeature {
    private Color color = Color.black;
    private String label;

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public DrawableLineString(SpatialNode spatialNode, SpatialNode spatialNode2) {
        super(spatialNode, spatialNode2);
    }

    public DrawableLineString(Feature feature) throws Exception {
        super(feature);
    }

    public DrawableLineString(Geometry geometry, Hashtable hashtable) throws Exception {
        super(geometry, hashtable);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Coordinate[] getCoords() {
        return this.getGeometry().getCoordinates();
    }

    public boolean contains(double d, double d2) {
        Point point = GisUtilities.getGeometryFactory().createPoint(new Coordinate(d, d2));
        return this.geometry.touches((Geometry)point);
    }

    public void draw(SimGraphics simGraphics) {
        simGraphics.drawLine(this.color);
    }

    public int[] getFeatures() {
        GeometryCollection geometryCollection = (GeometryCollection)this.geometry;
        int[] nArray = new int[geometryCollection.getNumGeometries()];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n + geometryCollection.getGeometryN(i).getCoordinates().length;
        }
        return nArray;
    }
}

