/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;
import java.awt.Color;
import java.util.Hashtable;
import org.geotools.feature.Feature;
import uchicago.src.sim.gis.GisUtilities;
import uchicago.src.sim.gis.PolygonAdapter;
import uchicago.src.sim.gui.DrawableGisFeature;
import uchicago.src.sim.gui.DrawableMultiFeature;
import uchicago.src.sim.gui.SimGraphics;

public class DrawablePolygon
extends PolygonAdapter
implements DrawableMultiFeature,
DrawableGisFeature {
    Color color = Color.red;
    boolean fill = false;
    boolean transparent = false;

    public String getLabel() {
        return this.getNodeLabel();
    }

    public void setLabel(String string) {
        this.setNodeLabel(string);
    }

    public DrawablePolygon(Feature feature) {
        super(feature);
    }

    public DrawablePolygon(Geometry geometry, Hashtable hashtable) {
        super(geometry, hashtable);
    }

    public Coordinate[] getCoords() {
        return this.geometry.getCoordinates();
    }

    public boolean contains(double d, double d2) {
        Point point = GisUtilities.getGeometryFactory().createPoint(new Coordinate(d, d2));
        return this.geometry.contains((Geometry)point);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int[] getFeatures() {
        GeometryCollection geometryCollection = (GeometryCollection)this.geometry;
        int[] nArray = new int[geometryCollection.getNumGeometries()];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n + geometryCollection.getGeometryN(i).getCoordinates().length;
        }
        return nArray;
    }

    public void draw(SimGraphics simGraphics) {
        simGraphics.fillPolygon(this.color);
    }
}

