/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.util.ArrayList;
import uchicago.src.sim.gis.GisLayer;
import uchicago.src.sim.gui.DisplayInfo;
import uchicago.src.sim.gui.Displayable;
import uchicago.src.sim.gui.DrawableGisFeature;
import uchicago.src.sim.gui.DrawableMultiFeature;
import uchicago.src.sim.gui.Moveable;
import uchicago.src.sim.gui.Probeable;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.gui.ViewEvent;

public class GisDisplay
implements Displayable,
Probeable {
    ArrayList layers = new ArrayList();
    Envelope bounds = new Envelope();
    int width;
    int nodeWidth = 40;
    int nodeHeight = 20;

    public int getNodeWidth() {
        return this.nodeWidth;
    }

    public void setNodeWidth(int n) {
        this.nodeWidth = n;
    }

    public int getNodeHeight() {
        return this.nodeHeight;
    }

    public void setNodeHeight(int n) {
        this.nodeHeight = n;
    }

    public GisDisplay() {
    }

    public GisDisplay(int n) {
        this.width = n;
    }

    public void addLayer(GisLayer gisLayer) {
        this.layers.add(new ActiveLayer(gisLayer));
        this.bounds.expandToInclude(gisLayer.getBounds());
    }

    public void drawDisplay(SimGraphics simGraphics) {
        for (int i = 0; i < this.layers.size(); ++i) {
            ActiveLayer activeLayer = (ActiveLayer)this.layers.get(i);
            if (!activeLayer.active) continue;
            for (int j = 0; j < activeLayer.l.size(); ++j) {
                DrawableGisFeature drawableGisFeature = (DrawableGisFeature)activeLayer.l.get(j);
                this.drawFeature(drawableGisFeature, simGraphics);
            }
        }
    }

    private void drawFeature(DrawableGisFeature drawableGisFeature, SimGraphics simGraphics) {
        Object object;
        Object object2;
        Coordinate[] coordinateArray = drawableGisFeature.getCoords();
        if (coordinateArray.length == 1) {
            object2 = this.scalePoint(coordinateArray[0]);
            simGraphics.setDrawingParameters((int)((float)this.nodeWidth * simGraphics.getXScale()), (int)((float)this.nodeHeight * simGraphics.getYScale()), 0);
            simGraphics.setDrawingCoordinates(object2.x, object2.y, 0.0f);
            drawableGisFeature.draw(simGraphics);
        }
        object2 = new int[coordinateArray.length];
        int[] nArray = new int[coordinateArray.length];
        for (int i = 0; i < coordinateArray.length; ++i) {
            object = this.scalePoint(coordinateArray[i]);
            object2[i] = ((IntPoint)object).x;
            nArray[i] = ((IntPoint)object).y;
        }
        if (drawableGisFeature.isMulti()) {
            DrawableMultiFeature drawableMultiFeature = (DrawableMultiFeature)((Object)drawableGisFeature);
            object = drawableMultiFeature.getFeatures();
            int n = 0;
            for (int i = 0; i < ((Object)object).length; ++i) {
                int[] nArray2 = new int[object[i]];
                int[] nArray3 = new int[object[i]];
                for (int j = 0; j < object[i]; ++j) {
                    nArray2[j] = object2[n];
                    nArray3[j] = nArray[n];
                    ++n;
                }
                simGraphics.setCurLineX(nArray2);
                simGraphics.setCurLineY(nArray3);
                drawableGisFeature.draw(simGraphics);
            }
            return;
        }
        simGraphics.setCurLineX((int[])object2);
        simGraphics.setCurLineY(nArray);
        drawableGisFeature.draw(simGraphics);
    }

    public ArrayList getDisplayableInfo() {
        ArrayList<DisplayInfo> arrayList = new ArrayList<DisplayInfo>();
        for (int i = 0; i < this.layers.size(); ++i) {
            ActiveLayer activeLayer = (ActiveLayer)this.layers.get(i);
            arrayList.add(new DisplayInfo(activeLayer.l.getName(), i, this));
        }
        return arrayList;
    }

    public void viewEventPerformed(ViewEvent viewEvent) {
        boolean bl;
        int n = viewEvent.getId();
        ((ActiveLayer)this.layers.get((int)n)).active = bl = viewEvent.showView();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return (int)((double)this.width * (this.bounds.getHeight() / this.bounds.getWidth()));
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public IntPoint scalePoint(Coordinate coordinate) {
        double d = (double)this.getWidth() / this.bounds.getWidth();
        double d2 = (double)this.getHeight() / this.bounds.getHeight();
        d *= (double)SimGraphics.getInstance().getXScale();
        d2 *= (double)SimGraphics.getInstance().getYScale();
        double d3 = coordinate.x;
        double d4 = coordinate.y;
        d3 -= this.bounds.getMinX();
        d4 -= this.bounds.getMinY();
        IntPoint intPoint = new IntPoint();
        intPoint.x = (int)(d3 *= d);
        intPoint.y = (int)(this.getSize().getHeight() * (double)SimGraphics.getInstance().getYScale() - (d4 *= d2));
        return intPoint;
    }

    public ArrayList getObjectsAt(int n, int n2) {
        double d = (float)n / SimGraphics.getInstance().getXScale();
        double d2 = this.getSize().getHeight() * (double)SimGraphics.getInstance().getYScale() - (double)((float)n2 / SimGraphics.getInstance().getYScale());
        d /= (double)this.getWidth() / this.bounds.getWidth();
        d2 /= (double)this.getHeight() / this.bounds.getHeight();
        d += this.bounds.getMinX();
        d2 += this.bounds.getMinY();
        ArrayList<DrawableGisFeature> arrayList = new ArrayList<DrawableGisFeature>();
        for (int i = 0; i < this.layers.size(); ++i) {
            GisLayer gisLayer = ((ActiveLayer)this.layers.get((int)i)).l;
            for (int j = 0; j < gisLayer.size(); ++j) {
                DrawableGisFeature drawableGisFeature = (DrawableGisFeature)gisLayer.get(j);
                if (!drawableGisFeature.contains(d, d2)) continue;
                arrayList.add(drawableGisFeature);
            }
        }
        return arrayList;
    }

    public void setMoveableXY(Moveable moveable, int n, int n2) {
    }

    class IntPoint {
        int x;
        int y;

        IntPoint() {
        }
    }

    class ActiveLayer {
        public GisLayer l;
        public boolean active = true;

        public ActiveLayer(GisLayer gisLayer) {
            this.l = gisLayer;
        }
    }
}

