/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uchicago.src.sim.gui.DefaultGraphLayout;
import uchicago.src.sim.gui.DisplayInfo;
import uchicago.src.sim.gui.Displayable;
import uchicago.src.sim.gui.DrawableEdge;
import uchicago.src.sim.gui.DrawableNonGridNode;
import uchicago.src.sim.gui.GraphLayout;
import uchicago.src.sim.gui.Moveable;
import uchicago.src.sim.gui.NonGridDrawable;
import uchicago.src.sim.gui.Probeable;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.gui.ViewEvent;
import uchicago.src.sim.gui.Zoomable;
import uchicago.src.sim.network.Edge;
import uchicago.src.sim.network.Node;
import uchicago.src.sim.space.VectorSpace;

public class Network2DDisplay
implements Displayable,
Probeable,
Zoomable {
    protected GraphLayout layout;
    private static final int TOGGLE_EDGE_ON_TOP = 100;
    protected ArrayList edges = new ArrayList(113);
    protected Hashtable nodePoint = new Hashtable(113);
    protected boolean viewNodes = true;
    protected boolean viewLinks = true;
    protected ArrayList tmpList = new ArrayList();
    protected int height;
    protected int width;
    protected HashMap zoomSet = new HashMap();
    private Drawer drawer = new NormalDrawer();
    private boolean drawEdgesFirst = false;

    public Network2DDisplay(VectorSpace vectorSpace, int n, int n2) {
        this(vectorSpace.getMembers(), n, n2);
    }

    public Network2DDisplay(List list, int n, int n2) {
        this.height = n2;
        this.width = n;
        this.layout = new DefaultGraphLayout(list, n, n2);
    }

    public Network2DDisplay(GraphLayout graphLayout) {
        this.width = graphLayout.getWidth();
        this.height = graphLayout.getHeight();
        this.layout = graphLayout;
    }

    public boolean getDrawEdgesFirst() {
        return this.drawEdgesFirst;
    }

    public void setDrawEdgesFirst(boolean bl) {
        this.drawEdgesFirst = bl;
    }

    public Dimension getSize() {
        return new Dimension(this.layout.getWidth(), this.layout.getHeight());
    }

    public void setLinksVisible(boolean bl) {
        this.viewLinks = bl;
    }

    public void setNodesVisible(boolean bl) {
        this.viewNodes = bl;
    }

    public void drawDisplay(SimGraphics simGraphics) {
        this.drawer.drawDisplay(simGraphics);
    }

    public ArrayList getDisplayableInfo() {
        ArrayList<DisplayInfo> arrayList = new ArrayList<DisplayInfo>();
        arrayList.add(new DisplayInfo("Links", 1, this));
        arrayList.add(new DisplayInfo("Nodes", 0, this));
        arrayList.add(new DisplayInfo("Update Layout", 3, this));
        return arrayList;
    }

    public ArrayList getObjectsAt(int n, int n2) {
        ArrayList arrayList = this.layout.getNodeList();
        Point point = new Point((int)((float)n / SimGraphics.getInstance().getXScale()), (int)((float)n2 / SimGraphics.getInstance().getYScale()));
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            NonGridDrawable nonGridDrawable;
            Object e = arrayList.get(i);
            if (!(e instanceof NonGridDrawable) || !(nonGridDrawable = (NonGridDrawable)e).contains(point)) continue;
            arrayList2.add(e);
        }
        return arrayList2;
    }

    public void setMoveableXY(Moveable moveable, int n, int n2) {
        moveable.setX((int)((float)n / SimGraphics.getInstance().getXScale()));
        moveable.setY((int)((float)n2 / SimGraphics.getInstance().getYScale()));
    }

    public void startZoom(int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        this.drawer = new ZoomDrawer();
        this.zoomSet.clear();
        ArrayList arrayList = this.layout.getNodeList();
        int n7 = arrayList.size();
        double d = (double)this.width / (double)n3;
        double d2 = (double)this.height / (double)n4;
        float f = SimGraphics.getInstance().getXScale();
        float f2 = SimGraphics.getInstance().getYScale();
        for (int i = 0; i < n7; ++i) {
            DrawableNonGridNode drawableNonGridNode = (DrawableNonGridNode)arrayList.get(i);
            double d3 = drawableNonGridNode.getX();
            double d4 = drawableNonGridNode.getY();
            double d5 = d3 * (double)f;
            double d6 = d4 * (double)f2;
            if (!(d5 > (double)n) || !(d5 < (double)n5) || !(d6 > (double)n2) || !(d6 < (double)n6)) continue;
            drawableNonGridNode.setX((d5 - (double)n) * d);
            drawableNonGridNode.setY((d6 - (double)n2) * d2);
            this.zoomSet.put(drawableNonGridNode, new NodePoint(d3, d4));
        }
    }

    public void endZoom() {
        this.drawer = new NormalDrawer();
        Iterator iterator = this.zoomSet.keySet().iterator();
        while (iterator.hasNext()) {
            DrawableNonGridNode drawableNonGridNode = (DrawableNonGridNode)iterator.next();
            NodePoint nodePoint = (NodePoint)this.zoomSet.get(drawableNonGridNode);
            drawableNonGridNode.setX(nodePoint.x);
            drawableNonGridNode.setY(nodePoint.y);
        }
    }

    public void viewEventPerformed(ViewEvent viewEvent) {
        int n = viewEvent.getId();
        boolean bl = viewEvent.showView();
        if (n == 0) {
            this.viewNodes = bl;
        } else if (n == 1) {
            this.viewLinks = bl;
        } else if (n == 3) {
            this.layout.setUpdate(bl);
        } else if (n == 100) {
            this.drawEdgesFirst = bl;
        }
    }

    class NormalDrawer
    implements Drawer {
        NormalDrawer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawDisplay(SimGraphics simGraphics) {
            if (!Network2DDisplay.this.viewNodes && !Network2DDisplay.this.viewLinks) {
                return;
            }
            float f = simGraphics.getXScale();
            float f2 = simGraphics.getYScale();
            if (Network2DDisplay.this.drawEdgesFirst) {
                Hashtable hashtable = Network2DDisplay.this.nodePoint;
                synchronized (hashtable) {
                    Object object;
                    Object object2;
                    ArrayList arrayList;
                    ArrayList arrayList2;
                    ArrayList arrayList3 = arrayList2 = Network2DDisplay.this.layout.getNodeList();
                    synchronized (arrayList3) {
                        arrayList = (ArrayList)arrayList2.clone();
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        object2 = (DrawableNonGridNode)arrayList.get(i);
                        if (object2.getOutEdges() != null) {
                            Network2DDisplay.this.edges.addAll(object2.getOutEdges());
                        }
                        double d = object2.getX() * (double)f;
                        double d2 = object2.getY() * (double)f2;
                        object2.calcSize(simGraphics);
                        int n = (int)((float)object2.getWidth() * f);
                        int n2 = (int)((float)object2.getHeight() * f2);
                        Network2DDisplay.this.nodePoint.put(object2, new NodePoint(d, d2, n, n2));
                    }
                    if (Network2DDisplay.this.viewLinks) {
                        for (int i = 0; i < Network2DDisplay.this.edges.size(); ++i) {
                            object = (DrawableEdge)Network2DDisplay.this.edges.get(i);
                            object2 = (NodePoint)Network2DDisplay.this.nodePoint.get(object.getTo());
                            NodePoint nodePoint = (NodePoint)Network2DDisplay.this.nodePoint.get(object.getFrom());
                            object.draw(simGraphics, (int)nodePoint.x, (int)((NodePoint)object2).x, (int)nodePoint.y, (int)((NodePoint)object2).y);
                        }
                    }
                    if (Network2DDisplay.this.viewNodes) {
                        Iterator iterator = Network2DDisplay.this.nodePoint.entrySet().iterator();
                        while (iterator.hasNext()) {
                            object2 = iterator.next();
                            DrawableNonGridNode drawableNonGridNode = (DrawableNonGridNode)object2.getKey();
                            object = (NodePoint)object2.getValue();
                            simGraphics.setDrawingParameters(((NodePoint)object).width, ((NodePoint)object).height, 0);
                            simGraphics.setDrawingCoordinates((float)((NodePoint)object).nx, (float)((NodePoint)object).ny, 0.0f);
                            drawableNonGridNode.draw(simGraphics);
                        }
                    }
                }
            }
            Hashtable hashtable = Network2DDisplay.this.nodePoint;
            synchronized (hashtable) {
                Object object;
                ArrayList arrayList;
                ArrayList arrayList4;
                ArrayList arrayList5 = arrayList4 = Network2DDisplay.this.layout.getNodeList();
                synchronized (arrayList5) {
                    arrayList = (ArrayList)arrayList4.clone();
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    object = (DrawableNonGridNode)arrayList.get(i);
                    if (object.getOutEdges() != null) {
                        Network2DDisplay.this.edges.addAll(object.getOutEdges());
                    }
                    double d = object.getX() * (double)f;
                    double d3 = object.getY() * (double)f2;
                    object.calcSize(simGraphics);
                    int n = (int)((float)object.getWidth() * f);
                    int n3 = (int)((float)object.getHeight() * f2);
                    Network2DDisplay.this.nodePoint.put(object, new NodePoint(d, d3, n, n3));
                    if (!Network2DDisplay.this.viewNodes) continue;
                    simGraphics.setDrawingParameters(n, n3, 0);
                    simGraphics.setDrawingCoordinates((float)d, (float)d3, 0.0f);
                    object.draw(simGraphics);
                }
                if (Network2DDisplay.this.viewLinks) {
                    for (int i = 0; i < Network2DDisplay.this.edges.size(); ++i) {
                        DrawableEdge drawableEdge = (DrawableEdge)Network2DDisplay.this.edges.get(i);
                        object = (NodePoint)Network2DDisplay.this.nodePoint.get(drawableEdge.getTo());
                        NodePoint nodePoint = (NodePoint)Network2DDisplay.this.nodePoint.get(drawableEdge.getFrom());
                        drawableEdge.draw(simGraphics, (int)nodePoint.x, (int)((NodePoint)object).x, (int)nodePoint.y, (int)((NodePoint)object).y);
                    }
                }
            }
            Network2DDisplay.this.edges.clear();
            Network2DDisplay.this.nodePoint.clear();
        }
    }

    class ZoomDrawer
    implements Drawer {
        ZoomDrawer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawDisplay(SimGraphics simGraphics) {
            if (!Network2DDisplay.this.viewNodes && !Network2DDisplay.this.viewLinks) {
                return;
            }
            float f = simGraphics.getXScale();
            float f2 = simGraphics.getYScale();
            if (Network2DDisplay.this.drawEdgesFirst) {
                Hashtable hashtable = Network2DDisplay.this.nodePoint;
                synchronized (hashtable) {
                    Object object;
                    Object object2;
                    Iterator iterator = Network2DDisplay.this.zoomSet.keySet().iterator();
                    while (iterator.hasNext()) {
                        object2 = (DrawableNonGridNode)iterator.next();
                        object = object2.getOutEdges();
                        if (object != null) {
                            int n = ((ArrayList)object).size();
                            for (int i = 0; i < n; ++i) {
                                Edge edge = (Edge)((ArrayList)object).get(i);
                                Node node = edge.getTo();
                                if (!Network2DDisplay.this.zoomSet.containsKey(node)) continue;
                                Network2DDisplay.this.edges.add(edge);
                            }
                        }
                        double d = object2.getX() * (double)f;
                        double d2 = object2.getY() * (double)f2;
                        object2.calcSize(simGraphics);
                        int n = (int)((float)object2.getWidth() * f);
                        int n2 = (int)((float)object2.getHeight() * f);
                        Network2DDisplay.this.nodePoint.put(object2, new NodePoint(d, d2, n, n2));
                    }
                    if (Network2DDisplay.this.viewLinks) {
                        for (int i = 0; i < Network2DDisplay.this.edges.size(); ++i) {
                            DrawableEdge drawableEdge = (DrawableEdge)Network2DDisplay.this.edges.get(i);
                            object = (NodePoint)Network2DDisplay.this.nodePoint.get(drawableEdge.getTo());
                            object2 = (NodePoint)Network2DDisplay.this.nodePoint.get(drawableEdge.getFrom());
                            drawableEdge.draw(simGraphics, (int)((NodePoint)object2).x, (int)((NodePoint)object).x, (int)((NodePoint)object2).y, (int)((NodePoint)object).y);
                        }
                    }
                    if (Network2DDisplay.this.viewNodes) {
                        object2 = Network2DDisplay.this.nodePoint.entrySet().iterator();
                        while (object2.hasNext()) {
                            object = (Map.Entry)object2.next();
                            DrawableNonGridNode drawableNonGridNode = (DrawableNonGridNode)object.getKey();
                            NodePoint nodePoint = (NodePoint)object.getValue();
                            simGraphics.setDrawingParameters(nodePoint.width, nodePoint.height, 0);
                            simGraphics.setDrawingCoordinates((float)nodePoint.nx, (float)nodePoint.ny, 0.0f);
                            drawableNonGridNode.draw(simGraphics);
                        }
                    }
                }
            }
            Hashtable hashtable = Network2DDisplay.this.nodePoint;
            synchronized (hashtable) {
                Object object;
                Object object3;
                Iterator iterator = Network2DDisplay.this.zoomSet.keySet().iterator();
                while (iterator.hasNext()) {
                    object3 = (DrawableNonGridNode)iterator.next();
                    object = object3.getOutEdges();
                    if (object != null) {
                        int n = ((ArrayList)object).size();
                        for (int i = 0; i < n; ++i) {
                            Edge edge = (Edge)((ArrayList)object).get(i);
                            Node node = edge.getTo();
                            if (!Network2DDisplay.this.zoomSet.containsKey(node)) continue;
                            Network2DDisplay.this.edges.add(edge);
                        }
                    }
                    double d = object3.getX() * (double)f;
                    double d3 = object3.getY() * (double)f2;
                    object3.calcSize(simGraphics);
                    int n = (int)((float)object3.getWidth() * f);
                    int n3 = (int)((float)object3.getHeight() * f);
                    Network2DDisplay.this.nodePoint.put(object3, new NodePoint(d, d3, n, n3));
                    if (!Network2DDisplay.this.viewNodes) continue;
                    simGraphics.setDrawingParameters(n, n3, 0);
                    simGraphics.setDrawingCoordinates((float)d, (float)d3, 0.0f);
                    object3.draw(simGraphics);
                }
                if (Network2DDisplay.this.viewLinks) {
                    for (int i = 0; i < Network2DDisplay.this.edges.size(); ++i) {
                        DrawableEdge drawableEdge = (DrawableEdge)Network2DDisplay.this.edges.get(i);
                        object = (NodePoint)Network2DDisplay.this.nodePoint.get(drawableEdge.getTo());
                        object3 = (NodePoint)Network2DDisplay.this.nodePoint.get(drawableEdge.getFrom());
                        drawableEdge.draw(simGraphics, (int)((NodePoint)object3).x, (int)((NodePoint)object).x, (int)((NodePoint)object3).y, (int)((NodePoint)object).y);
                    }
                }
            }
            Network2DDisplay.this.edges.clear();
            Network2DDisplay.this.nodePoint.clear();
        }
    }

    static interface Drawer {
        public void drawDisplay(SimGraphics var1);
    }

    class NodePoint {
        double x;
        double y;
        double nx;
        double ny;
        int width;
        int height;

        public NodePoint(double d, double d2, int n, int n2) {
            this.nx = d;
            this.ny = d2;
            this.width = n;
            this.height = n2;
            this.x = d + (double)(n / 2);
            this.y = d2 + (double)(n2 / 2);
        }

        public NodePoint(double d, double d2) {
            this.x = d;
            this.y = d2;
        }
    }
}

