/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.util.ArrayList;
import java.util.Hashtable;
import uchicago.src.collection.BaseMatrix;
import uchicago.src.sim.gui.DisplayConstants;
import uchicago.src.sim.gui.DisplayInfo;
import uchicago.src.sim.gui.Drawable2DGridNode;
import uchicago.src.sim.gui.DrawableEdge;
import uchicago.src.sim.gui.Object2DDisplay;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.gui.ViewEvent;
import uchicago.src.sim.space.Discrete2DSpace;
import uchicago.src.sim.space.Torus;

public class Network2DGridDisplay
extends Object2DDisplay {
    private Hashtable nodePoint = new Hashtable(113);
    private ArrayList edges = new ArrayList(113);
    private int xPad;
    private int yPad;
    private int width;
    private int height;
    private int halfHeight;
    private int halfWidth;
    private boolean viewNodes = true;
    private boolean viewLinks = true;
    private boolean wrapLinks = true;
    private boolean isTorus = false;
    private int xSize;
    private int ySize;

    public Network2DGridDisplay(Discrete2DSpace discrete2DSpace) {
        super(discrete2DSpace);
        int n;
        if (discrete2DSpace instanceof Torus) {
            this.isTorus = true;
        }
        this.width = (n = DisplayConstants.CELL_WIDTH) < 5 ? n - 2 : (n < 10 ? n - 4 : (n < 15 ? n - 6 : (n < 20 ? n - 8 : n - 12)));
        n = DisplayConstants.CELL_HEIGHT;
        this.height = n < 5 ? n - 2 : (n < 10 ? n - 4 : (n < 15 ? n - 6 : (n < 20 ? n - 8 : n - 12)));
        this.halfWidth = this.width / 2;
        this.halfHeight = this.height / 2;
        this.xPad = DisplayConstants.CELL_WIDTH / 2 - this.halfWidth;
        this.yPad = DisplayConstants.CELL_HEIGHT / 2 - this.halfHeight;
        this.xSize = this.size.width;
        this.ySize = this.size.height;
    }

    public void setLinksVisible(boolean bl) {
        this.viewLinks = bl;
    }

    public void setNodesVisible(boolean bl) {
        this.viewNodes = bl;
    }

    public void wrapLinks(boolean bl) {
        this.wrapLinks = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawDisplay(SimGraphics simGraphics) {
        int n;
        if (!this.viewNodes && !this.viewLinks) {
            return;
        }
        int n2 = simGraphics.getCurWidth();
        int n3 = simGraphics.getCurHeight();
        int n4 = simGraphics.getCellWidthScale();
        int n5 = simGraphics.getCellHeightScale();
        int n6 = n4 - 4;
        if (n6 < 1) {
            n6 = n4 - 1;
        }
        if ((n = n5 - 4) < 1) {
            n = n5 - 1;
        }
        this.halfWidth = n6 / 2;
        this.halfHeight = n / 2;
        Hashtable hashtable = this.nodePoint;
        synchronized (hashtable) {
            ArrayList arrayList;
            simGraphics.setDrawingParametersNoScale(n6, n, 0);
            if (this.objsToDraw == null) {
                BaseMatrix baseMatrix;
                BaseMatrix baseMatrix2 = baseMatrix = this.grid.getMatrix();
                synchronized (baseMatrix2) {
                    for (int i = 0; i < this.grid.getSizeX(); ++i) {
                        for (int j = 0; j < this.grid.getSizeY(); ++j) {
                            Drawable2DGridNode drawable2DGridNode = (Drawable2DGridNode)baseMatrix.get(i, j);
                            if (drawable2DGridNode == null) continue;
                            ArrayList arrayList2 = drawable2DGridNode.getOutEdges();
                            if (arrayList2 != null) {
                                ArrayList arrayList3 = arrayList2;
                                synchronized (arrayList3) {
                                    this.edges.addAll(arrayList2);
                                }
                            }
                            int n7 = i * n4 + 2;
                            int n8 = j * n5 + 2;
                            this.nodePoint.put(drawable2DGridNode, new Point(n7 + this.halfWidth, n8 + this.halfHeight));
                            if (!this.viewNodes) continue;
                            simGraphics.setDrawingCoordinates(n7, n8, 0.0f);
                            drawable2DGridNode.draw(simGraphics);
                        }
                    }
                }
            }
            Object object = this.objsToDraw;
            synchronized (object) {
                arrayList = new ArrayList(this.objsToDraw);
            }
            object = arrayList.listIterator();
            while (object.hasNext()) {
                Drawable2DGridNode drawable2DGridNode = (Drawable2DGridNode)object.next();
                ArrayList arrayList4 = drawable2DGridNode.getOutEdges();
                if (arrayList4 != null) {
                    this.edges.addAll(arrayList4);
                }
                int n9 = (int)drawable2DGridNode.getX() * n4 + 2;
                int n10 = (int)drawable2DGridNode.getY() * n5 + 2;
                this.nodePoint.put(drawable2DGridNode, new Point(n9 + this.halfWidth, n10 + this.halfHeight));
                if (!this.viewNodes) continue;
                simGraphics.setDrawingCoordinates(n9, n10, 0.0f);
                drawable2DGridNode.draw(simGraphics);
            }
            if (this.viewLinks) {
                this.drawEdges(simGraphics);
            }
        }
        this.edges.clear();
        this.nodePoint.clear();
        simGraphics.setDrawingParametersNoScale(n2, n3, 0);
    }

    private void drawEdges(SimGraphics simGraphics) {
        for (int i = 0; i < this.edges.size(); ++i) {
            DrawableEdge drawableEdge = (DrawableEdge)this.edges.get(i);
            Point point = (Point)this.nodePoint.get(drawableEdge.getTo());
            Point point2 = (Point)this.nodePoint.get(drawableEdge.getFrom());
            if (this.wrapLinks && this.isTorus) {
                if (Math.abs(point.x - point2.x) == this.xSize - DisplayConstants.CELL_WIDTH || Math.abs(point.y - point2.y) == this.ySize - DisplayConstants.CELL_HEIGHT) {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    if (point.x == point2.x) {
                        n4 = point.x;
                        n3 = point.x;
                    } else if (point.x < point2.x) {
                        n4 = point2.x - this.xSize;
                        n3 = point.x + this.xSize;
                    } else {
                        n4 = point.x + this.xSize;
                        n3 = point2.x - this.xSize;
                    }
                    if (point.y == point2.y) {
                        n2 = point.y;
                        n = point.y;
                    } else if (point.y < point2.y) {
                        n2 = point2.y - this.ySize;
                        n = point.y + this.ySize;
                    } else {
                        n2 = point.y + this.ySize;
                        n = point2.y - this.ySize;
                    }
                    drawableEdge.draw(simGraphics, point2.x, n3, point2.y, n);
                    drawableEdge.draw(simGraphics, point.x, n4, point.y, n2);
                    continue;
                }
                drawableEdge.draw(simGraphics, point2.x, point.x, point2.y, point.y);
                continue;
            }
            drawableEdge.draw(simGraphics, point2.x, point.x, point2.y, point.y);
        }
    }

    public ArrayList getDisplayableInfo() {
        ArrayList<DisplayInfo> arrayList = new ArrayList<DisplayInfo>();
        arrayList.add(new DisplayInfo("Links", 1, this));
        arrayList.add(new DisplayInfo("Nodes", 0, this));
        if (this.isTorus) {
            arrayList.add(new DisplayInfo("Wrap Links", 2, this));
        }
        return arrayList;
    }

    public void viewEventPerformed(ViewEvent viewEvent) {
        int n = viewEvent.getId();
        boolean bl = viewEvent.showView();
        if (n == 0) {
            this.viewNodes = bl;
        } else if (n == 1) {
            this.viewLinks = bl;
        } else if (n == 2) {
            this.wrapLinks = bl;
        }
    }

    private class Point {
        int x;
        int y;

        Point(int n, int n2) {
            this.x = n;
            this.y = n2;
        }
    }
}

