/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.ArrayList;
import uchicago.src.collection.BaseMatrix;
import uchicago.src.sim.gui.Drawable;
import uchicago.src.sim.gui.HexaDisplay2D;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.space.Discrete2DSpace;

public class Object2DHexaDisplay
extends HexaDisplay2D {
    protected ArrayList objList = null;

    public Object2DHexaDisplay(Discrete2DSpace discrete2DSpace) {
        super(discrete2DSpace);
    }

    public void setObjectList(ArrayList arrayList) {
        this.objList = arrayList;
    }

    public ArrayList getObjectsAt(int n, int n2) {
        Dimension dimension = this.getCoordinates(n, n2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (dimension != null) {
            arrayList.add(this.grid.getObjectAt(dimension.width, dimension.height));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawDisplay(SimGraphics simGraphics) {
        ArrayList arrayList;
        if (!this.view) {
            return;
        }
        Drawable drawable = null;
        if (this.objList == null) {
            BaseMatrix baseMatrix;
            BaseMatrix baseMatrix2 = baseMatrix = this.grid.getMatrix();
            synchronized (baseMatrix2) {
                for (int i = 0; i < this.grid.getSizeX(); ++i) {
                    for (int j = 0; j < this.grid.getSizeY(); ++j) {
                        drawable = (Drawable)baseMatrix.get(i, j);
                        if (drawable == null) continue;
                        this.drawAt(simGraphics, drawable, i * simGraphics.getCellWidthScale(), j * simGraphics.getCellHeightScale());
                    }
                }
            }
        }
        Object object = this.objList;
        synchronized (object) {
            arrayList = (ArrayList)this.objList.clone();
        }
        object = arrayList.listIterator();
        while (object.hasNext()) {
            drawable = (Drawable)object.next();
            this.drawAt(simGraphics, drawable, drawable.getX(), drawable.getY());
        }
    }

    private void drawAt(SimGraphics simGraphics, Drawable drawable, int n, int n2) {
        n2 = n % 2 != 0 ? n2 * yTrans : n2 * yTrans + yTransHalf;
        n = n * xTrans - n * xTrans1q;
        Polygon polygon = new Polygon(Object2DHexaDisplay.polyClip.xpoints, Object2DHexaDisplay.polyClip.ypoints, Object2DHexaDisplay.polyClip.npoints);
        polygon.translate(n, n2);
        Graphics2D graphics2D = simGraphics.getGraphics();
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(polygon);
        simGraphics.setDrawingCoordinates(n, n2, 0.0f);
        drawable.draw(simGraphics);
        graphics2D.setClip(shape);
        if (this.isFramed) {
            Polygon polygon2 = new Polygon(this.polyDraw.xpoints, this.polyDraw.ypoints, this.polyDraw.npoints);
            polygon2.translate(n, n2);
            Color color = graphics2D.getColor();
            graphics2D.setColor(this.frameColor);
            graphics2D.draw(polygon2);
            graphics2D.setColor(color);
        }
    }
}

