/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import uchicago.src.sim.gui.DisplayConstants;
import uchicago.src.sim.gui.DisplaySurface;

public class SimGraphics {
    private Graphics2D g2;
    private RoundRectangle2D roundRect;
    private Rectangle2D rect;
    private Ellipse2D oval;
    private Line2D line;
    private DisplaySurface surface;
    private BasicStroke lineStroke = new BasicStroke(2.0f);
    private int curX;
    private int curY;
    private int[] curLineX;
    private int[] curLineY;
    private int curZ;
    private float xScale = 1.0f;
    private float yScale = 1.0f;
    private int origWidth;
    private int origHeight;
    private int curWidth = DisplayConstants.CELL_WIDTH;
    private int curHeight = DisplayConstants.CELL_HEIGHT;
    private int curDepth;
    private Font currentFont = new Font("monospace", 0, 8);
    private static SimGraphics instance;

    public SimGraphics() {
        this.origWidth = this.curWidth;
        this.origHeight = this.curHeight;
        instance = this;
    }

    public static SimGraphics getInstance() {
        return instance;
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.g2 = graphics2D;
        this.g2.setFont(this.currentFont);
    }

    public Graphics2D getGraphics() {
        return this.g2;
    }

    public void setDisplaySurface(DisplaySurface displaySurface) {
        this.surface = displaySurface;
    }

    public int getDisplayWidth() {
        return this.surface.getWidth();
    }

    public int getDisplayHeight() {
        return this.surface.getHeight();
    }

    public void setFont(Font font) {
        if (font != this.currentFont) {
            this.currentFont = font;
            this.g2.setFont(font);
        }
    }

    public float getXScale() {
        return this.xScale;
    }

    public void setXScale(float f) {
        this.xScale = f;
        this.curWidth = (int)((float)this.origWidth * f);
    }

    public int getCellWidthScale() {
        return (int)((float)DisplayConstants.CELL_WIDTH * this.xScale);
    }

    public float getYScale() {
        return this.yScale;
    }

    public void setYScale(float f) {
        this.yScale = f;
        this.curHeight = (int)((float)this.origHeight * f);
    }

    public int getCellHeightScale() {
        return (int)((float)DisplayConstants.CELL_HEIGHT * this.yScale);
    }

    public void setDrawingCoordinates(float f, float f2, float f3) {
        this.curX = (int)f;
        this.curY = (int)f2;
    }

    public void setDrawingParameters(int n, int n2, int n3) {
        this.curWidth = (int)((float)n * this.xScale);
        this.curHeight = (int)((float)n2 * this.yScale);
        this.curDepth = n3;
    }

    public void setDrawingParametersNoScale(int n, int n2, int n3) {
        this.curWidth = n;
        this.curHeight = n2;
        this.curDepth = n3;
    }

    public int getCurWidth() {
        return this.curWidth;
    }

    public int getCurHeight() {
        return this.curHeight;
    }

    private void drawInit(Color color) {
        if (this.g2.getPaint() != color) {
            this.g2.setPaint(color);
        }
    }

    public void drawImage(Image image) {
        this.g2.drawImage(image, this.curX, this.curY, null);
    }

    public void drawImageToFit(Image image) {
        this.g2.drawImage(image, this.curX, this.curY, this.curWidth, this.curHeight, null);
    }

    public void drawRoundRect(Color color) {
        this.drawInit(color);
        if (this.roundRect == null) {
            this.roundRect = new RoundRectangle2D.Float(this.curX, this.curY, this.curWidth, this.curHeight, 3.0f, 3.0f);
        }
        this.roundRect.setFrame(this.curX, this.curY, this.curWidth, this.curHeight);
        this.g2.fill(this.roundRect);
    }

    public void drawFastRoundRect(Color color) {
        this.drawInit(color);
        this.g2.fillRoundRect(this.curX, this.curY, this.curWidth, this.curHeight, 3, 3);
    }

    public void drawHollowRoundRect(Color color) {
        this.drawInit(color);
        if (this.roundRect == null) {
            this.roundRect = new RoundRectangle2D.Float(this.curX, this.curY, this.curWidth, this.curHeight, 3.0f, 3.0f);
        }
        this.roundRect.setFrame(this.curX, this.curY, this.curWidth, this.curHeight);
        this.g2.draw(this.roundRect);
    }

    public void drawHollowFastRoundRect(Color color) {
        this.drawInit(color);
        this.g2.drawRoundRect(this.curX, this.curY, this.curWidth, this.curHeight, 3, 3);
    }

    public void drawCircle(Color color) {
        this.drawInit(color);
        if (this.oval == null) {
            this.oval = new Ellipse2D.Float(this.curX, this.curY, this.curWidth, this.curHeight);
        }
        this.oval.setFrame(this.curX, this.curY, this.curWidth, this.curWidth);
        this.g2.draw(this.oval);
    }

    public void drawFastCircle(Color color) {
        this.drawInit(color);
        this.g2.fillOval(this.curX, this.curY, this.curWidth, this.curWidth);
    }

    public void drawDirectedLink(Color color, int n, int n2, int n3, int n4) {
        this.drawInit(color);
        this.g2.drawLine(n, n3, n2, n4);
        int n5 = n2 + (n - n2) / 6;
        int n6 = n4 + (n3 - n4) / 6;
        this.g2.fillRect(n5 - 2, n6 - 2, 5, 5);
    }

    public void drawLink(Color color, int n, int n2, int n3, int n4) {
        this.drawInit(color);
        this.g2.drawLine(n, n3, n2, n4);
    }

    public void drawStringInRoundRect(Color color, Color color2, String string) {
        this.drawFastRoundRect(color);
        this.drawString(string, color2);
    }

    public void drawStringInHollowRoundRect(Color color, Color color2, String string) {
        this.drawHollowFastRoundRect(color);
        this.drawString(string, color2);
    }

    public void drawOval(Color color) {
        this.drawInit(color);
        if (this.oval == null) {
            this.oval = new Ellipse2D.Float(this.curX, this.curY, this.curWidth, this.curHeight);
        }
        this.oval.setFrame(this.curX, this.curY, this.curWidth, this.curHeight);
        this.g2.fill(this.oval);
    }

    public void drawFastOval(Color color) {
        this.drawInit(color);
        this.g2.fillOval(this.curX, this.curY, this.curWidth, this.curHeight);
    }

    public void drawHollowFastOval(Color color) {
        this.drawInit(color);
        this.g2.drawOval(this.curX, this.curY, this.curWidth, this.curHeight);
    }

    public void drawHollowOval(Color color) {
        this.drawInit(color);
        if (this.oval == null) {
            this.oval = new Ellipse2D.Float(this.curX, this.curY, this.curWidth, this.curHeight);
        }
        this.oval.setFrame(this.curX, this.curY, this.curWidth, this.curHeight);
        this.g2.draw(this.oval);
    }

    public void drawStringInOval(Color color, Color color2, String string) {
        this.drawFastOval(color);
        this.drawString(string, color2);
    }

    public void drawStringInHollowOval(Color color, Color color2, String string) {
        this.drawHollowFastOval(color);
        this.drawString(string, color2);
    }

    public void drawOvalBorder(BasicStroke basicStroke, Color color) {
        this.drawInit(color);
        if (this.oval == null) {
            this.oval = new Ellipse2D.Float(this.curX, this.curY, this.curWidth, this.curHeight);
        }
        this.oval.setFrame(this.curX, this.curY, this.curWidth, this.curHeight);
        Stroke stroke = this.g2.getStroke();
        this.g2.setStroke(basicStroke);
        this.g2.draw(this.oval);
        this.g2.setStroke(stroke);
    }

    public Rectangle2D getStringBounds(String string, Font font) {
        FontRenderContext fontRenderContext = this.g2.getFontRenderContext();
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        return rectangle2D;
    }

    public Rectangle2D getStringBounds(String string) {
        return this.getStringBounds(string, this.currentFont);
    }

    public void drawFastRect(Color color) {
        this.drawInit(color);
        this.g2.fillRect(this.curX, this.curY, this.curWidth, this.curHeight);
    }

    public void drawRect(Color color) {
        this.drawInit(color);
        if (this.rect == null) {
            this.rect = new Rectangle(this.curX, this.curY, this.curWidth, this.curHeight);
        }
        this.rect.setFrame(this.curX, this.curY, this.curWidth, this.curHeight);
        this.g2.fill(this.rect);
    }

    public void drawHollowRect(Color color) {
        this.drawInit(color);
        if (this.rect == null) {
            this.rect = new Rectangle(this.curX, this.curY, this.curWidth, this.curHeight);
        }
        this.rect.setFrame(this.curX, this.curY, this.curWidth, this.curHeight);
        this.g2.draw(this.rect);
    }

    public void draw4ColorHollowRect(Color color, Color color2, Color color3, Color color4) {
        --this.curX;
        ++this.curY;
        int n = this.curX + this.curWidth - 1;
        int n2 = this.curY + this.curHeight - 1;
        this.drawInit(color);
        this.g2.drawLine(this.curX, this.curY, n, this.curY);
        this.drawInit(color2);
        this.g2.drawLine(this.curX, n2, n, n2);
        this.drawInit(color4);
        this.g2.drawLine(n, this.curY, n, n2);
        this.drawInit(color3);
        this.g2.drawLine(this.curX, this.curY, this.curX, n2);
    }

    public void drawHollowFastRect(Color color) {
        this.drawInit(color);
        this.g2.drawRect(this.curX, this.curY, this.curWidth, this.curHeight);
    }

    public void drawStringInRect(Color color, Color color2, String string) {
        this.drawFastRect(color);
        this.drawString(string, color2);
    }

    public void drawStringInHollowRect(Color color, Color color2, String string) {
        this.drawHollowFastRect(color);
        this.drawString(string, color2);
    }

    public void drawRectBorder(BasicStroke basicStroke, Color color) {
        this.drawInit(color);
        if (this.rect == null) {
            this.rect = new Rectangle(this.curX, this.curY, this.curWidth, this.curHeight);
        }
        this.rect.setFrame(this.curX, this.curY, this.curWidth, this.curHeight);
        Stroke stroke = this.g2.getStroke();
        this.g2.setStroke(basicStroke);
        this.g2.draw(this.rect);
        this.g2.setStroke(stroke);
    }

    public void drawString(String string, Color color) {
        Shape shape = this.g2.getClip();
        this.g2.setClip(this.curX, this.curY, this.curWidth, this.curHeight);
        this.drawInit(color);
        FontRenderContext fontRenderContext = this.g2.getFontRenderContext();
        Rectangle2D rectangle2D = this.currentFont.getStringBounds(string, fontRenderContext);
        int n = this.curX + this.curWidth / 2;
        int n2 = this.curY + this.curHeight / 2;
        int n3 = n - (int)rectangle2D.getCenterX();
        int n4 = n2 - (int)rectangle2D.getCenterY();
        this.g2.drawString(string, n3, n4);
        this.g2.setClip(shape);
    }

    public void setCurLineX(int[] nArray) {
        this.curLineX = nArray;
    }

    public void setCurLineY(int[] nArray) {
        this.curLineY = nArray;
    }

    public void drawLine(Color color) {
        this.g2.setColor(color);
        if (this.curLineY == null) {
            System.out.println("no coordinate");
            System.exit(0);
        }
        this.g2.drawPolyline(this.curLineX, this.curLineY, this.curLineX.length);
    }

    public void drawPolygon(Color color) {
        this.g2.setColor(color);
        this.g2.drawPolygon(this.curLineX, this.curLineY, this.curLineX.length);
    }

    public void fillPolygon(Color color) {
        this.g2.setColor(color);
        this.g2.fillPolygon(this.curLineX, this.curLineY, this.curLineX.length);
    }

    public void drawMultiPolygon(Color color, int[] nArray) {
        this.g2.setColor(color);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            int[] nArray2 = new int[n2];
            int[] nArray3 = new int[n2];
            for (int j = 0; j < n2; ++j) {
                nArray2[j] = this.curLineX[n];
                nArray3[j] = this.curLineY[n];
                ++n;
            }
            this.g2.drawPolygon(nArray2, nArray3, nArray2.length);
        }
    }
}

