/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import java.text.NumberFormat;
import java.util.List;
import java.util.Vector;
import uchicago.src.sim.network.AdjacencyMatrix;
import uchicago.src.sim.network.NetworkMatrixFormatter;

public class ASCIIFormatter
implements NetworkMatrixFormatter {
    private String lineSep;
    private Vector matrixStrings;
    private String header;
    private NumberFormat nFormat = NumberFormat.getNumberInstance();

    public void format(List list, Vector vector, String string) {
        this.lineSep = System.getProperty("line.separator");
        this.header = "# " + string + this.lineSep;
        this.matrixStrings = new Vector(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            AdjacencyMatrix adjacencyMatrix = (AdjacencyMatrix)vector.get(i);
            List list2 = adjacencyMatrix.getLabels();
            String string2 = "";
            for (int j = 0; j < list2.size(); ++j) {
                string2 = string2 + "," + list2.get(j);
            }
            if (string2.length() == 0) {
                string2 = ",";
            }
            String string3 = "matrix label: " + adjacencyMatrix.getMatrixLabel() + this.lineSep;
            stringBuffer.append(string3);
            if (string2.length() > 0) {
                stringBuffer.append(string2);
                stringBuffer.append(this.lineSep);
            }
            String string4 = this.formatMatrix(adjacencyMatrix);
            stringBuffer.append(string4);
            stringBuffer.append(this.lineSep);
            this.matrixStrings.add(stringBuffer.toString());
        }
    }

    private String formatMatrix(AdjacencyMatrix adjacencyMatrix) {
        StringBuffer stringBuffer = new StringBuffer();
        List list = adjacencyMatrix.getLabels();
        for (int i = 0; i < adjacencyMatrix.rows(); ++i) {
            double[] dArray = adjacencyMatrix.getRow(i).toArray();
            if (list != null) {
                stringBuffer.append(list.get(i));
            }
            for (int j = 0; j < dArray.length; ++j) {
                stringBuffer.append(",");
                stringBuffer.append(this.nFormat.format(dArray[j]));
            }
            stringBuffer.append(this.lineSep);
        }
        return stringBuffer.toString();
    }

    public String getHeader() {
        return this.header;
    }

    public Vector getMatrices() {
        return this.matrixStrings;
    }
}

