/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import uchicago.src.sim.network.AdjacencyMatrix;
import uchicago.src.sim.network.AdjacencyMatrixFactory;
import uchicago.src.sim.network.NetworkMatrixReader;
import uchicago.src.sim.util.SimUtilities;

public class DlReader
implements NetworkMatrixReader {
    private BufferedReader reader;
    private long numNodes = -1L;
    private int numMatrices = 1;
    private ArrayList labels;
    private ArrayList matrixLabels;
    private boolean hasMatrixLabels = false;
    private int type = 2;

    public DlReader(String string) {
        try {
            this.reader = new BufferedReader(new FileReader(string));
        }
        catch (IOException iOException) {
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            SimUtilities.showError("Error reading network file: " + string, iOException);
            System.exit(0);
        }
    }

    public DlReader(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
    }

    public Vector getMatrices() throws IOException {
        return this.getMatrices(2);
    }

    public Vector getMatrices(int n) throws IOException {
        this.type = n;
        this.readHeader();
        this.readLabels();
        if (this.hasMatrixLabels) {
            this.readMatrixLabels();
        }
        Vector<AdjacencyMatrix> vector = new Vector<AdjacencyMatrix>(this.numMatrices);
        for (int i = 0; i < this.numMatrices; ++i) {
            AdjacencyMatrix adjacencyMatrix = null;
            adjacencyMatrix = this.labels.size() > 0 ? AdjacencyMatrixFactory.createAdjacencyMatrix(this.labels, n) : AdjacencyMatrixFactory.createAdjacencyMatrix((int)this.numNodes, (int)this.numNodes, n);
            if (this.hasMatrixLabels) {
                adjacencyMatrix.setMatrixLabel((String)this.matrixLabels.get(i));
            }
            vector.add(this.loadData(adjacencyMatrix));
        }
        return vector;
    }

    private void readHeader() throws IOException {
        String string = null;
        while ((string = this.reader.readLine()) != null && (string = string.trim()).length() <= 0) {
        }
        if (string == null) {
            throw new IOException("File is not a valid dl file");
        }
        if (!string.startsWith("dl")) {
            throw new IOException("File is not a valid dl file");
        }
        this.parseForNumNodesMatrices(string);
    }

    private void parseForNumNodesMatrices(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        stringTokenizer.nextToken();
        this.numNodes = this.parseForValue("n", stringTokenizer, 1);
        if (stringTokenizer.hasMoreTokens()) {
            this.numMatrices = (int)this.parseForValue("nm", stringTokenizer, 2);
        }
        if (this.numNodes < 0L) {
            throw new IOException("File is not a valid dl file");
        }
    }

    private long parseForValue(String string, StringTokenizer stringTokenizer, int n) throws IOException {
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.startsWith(string)) {
                throw new IOException("File is not a valid dl file");
            }
            if (string2.length() > n) {
                char[] cArray = string2.toCharArray();
                if (cArray[n] == '=' || cArray[n] == ',') {
                    if (cArray.length > 1) {
                        try {
                            if (string2.endsWith(",")) {
                                string2 = string2.substring(0, string2.length() - 1);
                            }
                            return Long.parseLong(string2.substring(n + 1, string2.length()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IOException("File is not a valid dl file");
                        }
                    }
                    throw new IOException("File is not a valid dl file");
                }
                throw new IOException("File is not a valid dl file");
            }
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.startsWith("=")) {
                    if (string2.length() > 1) {
                        try {
                            if (string2.endsWith(",")) {
                                string2 = string2.substring(0, string2.length() - 1);
                            }
                            return Long.parseLong(string2.substring(1, string2.length()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IOException("File is not a valid dl file");
                        }
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            string2 = stringTokenizer.nextToken();
                            if (string2.endsWith(",")) {
                                string2 = string2.substring(0, string2.length() - 1);
                            }
                            return Long.parseLong(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IOException("File is not a valid dl file");
                        }
                    }
                    throw new IOException("File is not a valid dl file");
                }
                try {
                    if (string2.endsWith(",")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    return Long.parseLong(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("File is not a valid dl file");
                }
            }
            throw new IOException("File is not a valid dl file");
        }
        throw new IOException("File is not a valid dl file");
    }

    private void parseLineForLabel(String string, ArrayList arrayList) throws IOException {
        char[] cArray = string.trim().toCharArray();
        int n = -1;
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\"') {
                n = ++i;
                while (i < cArray.length) {
                    if (cArray[i] == '\"') {
                        arrayList.add(string.substring(n, i));
                        n = -1;
                        break;
                    }
                    ++i;
                }
                if (n == -1) continue;
                throw new IOException("File is not valid dl file");
            }
            if (cArray[i] == ' ' || cArray[i] == ',' || cArray[i] == '\r' || cArray[i] == '\n') {
                if (!bl) continue;
                arrayList.add(string.substring(n, i));
                bl = false;
                n = -1;
                continue;
            }
            if (bl || cArray[i] == '\"') continue;
            System.out.println(cArray[i]);
            n = i;
            bl = true;
        }
        if (n != -1) {
            throw new IOException("File not a valid dl file");
        }
    }

    private void readMatrixLabels() throws IOException {
        this.matrixLabels = new ArrayList();
        String string = "";
        while ((string = this.reader.readLine()) != null && !string.equals("data:")) {
            this.parseLineForLabel(string, this.matrixLabels);
        }
    }

    private void readLabels() throws IOException {
        this.labels = new ArrayList();
        String string = this.reader.readLine();
        if (!string.equals("labels:")) {
            this.labels = new ArrayList();
            if (string.equals("matrix labels:")) {
                this.hasMatrixLabels = true;
            }
            return;
        }
        while ((string = this.reader.readLine()) != null && !string.equals("data:")) {
            if (string.equals("matrix labels:")) {
                this.hasMatrixLabels = true;
                break;
            }
            this.parseLineForLabel(string, this.labels);
        }
    }

    private AdjacencyMatrix loadData(AdjacencyMatrix adjacencyMatrix) throws IOException {
        String string = this.reader.readLine();
        while (string.trim().length() == 0) {
            string = this.reader.readLine();
        }
        int n = 0;
        while ((long)n < this.numNodes) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                adjacencyMatrix.set(n, n2, Double.parseDouble(string2));
                ++n2;
            }
            string = this.reader.readLine();
            ++n;
        }
        return adjacencyMatrix;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

