/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import uchicago.src.sim.network.Edge;
import uchicago.src.sim.network.Node;
import uchicago.src.sim.util.Random;
import uchicago.src.sim.util.RepastException;
import uchicago.src.sim.util.SimUtilities;

public class NetUtilities {
    private ArrayList nodeList = new ArrayList();

    public static double calcClustCoef(List list) {
        int n = list.size();
        double d = 0.0;
        HashSet<Node> hashSet = new HashSet<Node>();
        for (int i = 0; i < n; ++i) {
            hashSet.clear();
            int n2 = 0;
            Node node = (Node)list.get(i);
            ArrayList arrayList = node.getOutEdges();
            int n3 = arrayList.size();
            for (int j = 0; j < arrayList.size(); ++j) {
                hashSet.add(((Edge)arrayList.get(j)).getTo());
            }
            if (hashSet.contains(node)) {
                hashSet.remove(node);
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                ArrayList arrayList2 = node2.getOutEdges();
                for (int j = 0; j < arrayList2.size(); ++j) {
                    Node node3 = ((Edge)arrayList2.get(j)).getTo();
                    if (!hashSet.contains(node3) || node2.equals(node3)) continue;
                    ++n2;
                }
            }
            if (n2 <= 0) continue;
            d += (double)n2 / (double)(n3 * (n3 - 1));
        }
        return d /= (double)n;
    }

    public static double calcDensity(List list) {
        double d = 0.0;
        int n = list.size();
        int n2 = 0;
        if (NetUtilities.isMultiplexNet(list)) {
            String string = "calcDensity expects a non-multiplex network. Please run collapseMultiplexNet() before calculating density.";
            RepastException repastException = new RepastException(string);
            SimUtilities.showError(string, repastException);
        } else {
            for (int i = 0; i < n; ++i) {
                n2 += ((Node)list.get(i)).getOutEdges().size();
            }
            d = (double)n2 / (double)(n * n);
        }
        return d;
    }

    public static double calcDensity(List list, boolean bl) {
        double d = 0.0;
        int n = list.size();
        int n2 = 0;
        if (!bl) {
            for (int i = 0; i < n; ++i) {
                n2 += ((Node)list.get(i)).getOutEdges().size();
            }
            d = (double)n2 / (double)(n * n);
        }
        return d;
    }

    public static boolean isMultiplexNet(List list) {
        boolean bl = false;
        int n = list.size();
        HashSet<Node> hashSet = new HashSet<Node>(n);
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !bl) {
            hashSet.clear();
            ArrayList arrayList = ((Node)iterator.next()).getOutEdges();
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext() && !bl) {
                Node node = ((Edge)iterator2.next()).getTo();
                if (hashSet.contains(node)) {
                    bl = true;
                    continue;
                }
                hashSet.add(node);
            }
        }
        return bl;
    }

    public static boolean hasSelfLoops(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!node.hasEdgeTo(node) && !node.hasEdgeFrom(node)) continue;
            return true;
        }
        return false;
    }

    public static int getIJTie(Node node, Node node2) {
        return node.hasEdgeTo(node2) ? 1 : 0;
    }

    public static double getIJTieStrength(Node node, Node node2) {
        Iterator iterator = node.getOutEdges().iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (!edge.getTo().equals(node2)) continue;
            return edge.getStrength();
        }
        return 0.0;
    }

    public static int countIJTies(Node node, Node node2) {
        int n = 0;
        Iterator iterator = node.getOutEdges().iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (!edge.getTo().equals(node2)) continue;
            ++n;
        }
        return n;
    }

    public static int getOutDegree(Node node) {
        return node.getOutEdges().size();
    }

    public static int getInDegree(Node node) {
        return node.getInEdges().size();
    }

    public static int getAllDegree(Node node) {
        int n = node.getInEdges().size();
        return n += node.getOutEdges().size();
    }

    public static int getNumDirectTriads(Node node, Node node2) {
        int n = 0;
        HashSet<Node> hashSet = new HashSet<Node>();
        Iterator iterator = node.getInEdges().iterator();
        while (iterator.hasNext()) {
            hashSet.add(((Edge)iterator.next()).getFrom());
        }
        iterator = node2.getInEdges().iterator();
        while (iterator.hasNext()) {
            if (!hashSet.contains(((Edge)iterator.next()).getFrom())) continue;
            ++n;
        }
        return n;
    }

    public static double getIJShortPathLength(List list, Node node, Node node2) {
        HashMap hashMap = new HashMap();
        int n = list.size();
        double[] dArray = new double[n];
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        HashSet<Node> hashSet = new HashSet<Node>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(list.get(i), new Integer(i));
            dArray[i] = Double.POSITIVE_INFINITY;
        }
        hashSet.clear();
        doubleArrayList.clear();
        arrayList.clear();
        dArray[((Integer)hashMap.get((Object)node)).intValue()] = 0.0;
        hashSet.add(node);
        doubleArrayList.add(0.0);
        arrayList.add(node);
        while (arrayList.size() >= 1) {
            double d = Double.POSITIVE_INFINITY;
            int n2 = Integer.MAX_VALUE;
            for (int i = 0; i < doubleArrayList.size(); ++i) {
                if (!(doubleArrayList.getQuick(i) < d)) continue;
                n2 = i;
                d = doubleArrayList.getQuick(n2);
            }
            Node node3 = (Node)arrayList.get(n2);
            double d2 = doubleArrayList.getQuick(n2);
            arrayList.remove(n2);
            doubleArrayList.remove(n2);
            hashSet.add(node3);
            dArray[((Integer)hashMap.get((Object)node3)).intValue()] = d2;
            if (node3.equals(node2)) break;
            Iterator iterator = node3.getOutEdges().iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                Node node4 = edge.getTo();
                if (hashSet.contains(node4)) continue;
                double d3 = d2 + edge.getStrength();
                int n3 = arrayList.indexOf(node4);
                if (n3 >= 0) {
                    if (!(doubleArrayList.getQuick(n3) > d3)) continue;
                    doubleArrayList.set(n3, d3);
                    continue;
                }
                doubleArrayList.add(d3);
                arrayList.add(node4);
            }
        }
        return dArray[(Integer)hashMap.get(node2)];
    }

    public static DenseDoubleMatrix2D getAllShortPathMatrix(List list) {
        int n;
        int n2 = list.size();
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n2, n2);
        denseDoubleMatrix2D.assign(Double.POSITIVE_INFINITY);
        HashMap<Node, Integer> hashMap = new HashMap<Node, Integer>();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        HashSet<Node> hashSet = new HashSet<Node>();
        for (n = 0; n < n2; ++n) {
            hashMap.put((Node)list.get(n), new Integer(n));
        }
        for (n = 0; n < n2; ++n) {
            hashSet.clear();
            doubleArrayList.clear();
            arrayList.clear();
            Node node = (Node)list.get(n);
            denseDoubleMatrix2D.setQuick(n, n, 0.0);
            hashSet.add(node);
            doubleArrayList.add(0.0);
            arrayList.add(node);
            while (arrayList.size() > 0) {
                double d = Double.POSITIVE_INFINITY;
                int n3 = Integer.MAX_VALUE;
                for (int i = 0; i < doubleArrayList.size(); ++i) {
                    if (!(doubleArrayList.getQuick(i) < d)) continue;
                    n3 = i;
                    d = doubleArrayList.getQuick(n3);
                }
                Node node2 = (Node)arrayList.get(n3);
                double d2 = doubleArrayList.getQuick(n3);
                arrayList.remove(n3);
                doubleArrayList.remove(n3);
                hashSet.add(node2);
                int n4 = (Integer)hashMap.get(node2);
                denseDoubleMatrix2D.setQuick(n, n4, d2);
                denseDoubleMatrix2D.setQuick(n4, n, d2);
                Iterator iterator = node2.getOutEdges().iterator();
                while (iterator.hasNext()) {
                    Edge edge = (Edge)iterator.next();
                    Node node3 = edge.getTo();
                    if (hashSet.contains(node3)) continue;
                    double d3 = d2 + edge.getStrength();
                    int n5 = arrayList.indexOf(node3);
                    if (n5 >= 0) {
                        if (!(doubleArrayList.getQuick(n5) > d3)) continue;
                        doubleArrayList.set(n5, d3);
                        continue;
                    }
                    doubleArrayList.add(d3);
                    arrayList.add(node3);
                }
            }
        }
        return denseDoubleMatrix2D;
    }

    public static double calcDiameter(List list) {
        double d = 0.0;
        int n = list.size();
        DenseDoubleMatrix2D denseDoubleMatrix2D = NetUtilities.getAllShortPathMatrix(list);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                d = Math.max(d, denseDoubleMatrix2D.getQuick(i, j));
            }
        }
        return d;
    }

    public static double calcAvgPathLength(List list) {
        int n = list.size();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                d += NetUtilities.getIJShortPathLength(list, (Node)list.get(i), (Node)list.get(j));
            }
        }
        if (n > 0) {
            d /= (double)((n - 1) * (n - 1));
        }
        return d;
    }

    public static double calcSymmetry(List list) {
        int n = list.size();
        int n2 = 0;
        int n3 = 0;
        double d = 1.0;
        for (int i = 0; i < n; ++i) {
            Node node = (Node)list.get(i);
            HashSet<Node> hashSet = new HashSet<Node>();
            Iterator iterator = node.getInEdges().iterator();
            while (iterator.hasNext()) {
                hashSet.add(((Edge)iterator.next()).getFrom());
            }
            Iterator iterator2 = node.getOutEdges().iterator();
            while (iterator2.hasNext()) {
                Node node2 = ((Edge)iterator2.next()).getTo();
                ++n2;
                if (!hashSet.contains(node2)) continue;
                ++n3;
            }
        }
        if (n2 > 0) {
            d = (double)n3 / (double)n2;
        }
        return d;
    }

    public static ArrayList getComponents(List list) {
        ComponentFinder componentFinder = new ComponentFinder();
        return componentFinder.findComponents(list);
    }

    public static List randomRewire(List list, double d) {
        ArrayList arrayList = new ArrayList();
        ArrayList<Node> arrayList2 = new ArrayList<Node>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            arrayList.addAll(node.getOutEdges());
            arrayList2.add(node);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!(d > Random.uniform.nextDoubleFromTo(0.0, 1.0))) continue;
            Edge edge = (Edge)arrayList.get(i);
            int n = arrayList2.indexOf(edge.getFrom());
            int n2 = arrayList2.indexOf(edge.getTo());
            int n3 = Random.uniform.nextIntFromTo(0, list.size() - 1);
            if (n == n3 || NetUtilities.getIJTie((Node)arrayList2.get(n), (Node)arrayList2.get(n3)) >= 1) continue;
            ((Node)list.get(n2)).removeInEdge(edge);
            edge.setTo((Node)arrayList2.get(n3));
            ((Node)list.get(n3)).addInEdge(edge);
        }
        return list;
    }

    public static List randomRewireSymmetric(List list, double d) {
        ArrayList arrayList = new ArrayList();
        ArrayList<Node> arrayList2 = new ArrayList<Node>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            arrayList.addAll(node.getOutEdges());
            arrayList2.add(node);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!(d > Random.uniform.nextDoubleFromTo(0.0, 1.0))) continue;
            Edge edge = (Edge)arrayList.get(i);
            int n = arrayList2.indexOf(edge.getFrom());
            int n2 = arrayList2.indexOf(edge.getTo());
            int n3 = Random.uniform.nextIntFromTo(0, list.size() - 1);
            if (n == n3 || NetUtilities.getIJTie((Node)arrayList2.get(n), (Node)arrayList2.get(n3)) >= 1) continue;
            Node node = (Node)list.get(n2);
            node.removeInEdge(edge);
            edge.setTo((Node)arrayList2.get(n3));
            ((Node)list.get(n3)).addInEdge(edge);
            Iterator iterator2 = node.getOutEdges().iterator();
            Edge edge2 = null;
            while (iterator2.hasNext() && (edge2 = (Edge)iterator2.next()).getTo() != (Node)arrayList2.get(n)) {
                edge2 = null;
            }
            if (edge2 == null) {
                String string = "randomRewireSymmetric expects a symmetric network";
                RepastException repastException = new RepastException(string);
                SimUtilities.showError(string, repastException);
                continue;
            }
            node.removeOutEdge(edge2);
            edge2.setFrom((Node)arrayList2.get(n3));
            ((Node)list.get(n3)).addOutEdge(edge2);
        }
        return list;
    }

    public static String getStatsString(List list) {
        String string = "NETWORK STATISTICS\nSize: " + list.size() + "\n" + "NumComponents: " + NetUtilities.getComponents(list).size() + "\n" + "Density: " + NetUtilities.calcDensity(list) + "\n" + "ClustringCoeff: " + NetUtilities.calcClustCoef(list) + "\n" + "isMultiplex: " + NetUtilities.isMultiplexNet(list) + "\n" + "hasSelfLoops: " + NetUtilities.hasSelfLoops(list) + "\n" + "Diameter: " + NetUtilities.calcDiameter(list) + "\n" + "AvgPathLength: " + NetUtilities.calcAvgPathLength(list) + "\n" + "Symmetry: " + NetUtilities.calcSymmetry(list) + "\n";
        return string;
    }

    private static class ComponentFinder {
        ArrayList nodeList;
        int nNodes = 0;
        HashSet checked = new HashSet(this.nNodes);
        ArrayList currentComps = new ArrayList();
        HashSet currentComp = new HashSet();

        private ComponentFinder() {
        }

        public ArrayList findComponents(List list) {
            int n;
            this.nNodes = list.size();
            ArrayList arrayList = new ArrayList();
            this.checked.clear();
            for (n = 0; n < this.nNodes; ++n) {
                Node node = (Node)list.get(n);
                if (this.checked.contains(node)) continue;
                this.currentComp = new HashSet();
                this.currentComps.add(this.currentComp);
                this.findConnectedNodes(node);
            }
            n = this.currentComps.size();
            for (int i = 0; i < n; ++i) {
                HashSet hashSet = (HashSet)this.currentComps.get(i);
                ArrayList arrayList2 = new ArrayList(hashSet.size());
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    arrayList2.add(iterator.next());
                }
                arrayList.add(arrayList2);
            }
            return arrayList;
        }

        private void findConnectedNodes(Node node) {
            this.checked.add(node);
            this.currentComp.add(node);
            Iterator iterator = node.getOutEdges().iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                Node node2 = edge.getTo();
                if (!this.checked.contains(node2)) {
                    this.findConnectedNodes(node2);
                    continue;
                }
                if (this.currentComp.contains(node2)) continue;
                HashSet hashSet = this.getComponentFor(node2);
                hashSet.addAll(this.currentComp);
                this.currentComps.remove(this.currentComp);
                this.currentComp = hashSet;
            }
        }

        private HashSet getComponentFor(Node node) {
            int n = this.currentComps.size();
            for (int i = 0; i < n; ++i) {
                HashSet hashSet = (HashSet)this.currentComps.get(i);
                if (!hashSet.contains(node)) continue;
                return hashSet;
            }
            return null;
        }
    }
}

