/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import uchicago.src.sim.network.AdjacencyMatrix;
import uchicago.src.sim.network.AdjacencyMatrixFactory;
import uchicago.src.sim.network.ConvertorUtil;
import uchicago.src.sim.network.Edge;
import uchicago.src.sim.network.Node;
import uchicago.src.sim.network.PairHash;
import uchicago.src.sim.util.SimUtilities;

public class NetworkConvertor {
    private NetworkConvertor() {
    }

    public static Vector nodesToMatrices(List list) {
        return NetworkConvertor.nodesToMatrices(list, 2);
    }

    public static Vector nodesToMatrices(List list, int n) {
        Object object;
        int n2;
        Hashtable<Node, Integer> hashtable = new Hashtable<Node, Integer>(list.size());
        Vector<String> vector = new Vector<String>(list.size());
        Hashtable<String, AdjacencyMatrix> hashtable2 = new Hashtable<String, AdjacencyMatrix>();
        for (n2 = 0; n2 < list.size(); ++n2) {
            object = (Node)list.get(n2);
            hashtable.put((Node)object, new Integer(n2));
            vector.add(object.getNodeLabel());
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            object = (Node)list.get(n2);
            int n3 = (Integer)hashtable.get(object);
            ArrayList arrayList = object.getOutEdges();
            for (int i = 0; i < arrayList.size(); ++i) {
                Edge edge = (Edge)arrayList.get(i);
                Node node = edge.getTo();
                int n4 = (Integer)hashtable.get(node);
                String string = edge.getType();
                AdjacencyMatrix adjacencyMatrix = (AdjacencyMatrix)hashtable2.get(string);
                if (adjacencyMatrix == null) {
                    adjacencyMatrix = AdjacencyMatrixFactory.createAdjacencyMatrix(vector, n);
                    adjacencyMatrix.setMatrixLabel(string);
                    hashtable2.put(string, adjacencyMatrix);
                }
                adjacencyMatrix.set(n3, n4, edge.getStrength());
            }
        }
        Vector vector2 = new Vector(hashtable2.size());
        object = hashtable2.elements();
        while (object.hasMoreElements()) {
            vector2.add(object.nextElement());
        }
        return vector2;
    }

    public static Vector matricesToNodes(Vector vector, Class clazz, Class clazz2) {
        ConvertorUtil convertorUtil = new ConvertorUtil();
        if (!convertorUtil.labelCheck(vector)) {
            throw new IllegalArgumentException("Matrices describe different nodes");
        }
        AdjacencyMatrix adjacencyMatrix = (AdjacencyMatrix)vector.get(0);
        Vector vector2 = null;
        try {
            PairHash pairHash = convertorUtil.makeNodes(adjacencyMatrix, clazz);
            Hashtable hashtable = convertorUtil.makeEdges(pairHash.rowsToNodes, vector, clazz2);
            vector2 = new Vector(hashtable.size());
            if (adjacencyMatrix.getLabels().size() > 0) {
                List list = adjacencyMatrix.getLabels();
                for (int i = 0; i < list.size(); ++i) {
                    Integer n = (Integer)pairHash.rowsToLabel.get(list.get(i));
                    vector2.add(hashtable.get(n));
                }
            } else {
                for (int i = 0; i < hashtable.size(); ++i) {
                    vector2.add(hashtable.get(new Integer(i)));
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            SimUtilities.showError("Error converting matrix to nodes", illegalAccessException);
            System.exit(0);
        }
        catch (InstantiationException instantiationException) {
            SimUtilities.showError("Error converting matrix to nodes", instantiationException);
            System.exit(0);
        }
        return vector2;
    }
}

