/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class ParameterLexer {
    public static final int INVALID_CHAR = -1;
    public static final int LEFT_BRACE = 0;
    public static final int RIGHT_BRACE = 1;
    public static final int START = 2;
    public static final int INCR = 3;
    public static final int END = 4;
    public static final int RUNS = 5;
    public static final int NUMBER = 6;
    public static final int WORD = 7;
    public static final int SET = 8;
    public static final int SET_LIST = 9;
    public static final int BOOL_SET = 10;
    public static final int BOOL_SET_LIST = 11;
    public static final int STRING_SET = 12;
    public static final int STRING_SET_LIST = 13;
    public static final int BOOL = 14;
    public static final int EOF = 15;
    private StreamTokenizer input;
    private int lastToken;

    public ParameterLexer(Reader reader) {
        this.input = new StreamTokenizer(reader);
        this.input.resetSyntax();
        this.input.eolIsSignificant(false);
        this.input.slashSlashComments(true);
        this.input.slashStarComments(true);
        this.input.wordChars(97, 122);
        this.input.wordChars(65, 90);
        this.input.wordChars(48, 57);
        this.input.wordChars(60, 62);
        this.input.wordChars(123, 125);
        this.input.wordChars(58, 58);
        this.input.wordChars(95, 95);
        this.input.wordChars(92, 92);
        this.input.whitespaceChars(32, 32);
        this.input.whitespaceChars(9, 9);
        this.input.whitespaceChars(10, 10);
        this.input.whitespaceChars(13, 13);
        this.input.parseNumbers();
    }

    public String getString() {
        return this.input.sval;
    }

    public double getNumber() {
        return this.input.nval;
    }

    public int getLineNum() {
        return this.input.lineno();
    }

    public void pushBack() {
        this.input.pushBack();
    }

    public int nextToken() throws IOException {
        int n;
        switch (this.input.nextToken()) {
            case -1: {
                n = 15;
                break;
            }
            case -3: {
                if (this.input.sval.equalsIgnoreCase("start:")) {
                    n = 2;
                    break;
                }
                if (this.input.sval.equalsIgnoreCase("end:")) {
                    n = 4;
                    break;
                }
                if (this.input.sval.equalsIgnoreCase("incr:")) {
                    n = 3;
                    break;
                }
                if (this.input.sval.equalsIgnoreCase("{")) {
                    n = 0;
                    break;
                }
                if (this.input.sval.equalsIgnoreCase("}")) {
                    n = 1;
                    break;
                }
                if (this.input.sval.equalsIgnoreCase("runs:")) {
                    n = 5;
                    break;
                }
                if (this.input.sval.equalsIgnoreCase("set:")) {
                    n = 8;
                    break;
                }
                if (this.input.sval.equalsIgnoreCase("set_list:")) {
                    n = 9;
                    break;
                }
                if (this.input.sval.equalsIgnoreCase("set_string:")) {
                    n = 12;
                    break;
                }
                if (this.input.sval.equalsIgnoreCase("set_string_list:")) {
                    n = 13;
                    break;
                }
                if (this.input.sval.equalsIgnoreCase("set_boolean:")) {
                    n = 10;
                    break;
                }
                if (this.input.sval.equalsIgnoreCase("set_boolean_list:")) {
                    n = 11;
                    break;
                }
                if (this.input.sval.equalsIgnoreCase("true") || this.input.sval.equalsIgnoreCase("false")) {
                    n = 14;
                    break;
                }
                n = 7;
                break;
            }
            case -2: {
                n = 6;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }
}

