/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter;

import java.beans.IntrospectionException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import uchicago.src.reflector.Introspector;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.parameter.DefaultParameterSetter;
import uchicago.src.sim.parameter.ParameterSetter;
import uchicago.src.sim.util.RepastException;

public class ParameterUtility {
    private ParameterSetter params;
    private static ParameterUtility instance;

    public static void createInstance(ParameterSetter parameterSetter) {
        instance = new ParameterUtility(parameterSetter);
    }

    public static void createInstance() {
        instance = new ParameterUtility(null);
    }

    public static ParameterUtility getInstance() {
        return instance;
    }

    private ParameterUtility(ParameterSetter parameterSetter) {
        if (parameterSetter != null) {
            this.params = parameterSetter;
        }
    }

    public boolean isDefaultParam(String string) {
        return this.params.isParameter(string);
    }

    public boolean isConstantDefaultParam(String string) {
        return this.params.isConstant(string);
    }

    public ArrayList getDynamicParameterNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.params.getDynamicParameterNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            arrayList.add(string.toLowerCase());
        }
        return arrayList;
    }

    public Hashtable getDefaultParameters(SimModel simModel) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        return this.params.getDefaultModelParameters(simModel);
    }

    public ParameterSetter createParameters(Object object, String[] stringArray) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        return new DefaultParameterSetter(object, stringArray);
    }

    public Hashtable getModelProperties(SimModel simModel) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Hashtable hashtable = new Hashtable(23);
        simModel.clearPropertyListeners();
        String[] stringArray = simModel.getInitParam();
        Introspector introspector = new Introspector();
        introspector.introspect(simModel, stringArray);
        hashtable = introspector.getPropValues();
        return hashtable;
    }

    public void makeParameterFileFromCurVals(Object object, String[] stringArray, String string) throws IntrospectionException, IllegalAccessException, InvocationTargetException, RepastException, IOException {
        Properties properties = System.getProperties();
        String string2 = (String)properties.get("line.separator");
        ParameterSetter parameterSetter = this.createParameters(object, stringArray);
        StringBuffer stringBuffer = new StringBuffer("runs: 1" + string2);
        Object object2 = parameterSetter.parameterNames();
        while (object2.hasNext()) {
            String string3 = (String)object2.next();
            String string4 = parameterSetter.getParameterValue(string3, null).toString();
            if (string4 == null) {
                throw new RepastException(null, "Illegal Parameter type");
            }
            string4 = "set: " + string4;
            stringBuffer.append(string3);
            stringBuffer.append(" ");
            stringBuffer.append("{");
            stringBuffer.append(string2);
            stringBuffer.append("  ");
            stringBuffer.append(string4);
            stringBuffer.append(string2);
            stringBuffer.append("}");
            stringBuffer.append(string2);
            stringBuffer.append(string2);
        }
        object2 = null;
        try {
            object2 = new PrintWriter(new FileOutputStream(string));
            ((PrintWriter)object2).println(stringBuffer.toString());
            ((PrintWriter)object2).flush();
        }
        catch (IOException iOException) {
            ((PrintWriter)object2).close();
            throw iOException;
        }
    }
}

