/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter.rpl;

import uchicago.src.sim.parameter.rpl.ASTlist;
import uchicago.src.sim.parameter.rpl.RPLCompiler;
import uchicago.src.sim.parameter.rpl.RPLFactory;
import uchicago.src.sim.parameter.rpl.RPLIntValue;
import uchicago.src.sim.parameter.rpl.RPLList;
import uchicago.src.sim.parameter.rpl.RPLObject;
import uchicago.src.sim.parameter.rpl.RPLParameter;
import uchicago.src.sim.parameter.rpl.RPLParser;
import uchicago.src.sim.parameter.rpl.SimpleNode;

public class ASTParameter
extends SimpleNode {
    private String name;
    private ASTlist list = null;
    private boolean isName = false;
    private RPLObject start;
    private RPLObject end;
    private RPLObject increment = new RPLIntValue(1);
    private RPLParameter parameter = null;

    public ASTParameter(int n) {
        super(n);
    }

    public ASTParameter(RPLParser rPLParser, int n) {
        super(rPLParser, n);
    }

    public void preProcess(RPLCompiler rPLCompiler) {
        this.name = (String)this.children[0].getInfo();
        rPLCompiler.addParameterName(this.name);
        int n = this.jjtGetNumChildren();
        if (n == 2) {
            SimpleNode simpleNode = (SimpleNode)this.children[1];
            if (simpleNode.id == 14) {
                this.isName = true;
            } else {
                this.list = (ASTlist)this.children[1];
                this.list.preProcess(rPLCompiler);
            }
        } else {
            this.start = this.children[1].getValue();
            this.end = this.children[2].getValue();
            if (n == 4) {
                this.increment = this.children[3].getValue();
            }
        }
    }

    public void compile(RPLCompiler rPLCompiler) {
        if (this.list != null) {
            this.list.compile(rPLCompiler);
            this.parameter = RPLFactory.createParameter(this.name, this.list.getRPLList());
        } else if (this.isName) {
            String string = this.children[1].getInfo().toString();
            Object object = rPLCompiler.getGlobalVariable(string);
            if (object == null || !(object instanceof RPLList)) {
                String string2 = "variable name '" + string + "' must refer to a list";
                throw rPLCompiler.createCompilerException(string2, this.beginLine);
            }
            this.parameter = RPLFactory.createParameter(this.name, (RPLList)object);
        } else {
            this.start.compile(rPLCompiler);
            this.end.compile(rPLCompiler);
            this.increment.compile(rPLCompiler);
            try {
                this.parameter = RPLFactory.createParameter(this.name, this.start, this.end, this.increment);
            }
            catch (ClassCastException classCastException) {
                throw rPLCompiler.createCompilerException(classCastException.getMessage(), this.beginLine);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw rPLCompiler.createCompilerException(illegalArgumentException.getMessage(), this.beginLine);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public RPLParameter getRPLParameter() {
        return this.parameter;
    }
}

