/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter.rpl;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.parameter.rpl.AbstractDynamicParameter;
import uchicago.src.sim.util.RepastException;

public class NumericRPLParameter
extends AbstractDynamicParameter {
    private BigDecimal start;
    private BigDecimal end;
    private BigDecimal curValue;
    private BigDecimal incr = new BigDecimal("1");

    public NumericRPLParameter(String string, double d, double d2) {
        this(string, d, d2, 1.0);
    }

    public NumericRPLParameter(String string, double d, double d2, double d3) {
        super(string);
        this.start = new BigDecimal(String.valueOf(d));
        this.end = new BigDecimal(String.valueOf(d2));
        this.incr = new BigDecimal(String.valueOf(d3));
        this.curValue = new BigDecimal(String.valueOf(d));
        this.type = Double.TYPE;
    }

    public void reset() {
        super.reset();
        this.curValue = new BigDecimal(this.start.toString());
    }

    protected boolean incrementSelf() {
        this.curValue = this.curValue.add(this.incr);
        return this.curValue.compareTo(this.end) < 1;
    }

    protected void invokeSet(SimModel simModel) throws RepastException {
        Object object = this.convertor.convert(this.curValue.doubleValue());
        try {
            this.setMethod.invoke((Object)simModel, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RepastException(illegalAccessException, "Unable to set model parameter '" + this.name + "'.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RepastException(illegalArgumentException, "Unable to set model parameter '" + this.name + "'.");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RepastException(invocationTargetException, "Unable to set model parameter '" + this.name + "'.");
        }
    }

    protected Object getValue() {
        return this.convertor.convert(this.curValue.doubleValue());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        stringBuffer.append("(");
        stringBuffer.append(this.start);
        stringBuffer.append(", ");
        stringBuffer.append(this.end);
        stringBuffer.append(", ");
        stringBuffer.append(this.incr);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

