/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.space;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import uchicago.src.collection.BaseMatrix;
import uchicago.src.collection.NewMatrix;
import uchicago.src.collection.SparseObjectMatrix;
import uchicago.src.sim.space.Cell;
import uchicago.src.sim.space.IMulti2DGrid;
import uchicago.src.sim.space.MooreMultiNeighborhooder;
import uchicago.src.sim.space.VNMultiNeighborhooder;

public abstract class AbsMulti2DGrid
implements IMulti2DGrid {
    protected BaseMatrix matrix;
    protected int xSize;
    protected int ySize;
    protected List roList = Collections.unmodifiableList(new ArrayList());
    protected Iterator roIter;
    private VNMultiNeighborhooder vnNeigh;
    private MooreMultiNeighborhooder mNeigh;

    public AbsMulti2DGrid(int n, int n2, boolean bl) {
        this.xSize = n;
        this.ySize = n2;
        this.matrix = bl ? new SparseObjectMatrix(n, n2) : new NewMatrix(n, n2);
        this.roIter = this.roList.iterator();
        this.vnNeigh = new VNMultiNeighborhooder(this);
        this.mNeigh = new MooreMultiNeighborhooder(this);
    }

    protected void rangeCheck(int n, int n2) {
        if (n < 0 || n >= this.xSize || n2 < 0 || n2 >= this.ySize) {
            throw new IndexOutOfBoundsException("x or y coordinate is out of bounds");
        }
    }

    public void clear(int n, int n2) {
        this.matrix.remove(n, n2);
    }

    public List getObjectsAt(int n, int n2) {
        this.rangeCheck(n, n2);
        Cell cell = (Cell)this.matrix.get(n, n2);
        if (cell != null) {
            return cell.getList();
        }
        return this.roList;
    }

    public Iterator getIteratorAt(int n, int n2) {
        this.rangeCheck(n, n2);
        Cell cell = (Cell)this.matrix.get(n, n2);
        if (cell != null) {
            return cell.iterator();
        }
        return this.roIter;
    }

    public Cell getCellAt(int n, int n2) {
        this.rangeCheck(n, n2);
        return (Cell)this.matrix.get(n, n2);
    }

    public int getCellSizeAt(int n, int n2) {
        this.rangeCheck(n, n2);
        Cell cell = (Cell)this.matrix.get(n, n2);
        if (cell != null) {
            return cell.size();
        }
        return 0;
    }

    public void removeObjectAt(int n, int n2, Object object) {
        this.rangeCheck(n, n2);
        Cell cell = (Cell)this.matrix.get(n, n2);
        if (cell != null) {
            cell.remove(object);
        }
    }

    public ArrayList getVNNeighborsLoc(int n, int n2, boolean bl) {
        return this.getVNNeighborsLoc(n, n2, 1, 1, bl);
    }

    public ArrayList getVNNeighborsLoc(int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray = new int[]{n3, n4};
        return this.vnNeigh.getNeighborsLoc(n, n2, nArray, bl);
    }

    public ArrayList getMooreNeighborsLoc(int n, int n2, boolean bl) {
        return this.getMooreNeighborsLoc(n, n2, 1, 1, bl);
    }

    public ArrayList getMooreNeighborsLoc(int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray = new int[]{n3, n4};
        return this.mNeigh.getNeighborsLoc(n, n2, nArray, bl);
    }

    public ArrayList getVNNeighbors(int n, int n2, boolean bl) {
        return this.getVNNeighbors(n, n2, 1, 1, bl);
    }

    public ArrayList getVNNeighbors(int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray = new int[]{n3, n4};
        return this.vnNeigh.getNeighborsList(n, n2, nArray, bl);
    }

    public ArrayList getMooreNeighbors(int n, int n2, boolean bl) {
        return this.getMooreNeighbors(n, n2, 1, 1, bl);
    }

    public ArrayList getMooreNeighbors(int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray = new int[]{n3, n4};
        return this.mNeigh.getNeighborsList(n, n2, nArray, bl);
    }

    public int getSizeX() {
        return this.xSize;
    }

    public int getSizeY() {
        return this.ySize;
    }

    public Dimension getSize() {
        return new Dimension(this.xSize, this.ySize);
    }

    public Object getObjectAt(int n, int n2) {
        this.rangeCheck(n, n2);
        return this.matrix.get(n, n2);
    }

    public double getValueAt(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public abstract void putObjectAt(int var1, int var2, Object var3);

    public void putValueAt(int n, int n2, double d) {
        throw new UnsupportedOperationException();
    }

    public BaseMatrix getMatrix() {
        return this.matrix;
    }

    public void trim() {
        for (int i = 0; i < this.xSize; ++i) {
            for (int j = 0; j < this.ySize; ++j) {
                int n = this.getCellSizeAt(i, j);
                if (n != 0) continue;
                this.matrix.remove(i, j);
            }
        }
        this.matrix.trim();
    }
}

