/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.space;

import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.LUDecompositionQuick;
import uchicago.src.sim.gis.DefaultSpatialNode;
import uchicago.src.sim.gis.SpatialNode;
import uchicago.src.sim.space.QuadEdge;
import uchicago.src.sim.util.Random;

public class Delaunay {
    public QuadEdge[] edges;
    public SpatialNode[] nodes;
    int numEdges;
    private static LUDecompositionQuick lu;
    private static SparseDoubleMatrix2D matrix;
    private QuadEdge topToLeft;
    private QuadEdge leftToRight;
    private QuadEdge rightToTop;
    SpatialNode topPt = null;
    SpatialNode leftPt = null;
    SpatialNode rightPt = null;

    public Delaunay() {
        lu = new LUDecompositionQuick();
        matrix = new SparseDoubleMatrix2D(4, 4);
    }

    private boolean compareX(SpatialNode spatialNode, SpatialNode spatialNode2) {
        if (spatialNode.getX() > spatialNode2.getX()) {
            return true;
        }
        if (spatialNode.getX() < spatialNode2.getX()) {
            return false;
        }
        return spatialNode.getY() > spatialNode2.getY();
    }

    private boolean compareY(SpatialNode spatialNode, SpatialNode spatialNode2) {
        if (spatialNode.getY() > spatialNode2.getY()) {
            return true;
        }
        if (spatialNode.getY() < spatialNode2.getY()) {
            return false;
        }
        return spatialNode.getX() < spatialNode2.getX();
    }

    public void findInfiniteTriangle(SpatialNode[] spatialNodeArray) {
        double d;
        SpatialNode spatialNode = spatialNodeArray[0];
        SpatialNode spatialNode2 = spatialNodeArray[0];
        SpatialNode spatialNode3 = spatialNodeArray[0];
        SpatialNode spatialNode4 = spatialNodeArray[0];
        for (int i = 1; i < spatialNodeArray.length; ++i) {
            if (this.compareY(spatialNodeArray[i], spatialNode)) {
                spatialNode = spatialNodeArray[i];
            }
            if (this.compareY(spatialNode2, spatialNodeArray[i])) {
                spatialNode2 = spatialNodeArray[i];
            }
            if (this.compareX(spatialNodeArray[i], spatialNode4)) {
                spatialNode4 = spatialNodeArray[i];
            }
            if (!this.compareX(spatialNode3, spatialNodeArray[i])) continue;
            spatialNode3 = spatialNodeArray[i];
        }
        double d2 = (spatialNode4.getX() + spatialNode3.getX()) / 2.0;
        double d3 = (spatialNode.getY() + spatialNode2.getY()) / 2.0;
        double d4 = spatialNode4.getX() - spatialNode3.getX();
        double d5 = d4 > (d = spatialNode.getY() - spatialNode2.getY()) ? d4 / 2.0 : d / 2.0;
        this.topPt = new DefaultSpatialNode(d2, d3 + 4.0 * d5, 0.0);
        this.leftPt = new DefaultSpatialNode(d2 - 5.0 * d5, d3 - 2.0 * d5, 0.0);
        this.rightPt = new DefaultSpatialNode(d2 + 5.0 * d5, d3 - 2.0 * d5, 0.0);
        this.topToLeft = QuadEdge.makeEdge(this.topPt, this.leftPt);
        this.leftToRight = QuadEdge.makeEdge(this.leftPt, this.rightPt);
        QuadEdge.splice(this.topToLeft.getSym(), this.leftToRight);
        this.rightToTop = QuadEdge.connect(this.leftToRight, this.topToLeft);
        this.edges[this.numEdges++] = this.topToLeft;
        this.edges[this.numEdges++] = this.leftToRight;
        this.edges[this.numEdges++] = this.rightToTop;
    }

    public void removeInfiniteTriangle() {
        QuadEdge.deleteEdge(this.topToLeft);
        QuadEdge.deleteEdge(this.leftToRight);
        QuadEdge.deleteEdge(this.rightToTop);
        this.removeEdge(this.topToLeft);
        this.removeEdge(this.leftToRight);
        this.removeEdge(this.rightToTop);
        int n = 0;
        while (n < this.numEdges) {
            QuadEdge quadEdge = this.edges[n];
            SpatialNode spatialNode = quadEdge.getOrg();
            SpatialNode spatialNode2 = quadEdge.getDest();
            if (spatialNode == this.topPt || spatialNode2 == this.topPt || spatialNode == this.leftPt || spatialNode2 == this.leftPt || spatialNode == this.rightPt || spatialNode2 == this.rightPt) {
                QuadEdge.deleteEdge(quadEdge);
                this.removeEdge(quadEdge);
                continue;
            }
            ++n;
        }
    }

    public void insertPoints(SpatialNode[] spatialNodeArray) {
        this.resetEdges(spatialNodeArray.length);
        this.findInfiniteTriangle(spatialNodeArray);
        for (int i = 0; i < spatialNodeArray.length; ++i) {
            this.insertPoint(spatialNodeArray[i]);
        }
        this.removeInfiniteTriangle();
    }

    private void insertPoint(SpatialNode spatialNode) {
        SpatialNode spatialNode2;
        QuadEdge quadEdge;
        QuadEdge quadEdge2 = this.locate(spatialNode);
        if (spatialNode == quadEdge2.getOrg() || spatialNode == quadEdge2.getDest()) {
            return;
        }
        if (this.isOn(spatialNode, quadEdge2)) {
            quadEdge = quadEdge2.getOPrev();
            QuadEdge.deleteEdge(quadEdge2);
            this.removeEdge(quadEdge2);
            quadEdge2 = quadEdge;
        }
        quadEdge = QuadEdge.makeEdge();
        quadEdge.org = spatialNode2 = quadEdge2.getOrg();
        quadEdge.setDest(spatialNode);
        this.edges[this.numEdges++] = quadEdge;
        QuadEdge.splice(quadEdge, quadEdge2);
        do {
            quadEdge = QuadEdge.connect(quadEdge2, quadEdge.getSym());
            this.edges[this.numEdges++] = quadEdge;
        } while ((quadEdge2 = quadEdge.getOPrev()).getDest() != spatialNode2);
        quadEdge2 = quadEdge.getOPrev();
        while (true) {
            QuadEdge quadEdge3;
            if (this.rightOf((quadEdge3 = quadEdge2.getOPrev()).getDest(), quadEdge2) && Delaunay.inCircle(quadEdge2.getOrg(), quadEdge3.getDest(), quadEdge2.getDest(), spatialNode)) {
                QuadEdge.swap(quadEdge2);
                quadEdge2 = quadEdge2.getOPrev();
                continue;
            }
            if (quadEdge2.getOrg() == spatialNode2) {
                return;
            }
            quadEdge2 = quadEdge2.getONext().getLPrev();
        }
    }

    private QuadEdge locate(SpatialNode spatialNode) {
        QuadEdge quadEdge = this.edges[(int)(Random.uniform.nextDoubleFromTo(0.0, 1.0) * (double)this.numEdges)];
        while (true) {
            if (spatialNode == quadEdge.getOrg() || spatialNode == quadEdge.getDest()) {
                return quadEdge;
            }
            if (this.rightOf(spatialNode, quadEdge)) {
                quadEdge = quadEdge.getSym();
                continue;
            }
            if (!this.rightOf(spatialNode, quadEdge.getONext())) {
                quadEdge = quadEdge.getONext();
                continue;
            }
            if (this.rightOf(spatialNode, quadEdge.getDPrev())) break;
            quadEdge = quadEdge.getDPrev();
        }
        return quadEdge;
    }

    public static boolean ccw(SpatialNode spatialNode, SpatialNode spatialNode2, SpatialNode spatialNode3) {
        return spatialNode.getX() * (spatialNode2.getY() - spatialNode3.getY()) - spatialNode.getY() * (spatialNode2.getX() - spatialNode3.getX()) + (spatialNode2.getX() * spatialNode3.getY() - spatialNode2.getY() * spatialNode3.getX()) > 0.0;
    }

    public static boolean inCircle(SpatialNode spatialNode, SpatialNode spatialNode2, SpatialNode spatialNode3, SpatialNode spatialNode4) {
        if (spatialNode == spatialNode4 || spatialNode2 == spatialNode4 || spatialNode3 == spatialNode4) {
            return false;
        }
        matrix.setQuick(0, 0, spatialNode.getX());
        matrix.setQuick(0, 1, spatialNode.getY());
        matrix.setQuick(0, 2, spatialNode.getX() * spatialNode.getX() + spatialNode.getY() * spatialNode.getY());
        matrix.setQuick(0, 3, 1.0);
        matrix.setQuick(1, 0, spatialNode2.getX());
        matrix.setQuick(1, 1, spatialNode2.getY());
        matrix.setQuick(1, 2, spatialNode2.getX() * spatialNode.getX() + spatialNode.getY() * spatialNode.getY());
        matrix.setQuick(1, 3, 1.0);
        matrix.setQuick(2, 0, spatialNode3.getX());
        matrix.setQuick(2, 1, spatialNode3.getY());
        matrix.setQuick(2, 2, spatialNode3.getX() * spatialNode.getX() + spatialNode.getY() * spatialNode.getY());
        matrix.setQuick(2, 3, 1.0);
        matrix.setQuick(3, 0, spatialNode4.getX());
        matrix.setQuick(3, 1, spatialNode4.getY());
        matrix.setQuick(3, 2, spatialNode4.getX() * spatialNode.getX() + spatialNode.getY() * spatialNode.getY());
        matrix.setQuick(3, 3, 1.0);
        lu.decompose(matrix);
        return lu.det() > 0.0;
    }

    public void resetEdges(int n) {
        this.edges = new QuadEdge[(n + 1) * 3];
        this.numEdges = 0;
    }

    public void removeEdge(QuadEdge quadEdge) {
        int n;
        QuadEdge quadEdge2 = quadEdge.getSym();
        for (n = 0; n < this.numEdges && this.edges[n] != quadEdge && this.edges[n] != quadEdge2; ++n) {
        }
        --this.numEdges;
        while (n < this.numEdges) {
            this.edges[n] = this.edges[n + 1];
            ++n;
        }
        this.edges[n].getOrg().removeOutEdge(this.edges[n]);
        this.edges[n].getDest().removeOutEdge(this.edges[n].getSym());
        this.edges[n] = null;
    }

    public boolean rightOf(SpatialNode spatialNode, QuadEdge quadEdge) {
        return Delaunay.ccw(spatialNode, quadEdge.getRot().getRot().getOrg(), quadEdge.getOrg());
    }

    public boolean leftOf(SpatialNode spatialNode, QuadEdge quadEdge) {
        return Delaunay.ccw(spatialNode, quadEdge.org, quadEdge.getRot().getRot().getOrg());
    }

    public boolean isOn(SpatialNode spatialNode, QuadEdge quadEdge) {
        return !this.rightOf(spatialNode, quadEdge) && !this.leftOf(spatialNode, quadEdge);
    }
}

