/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.space;

import uchicago.src.sim.space.Diffuse2D;

public class Diffuse2DHexagonal
extends Diffuse2D {
    private int yUp;
    private int yDown;

    public Diffuse2DHexagonal(int n, int n2) {
        this(1.0, 1.0, n, n2);
    }

    public Diffuse2DHexagonal(double d, double d2, int n, int n2) {
        super(d, d2, n, n2);
    }

    private void computeColumn() {
        int n;
        this.prevY = n = this.ySize - 1;
        this.y = 0;
        while (this.y < n) {
            this.nextY = this.y + 1;
            this.computeVal();
            this.prevY = this.y;
            this.y = this.nextY;
        }
        this.nextY = 0;
        this.computeVal();
    }

    private void computeVal() {
        long l = (long)this.readMatrix.getDoubleAt(this.x, this.y);
        long l2 = 0L;
        if (this.x % 2 == 0) {
            l2 += (long)this.readMatrix.getDoubleAt(this.x, this.prevY);
            l2 += (long)this.readMatrix.getDoubleAt(this.nextX, this.y);
            l2 += (long)this.readMatrix.getDoubleAt(this.nextX, this.nextY);
            l2 += (long)this.readMatrix.getDoubleAt(this.x, this.nextY);
            l2 += (long)this.readMatrix.getDoubleAt(this.prevX, this.nextY);
            l2 += (long)this.readMatrix.getDoubleAt(this.prevX, this.y);
        } else {
            l2 += (long)this.readMatrix.getDoubleAt(this.x, this.prevY);
            l2 += (long)this.readMatrix.getDoubleAt(this.nextX, this.prevY);
            l2 += (long)this.readMatrix.getDoubleAt(this.nextX, this.y);
            l2 += (long)this.readMatrix.getDoubleAt(this.x, this.nextY);
            l2 += (long)this.readMatrix.getDoubleAt(this.prevX, this.y);
            l2 += (long)this.readMatrix.getDoubleAt(this.prevX, this.prevY);
        }
        double d = (double)(l2 -= 6L * l) / 6.0;
        double d2 = (double)l + d * this.diffCon;
        double d3 = d2 < 0.0 ? 0.0 : (d2 >= 32767.0 ? 32767.0 : (d2 *= this.evapRate));
        this.writeMatrix.putDoubleAt(this.x, this.y, d3);
    }

    public void diffuse() {
        int n;
        this.prevX = n = this.xSize - 1;
        this.x = 0;
        while (this.x < n) {
            this.nextX = this.x + 1;
            this.computeColumn();
            this.prevX = this.x;
            this.x = this.nextX;
        }
        this.nextX = 0;
        this.computeColumn();
        this.writeMatrix.copyMatrixTo(this.readMatrix);
    }

    public double[] getVonNeumannNeighbors(int n, int n2) {
        throw new UnsupportedOperationException("Cannot get VonNeumann or Moore neighbors from hexagonal spaces");
    }

    public double[] getVonNeumannNeighbors(int n, int n2, int n3, int n4) {
        throw new UnsupportedOperationException("Cannot get VonNeumann or Moore neighbors from hexagonal spaces");
    }

    public double[] getMooreNeighbors(int n, int n2) {
        throw new UnsupportedOperationException("Cannot get VonNeumann or Moore neighbors from hexagonal spaces");
    }

    public double[] getMooreNeighbors(int n, int n2, int n3, int n4) {
        throw new UnsupportedOperationException("Cannot get VonNeumann or Moore neighbors from hexagonal spaces");
    }

    public double[] getNeighbors(int n, int n2) {
        return this.getNeighbors(n, n2, 1);
    }

    public double[] getNeighbors(int n, int n2, int n3) {
        if (n3 < 1) {
            return new double[0];
        }
        if (n3 == 1) {
            return this.singleExtent(n, n2);
        }
        if (n3 == 2) {
            return this.doubleExtent(n, n2);
        }
        return this.gtTwoExtent(n, n2, n3);
    }

    private double[] gtTwoExtent(int n, int n2, int n3) {
        int n4;
        double[] dArray = new double[3 * n3 * (n3 + 1)];
        int n5 = 0;
        n = this.xnorm(n);
        n2 = this.ynorm(n2);
        if (n % 2 == 0) {
            for (n4 = n3; n4 > 2; --n4) {
                double[] dArray2 = this.getEvenRing(n, n2, n4);
                System.arraycopy(dArray2, 0, dArray, n5, dArray2.length);
                n5 += dArray2.length;
            }
        } else {
            for (n4 = n3; n4 > 2; --n4) {
                double[] dArray3 = this.getOddRing(n, n2, n4);
                System.arraycopy(dArray3, 0, dArray, n5, dArray3.length);
                n5 += dArray3.length;
            }
        }
        double[] dArray4 = this.doubleExtent(n, n2);
        System.arraycopy(dArray4, 0, dArray, n5, dArray4.length);
        return dArray;
    }

    private double[] getEvenRing(int n, int n2, int n3) {
        int n4;
        double[] dArray = new double[n3 * 6];
        int n5 = n2 - n3;
        dArray[0] = this.getValueAt(n, n5++);
        int n6 = 1;
        int n7 = n + n3;
        int n8 = n + 1;
        while (n8 <= n7) {
            dArray[n6++] = this.getValueAt(n8++, n5);
            if (n8 > n7) {
                ++n5;
                break;
            }
            dArray[n6++] = this.getValueAt(n8++, n5);
            ++n5;
        }
        n8 = n + n3;
        for (n4 = 0; n4 < n3; ++n4) {
            dArray[n6++] = this.getValueAt(n8, n5++);
        }
        if (n8 % 2 != 0) {
            int n9 = n6++;
            int n10 = --n5;
            ++n5;
            dArray[n9] = this.getValueAt(--n8, n10);
        }
        --n8;
        while (n8 > n) {
            dArray[n6++] = this.getValueAt(n8--, n5);
            if (n8 == n) break;
            dArray[n6++] = this.getValueAt(n8--, n5);
            ++n5;
        }
        n5 = n2 + n3;
        dArray[n6++] = this.getValueAt(n, n5);
        dArray[n6++] = this.getValueAt(n - 1, n5);
        --n5;
        n8 = n - 2;
        n7 = n - n3;
        while (n8 >= n7) {
            dArray[n6++] = this.getValueAt(n8--, n5);
            if (n8 < n7) {
                --n5;
                break;
            }
            dArray[n6++] = this.getValueAt(n8--, n5);
            --n5;
        }
        n8 = n - n3;
        for (n4 = 0; n4 < n3; ++n4) {
            dArray[n6++] = this.getValueAt(n8, n5--);
        }
        if (++n8 % 2 != 0) {
            ++n5;
            dArray[n6++] = this.getValueAt(n8++, n5--);
        }
        while (n8 < n) {
            dArray[n6++] = this.getValueAt(n8++, n5);
            if (n8 == n) break;
            dArray[n6++] = this.getValueAt(n8++, n5);
            --n5;
        }
        return dArray;
    }

    private double[] getOddRing(int n, int n2, int n3) {
        int n4;
        double[] dArray = new double[n3 * 6];
        dArray[0] = this.getValueAt(n, n2 - n3);
        dArray[1] = this.getValueAt(n + 1, n2 - n3);
        int n5 = 2;
        int n6 = n + 2;
        int n7 = n2 - n3 + 1;
        int n8 = n + n3;
        while (n6 <= n8) {
            dArray[n5++] = this.getValueAt(n6++, n7);
            if (n6 > n8) {
                ++n7;
                break;
            }
            dArray[n5++] = this.getValueAt(n6++, n7);
            ++n7;
        }
        n6 = n + n3;
        for (n4 = 0; n4 < n3; ++n4) {
            dArray[n5++] = this.getValueAt(n6, n7++);
        }
        if (n6 % 2 != 0) {
            int n9 = n5++;
            int n10 = --n7;
            ++n7;
            dArray[n9] = this.getValueAt(--n6, n10);
        }
        --n6;
        while (n6 > n) {
            dArray[n5++] = this.getValueAt(n6--, n7);
            dArray[n5++] = this.getValueAt(n6--, n7);
            ++n7;
        }
        dArray[n5++] = this.getValueAt(n, n2 + n3);
        n7 = n2 + n3 - 1;
        n6 = n - 1;
        n8 = n - n3;
        while (n6 >= n8) {
            dArray[n5++] = this.getValueAt(n6--, n7);
            if (n6 < n8) {
                --n7;
                break;
            }
            dArray[n5++] = this.getValueAt(n6--, n7);
            --n7;
        }
        n6 = n - n3;
        for (n4 = 0; n4 < n3; ++n4) {
            dArray[n5++] = this.getValueAt(n6, n7--);
        }
        if (++n6 % 2 != 0) {
            dArray[n5++] = this.getValueAt(n6++, ++n7);
            --n7;
        }
        while (n6 < n) {
            dArray[n5++] = this.getValueAt(n6++, n7);
            if (n6 == n) break;
            dArray[n5++] = this.getValueAt(n6++, n7);
            --n7;
        }
        return dArray;
    }

    private double[] doubleExtent(int n, int n2) {
        double[] dArray = new double[18];
        int n3 = this.xnorm(n);
        int n4 = this.ynorm(n2);
        if (n3 % 2 == 0) {
            dArray[0] = this.getValueAt(n3, n4 - 2);
            dArray[1] = this.getValueAt(n3 + 1, n4 - 1);
            dArray[2] = this.getValueAt(n3 + 2, n4 - 1);
            dArray[3] = this.getValueAt(n3 + 2, n4);
            dArray[4] = this.getValueAt(n3 + 2, n4 + 1);
            dArray[5] = this.getValueAt(n3 + 1, n4 + 2);
            dArray[6] = this.getValueAt(n3, n4 + 2);
            dArray[7] = this.getValueAt(n3 - 1, n4 + 2);
            dArray[8] = this.getValueAt(n3 - 2, n4 + 1);
            dArray[9] = this.getValueAt(n3 - 2, n4);
            dArray[10] = this.getValueAt(n3 - 2, n4 - 1);
            dArray[11] = this.getValueAt(n3 - 1, n4 - 1);
        } else {
            dArray[0] = this.getValueAt(n3, n4 - 2);
            dArray[1] = this.getValueAt(n3 + 1, n4 - 2);
            dArray[2] = this.getValueAt(n3 + 2, n4 - 1);
            dArray[3] = this.getValueAt(n3 + 2, n4);
            dArray[4] = this.getValueAt(n3 + 2, n4 + 1);
            dArray[5] = this.getValueAt(n3 + 1, n4 + 1);
            dArray[6] = this.getValueAt(n3, n4 + 2);
            dArray[7] = this.getValueAt(n3 - 1, n4 + 1);
            dArray[8] = this.getValueAt(n3 - 2, n4 + 1);
            dArray[9] = this.getValueAt(n3 - 2, n4);
            dArray[10] = this.getValueAt(n3 - 2, n4 - 1);
            dArray[11] = this.getValueAt(n3 - 1, n4 - 2);
        }
        System.arraycopy(this.singleExtent(n, n2), 0, dArray, 12, 6);
        return dArray;
    }

    private double[] singleExtent(int n, int n2) {
        double[] dArray = new double[6];
        int n3 = this.xnorm(n);
        int n4 = this.ynorm(n2);
        if (n3 % 2 == 0) {
            dArray[0] = this.getValueAt(n3, n4 - 1);
            dArray[1] = this.getValueAt(n3 + 1, n4);
            dArray[2] = this.getValueAt(n3 + 1, n4 + 1);
            dArray[3] = this.getValueAt(n3, n4 + 1);
            dArray[4] = this.getValueAt(n3 - 1, n4 + 1);
            dArray[5] = this.getValueAt(n3 - 1, n4);
        } else {
            int n5 = n4 - 1;
            dArray[0] = this.getValueAt(n3, n5);
            dArray[1] = this.getValueAt(n3 + 1, n5);
            dArray[2] = this.getValueAt(n3 + 1, n4);
            dArray[3] = this.getValueAt(n3, n4 + 1);
            dArray[4] = this.getValueAt(n3 - 1, n4);
            dArray[5] = this.getValueAt(n3 - 1, n5);
        }
        return dArray;
    }

    public double[] findMaximum(int n, int n2, int n3, boolean bl) {
        double[] dArray = this.getNeighbors(n, n2, n3);
        if (bl) {
            double[] dArray2 = new double[dArray.length + 1];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            dArray2[dArray2.length - 1] = this.getValueAt(n, n2);
            dArray = dArray2;
        }
        return this.compareMax(dArray);
    }

    public double[] findMinimum(int n, int n2, int n3, boolean bl) {
        double[] dArray = this.getNeighbors(n, n2, n3);
        if (bl) {
            double[] dArray2 = new double[dArray.length + 1];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            dArray2[dArray2.length - 1] = this.getValueAt(n, n2);
            dArray = dArray2;
        }
        return this.compareMin(dArray);
    }
}

