/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.space;

import uchicago.src.sim.gis.SpatialNode;
import uchicago.src.sim.network.DefaultEdge;
import uchicago.src.sim.network.Node;

public class QuadEdge
extends DefaultEdge {
    private QuadEdge next;
    SpatialNode org;
    private QuadEdge rot;

    public QuadEdge(QuadEdge quadEdge, SpatialNode spatialNode, QuadEdge quadEdge2) {
        this.next = quadEdge;
        this.org = spatialNode;
        this.rot = quadEdge2;
    }

    public SpatialNode getOrg() {
        return this.org;
    }

    public SpatialNode getDest() {
        return this.rot.rot.org;
    }

    public void setDest(SpatialNode spatialNode) {
        this.rot.rot.org = spatialNode;
    }

    public SpatialNode getRight() {
        return this.rot.org;
    }

    public SpatialNode getLeft() {
        return this.rot.rot.rot.org;
    }

    public QuadEdge getRot() {
        return this.rot;
    }

    public QuadEdge getInvRot() {
        return this.rot.rot.rot;
    }

    public QuadEdge getSym() {
        return this.rot.rot;
    }

    public QuadEdge getONext() {
        return this.next;
    }

    public QuadEdge getOPrev() {
        return this.rot.next.rot;
    }

    public QuadEdge getLNext() {
        return this.rot.rot.rot.next.rot;
    }

    public QuadEdge getLPrev() {
        return this.next.rot.rot;
    }

    public QuadEdge getRNext() {
        return this.rot.next.rot.rot.rot;
    }

    public QuadEdge getRPrev() {
        return this.rot.rot.next;
    }

    public QuadEdge gerDNext() {
        return this.rot.rot.next.rot.rot;
    }

    public QuadEdge getDPrev() {
        return this.rot.rot.rot.next.rot.rot.rot;
    }

    public static QuadEdge makeEdge() {
        QuadEdge quadEdge = new QuadEdge(null, null, null);
        QuadEdge quadEdge2 = new QuadEdge(null, null, null);
        QuadEdge quadEdge3 = new QuadEdge(null, null, null);
        QuadEdge quadEdge4 = new QuadEdge(null, null, null);
        quadEdge.rot = quadEdge2;
        quadEdge2.rot = quadEdge3;
        quadEdge3.rot = quadEdge4;
        quadEdge4.rot = quadEdge;
        quadEdge.next = quadEdge;
        quadEdge2.next = quadEdge4;
        quadEdge3.next = quadEdge3;
        quadEdge4.next = quadEdge2;
        return quadEdge;
    }

    public static QuadEdge makeEdge(SpatialNode spatialNode, SpatialNode spatialNode2) {
        QuadEdge quadEdge = QuadEdge.makeEdge();
        quadEdge.org = spatialNode;
        quadEdge.rot.rot.org = spatialNode2;
        quadEdge.org.addOutEdge(quadEdge);
        quadEdge.rot.rot.org.addOutEdge(quadEdge.rot.rot);
        return quadEdge;
    }

    public Node getTo() {
        return this.rot.getRot().org;
    }

    public Node getFrom() {
        return this.getOrg();
    }

    public static void splice(QuadEdge quadEdge, QuadEdge quadEdge2) {
        quadEdge.next.rot.next = quadEdge2.rot.rot.rot;
        quadEdge2.next.rot.next = quadEdge.rot.rot.rot;
        QuadEdge quadEdge3 = quadEdge.next;
        quadEdge.next = quadEdge2.next;
        quadEdge2.next = quadEdge3;
    }

    public void splice(QuadEdge quadEdge) {
        QuadEdge.splice(this, quadEdge);
    }

    public static QuadEdge connect(QuadEdge quadEdge, QuadEdge quadEdge2) {
        QuadEdge quadEdge3 = QuadEdge.makeEdge(quadEdge.rot.rot.org, quadEdge2.org);
        QuadEdge.splice(quadEdge3, quadEdge.getLNext());
        QuadEdge.splice(quadEdge3.getSym(), quadEdge2);
        return quadEdge3;
    }

    public static void deleteEdge(QuadEdge quadEdge) {
        quadEdge.getFrom().removeOutEdge(quadEdge);
        quadEdge.getTo().removeOutEdge(quadEdge.rot.rot);
        QuadEdge.splice(quadEdge, quadEdge.getOPrev());
        QuadEdge.splice(quadEdge.getSym(), quadEdge.getSym().getOPrev());
    }

    public static void swap(QuadEdge quadEdge) {
        QuadEdge quadEdge2 = quadEdge.getOPrev();
        QuadEdge quadEdge3 = quadEdge.getSym().getOPrev();
        QuadEdge.splice(quadEdge, quadEdge2);
        QuadEdge.splice(quadEdge.getSym(), quadEdge3);
        QuadEdge.splice(quadEdge, quadEdge2.getLNext());
        QuadEdge.splice(quadEdge.getSym(), quadEdge3.getLNext());
        quadEdge.org = quadEdge2.getDest();
        quadEdge.rot.rot.org = quadEdge3.getDest();
    }
}

