/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import uchicago.src.sim.network.DefaultEdge;
import uchicago.src.sim.network.DefaultNode;
import uchicago.src.sim.network.NetUtilities;
import uchicago.src.sim.network.NetworkFactory;
import uchicago.src.sim.network.Node;
import uchicago.src.sim.util.Random;

public class DefaultNodeTest
extends TestCase {
    private DefaultNode iNode;
    private DefaultNode jNode;
    private DefaultNode kNode;
    private DefaultNode lNode;
    private DefaultNode mNode;
    private DefaultEdge edge1;
    private DefaultEdge edge2;
    private DefaultEdge edge3;
    private DefaultEdge edge4;
    private DefaultEdge edge5;
    private DefaultEdge edge6;
    private DefaultEdge edge7;
    private DefaultEdge edge8;
    private DefaultEdge edge9;
    static /* synthetic */ Class class$uchicago$src$sim$network$DefaultNode;
    static /* synthetic */ Class class$uchicago$src$sim$network$DefaultEdge;
    static /* synthetic */ Class class$uchicago$src$sim$test$DefaultNodeTest;

    public DefaultNodeTest(String string) {
        super(string);
        Random.createUniform();
    }

    public void setUp() {
        Random.createUniform();
        this.iNode = new DefaultNode("iNode");
        this.jNode = new DefaultNode("jNode");
        this.kNode = new DefaultNode("kNode");
        this.lNode = new DefaultNode("lNode");
        this.mNode = new DefaultNode("mNode");
        this.edge1 = new DefaultEdge(this.iNode, this.lNode);
        this.iNode.addOutEdge(this.edge1);
        this.lNode.addInEdge(this.edge1);
        this.edge2 = new DefaultEdge(this.iNode, this.jNode);
        this.iNode.addOutEdge(this.edge2);
        this.jNode.addInEdge(this.edge2);
        this.edge3 = new DefaultEdge(this.jNode, this.lNode);
        this.jNode.addOutEdge(this.edge3);
        this.lNode.addInEdge(this.edge3);
        this.edge4 = new DefaultEdge(this.jNode, this.kNode);
        this.jNode.addOutEdge(this.edge4);
        this.kNode.addInEdge(this.edge4);
        this.edge5 = new DefaultEdge(this.kNode, this.iNode);
        this.kNode.addOutEdge(this.edge5);
        this.iNode.addInEdge(this.edge5);
        this.edge6 = new DefaultEdge(this.kNode, this.jNode);
        this.kNode.addOutEdge(this.edge6);
        this.jNode.addInEdge(this.edge6);
        this.edge7 = new DefaultEdge(this.kNode, this.lNode);
        this.kNode.addOutEdge(this.edge7);
        this.lNode.addInEdge(this.edge7);
        this.edge8 = new DefaultEdge(this.lNode, this.iNode);
        this.lNode.addOutEdge(this.edge8);
        this.iNode.addInEdge(this.edge8);
        this.edge9 = new DefaultEdge(this.lNode, this.kNode);
        this.lNode.addOutEdge(this.edge9);
        this.kNode.addInEdge(this.edge9);
    }

    public void testGetInEdges() {
        ArrayList arrayList = this.iNode.getInEdges();
        DefaultNodeTest.assertEquals((int)2, (int)arrayList.size());
        DefaultNodeTest.assertTrue((boolean)arrayList.contains(this.edge5));
        DefaultNodeTest.assertTrue((boolean)arrayList.contains(this.edge8));
        arrayList = this.lNode.getInEdges();
        DefaultNodeTest.assertEquals((int)3, (int)arrayList.size());
        DefaultNodeTest.assertTrue((boolean)arrayList.contains(this.edge1));
        DefaultNodeTest.assertTrue((boolean)arrayList.contains(this.edge3));
        DefaultNodeTest.assertTrue((boolean)arrayList.contains(this.edge7));
    }

    public void testGetInNodes() {
        ArrayList arrayList = this.iNode.getInNodes();
        DefaultNodeTest.assertEquals((int)2, (int)arrayList.size());
        DefaultNodeTest.assertEquals((Object)this.kNode, arrayList.get(0));
        DefaultNodeTest.assertEquals((Object)this.lNode, arrayList.get(1));
        arrayList = this.lNode.getInNodes();
        DefaultNodeTest.assertEquals((int)3, (int)arrayList.size());
        DefaultNodeTest.assertEquals((Object)this.iNode, arrayList.get(0));
        DefaultNodeTest.assertEquals((Object)this.jNode, arrayList.get(1));
        DefaultNodeTest.assertEquals((Object)this.kNode, arrayList.get(2));
        this.kNode.removeEdgesTo(this.iNode);
        this.iNode.removeEdgesFrom(this.kNode);
        arrayList = this.iNode.getInNodes();
        DefaultNodeTest.assertEquals((int)1, (int)arrayList.size());
        DefaultNodeTest.assertEquals((Object)this.lNode, arrayList.get(0));
        DefaultEdge defaultEdge = new DefaultEdge(this.kNode, this.iNode);
        this.kNode.addOutEdge(defaultEdge);
        this.iNode.addInEdge(defaultEdge);
        arrayList = this.iNode.getInNodes();
        DefaultNodeTest.assertEquals((int)2, (int)arrayList.size());
        DefaultNodeTest.assertEquals((Object)this.lNode, arrayList.get(0));
        DefaultNodeTest.assertEquals((Object)this.kNode, arrayList.get(1));
        this.iNode.clearInEdges();
        arrayList = this.iNode.getInNodes();
        DefaultNodeTest.assertEquals((int)0, (int)arrayList.size());
    }

    public void testGetOutEdges() {
        ArrayList arrayList = this.jNode.getOutEdges();
        DefaultNodeTest.assertEquals((int)2, (int)arrayList.size());
        DefaultNodeTest.assertTrue((boolean)arrayList.contains(this.edge3));
        DefaultNodeTest.assertTrue((boolean)arrayList.contains(this.edge4));
        arrayList = this.kNode.getOutEdges();
        DefaultNodeTest.assertEquals((int)3, (int)arrayList.size());
        DefaultNodeTest.assertTrue((boolean)arrayList.contains(this.edge5));
        DefaultNodeTest.assertTrue((boolean)arrayList.contains(this.edge6));
        DefaultNodeTest.assertTrue((boolean)arrayList.contains(this.edge7));
    }

    public void testGetOutNodes() {
        ArrayList arrayList = this.jNode.getOutNodes();
        DefaultNodeTest.assertEquals((int)2, (int)arrayList.size());
        DefaultNodeTest.assertEquals((Object)this.lNode, arrayList.get(0));
        DefaultNodeTest.assertEquals((Object)this.kNode, arrayList.get(1));
        arrayList = this.kNode.getOutNodes();
        DefaultNodeTest.assertEquals((int)3, (int)arrayList.size());
        DefaultNodeTest.assertEquals((Object)this.iNode, arrayList.get(0));
        DefaultNodeTest.assertEquals((Object)this.jNode, arrayList.get(1));
        DefaultNodeTest.assertEquals((Object)this.lNode, arrayList.get(2));
        this.kNode.removeEdgesTo(this.jNode);
        arrayList = this.kNode.getOutNodes();
        DefaultNodeTest.assertEquals((int)2, (int)arrayList.size());
        DefaultNodeTest.assertEquals((Object)this.iNode, arrayList.get(0));
        DefaultNodeTest.assertEquals((Object)this.lNode, arrayList.get(1));
        DefaultEdge defaultEdge = new DefaultEdge(this.kNode, this.mNode);
        this.kNode.addOutEdge(defaultEdge);
        this.mNode.addInEdge(defaultEdge);
        arrayList = this.kNode.getOutNodes();
        DefaultNodeTest.assertEquals((int)3, (int)arrayList.size());
        DefaultNodeTest.assertEquals((Object)this.iNode, arrayList.get(0));
        DefaultNodeTest.assertEquals((Object)this.lNode, arrayList.get(1));
        DefaultNodeTest.assertEquals((Object)this.mNode, arrayList.get(2));
        this.kNode.clearOutEdges();
        arrayList = this.kNode.getOutNodes();
        DefaultNodeTest.assertEquals((int)0, (int)arrayList.size());
    }

    public void testHasEdgeFromOrTo() {
        DefaultNodeTest.assertTrue((boolean)this.iNode.hasEdgeToOrFrom(this.lNode));
        DefaultNodeTest.assertTrue((boolean)this.kNode.hasEdgeToOrFrom(this.jNode));
        DefaultNodeTest.assertTrue((!this.mNode.hasEdgeToOrFrom(this.jNode) ? 1 : 0) != 0);
    }

    public void testAddOutEdge() {
        DefaultEdge defaultEdge = new DefaultEdge(this.mNode, this.iNode);
        this.mNode.addOutEdge(defaultEdge);
        DefaultNodeTest.assertEquals((int)1, (int)this.mNode.getOutEdges().size());
        DefaultNodeTest.assertTrue((boolean)this.mNode.getOutEdges().contains(defaultEdge));
        DefaultNodeTest.assertTrue((boolean)this.mNode.getOutNodes().contains(this.iNode));
        DefaultNodeTest.assertTrue((boolean)this.mNode.getToNodes().contains(this.iNode));
    }

    public void testAddInEdge() {
        DefaultEdge defaultEdge = new DefaultEdge(this.mNode, this.iNode);
        this.iNode.addInEdge(defaultEdge);
        DefaultNodeTest.assertEquals((int)3, (int)this.iNode.getInEdges().size());
        DefaultNodeTest.assertTrue((boolean)this.iNode.getInEdges().contains(defaultEdge));
        DefaultNodeTest.assertTrue((boolean)this.iNode.getFromNodes().contains(this.mNode));
    }

    public void testAddOutEdges() {
        ArrayList<DefaultEdge> arrayList = new ArrayList<DefaultEdge>();
        DefaultEdge defaultEdge = new DefaultEdge(this.mNode, this.iNode);
        DefaultEdge defaultEdge2 = new DefaultEdge(this.mNode, this.kNode);
        arrayList.add(defaultEdge);
        arrayList.add(defaultEdge2);
        this.mNode.addOutEdges(arrayList);
        DefaultNodeTest.assertEquals((int)2, (int)this.mNode.getOutEdges().size());
        DefaultNodeTest.assertTrue((boolean)this.mNode.getOutEdges().contains(defaultEdge));
        DefaultNodeTest.assertTrue((boolean)this.mNode.getToNodes().contains(this.iNode));
        DefaultNodeTest.assertTrue((boolean)this.mNode.getToNodes().contains(this.kNode));
        DefaultNodeTest.assertTrue((!this.mNode.getToNodes().contains(this.jNode) ? 1 : 0) != 0);
    }

    public void testAddInEdges() {
        ArrayList<DefaultEdge> arrayList = new ArrayList<DefaultEdge>();
        DefaultEdge defaultEdge = new DefaultEdge(this.iNode, this.mNode);
        DefaultEdge defaultEdge2 = new DefaultEdge(this.kNode, this.mNode);
        arrayList.add(defaultEdge);
        arrayList.add(defaultEdge2);
        this.mNode.addInEdges(arrayList);
        DefaultNodeTest.assertEquals((int)2, (int)this.mNode.getInEdges().size());
        DefaultNodeTest.assertTrue((boolean)this.mNode.getInEdges().contains(defaultEdge));
        DefaultNodeTest.assertTrue((boolean)this.mNode.getFromNodes().contains(this.iNode));
        DefaultNodeTest.assertTrue((boolean)this.mNode.getFromNodes().contains(this.kNode));
        DefaultNodeTest.assertTrue((!this.mNode.getFromNodes().contains(this.jNode) ? 1 : 0) != 0);
    }

    public void testClearInEdges() {
        this.iNode.clearInEdges();
        DefaultNodeTest.assertEquals((int)0, (int)this.iNode.getInEdges().size());
        DefaultNodeTest.assertTrue((!this.iNode.getFromNodes().contains(this.lNode) ? 1 : 0) != 0);
    }

    public void testClearOutEdges() {
        this.iNode.clearOutEdges();
        DefaultNodeTest.assertEquals((int)0, (int)this.iNode.getOutEdges().size());
        DefaultNodeTest.assertTrue((!this.iNode.getToNodes().contains(this.lNode) ? 1 : 0) != 0);
    }

    public void testRemoveInEdge() {
        this.kNode.removeInEdge(this.edge4);
        DefaultNodeTest.assertEquals((int)1, (int)this.kNode.getInEdges().size());
        DefaultNodeTest.assertTrue((!this.kNode.getFromNodes().contains(this.jNode) ? 1 : 0) != 0);
    }

    public void testRemoveOutEdge() {
        this.kNode.removeOutEdge(this.edge6);
        DefaultNodeTest.assertEquals((int)2, (int)this.kNode.getOutEdges().size());
        DefaultNodeTest.assertTrue((!this.kNode.getToNodes().contains(this.jNode) ? 1 : 0) != 0);
        DefaultNodeTest.assertTrue((boolean)this.jNode.getFromNodes().contains(this.kNode));
    }

    public void testGetRandomFromNode() {
        DefaultNodeTest.assertNull((Object)this.mNode.getRandomFromNode());
        Node node = this.jNode.getRandomFromNode();
        DefaultNodeTest.assertTrue((boolean)this.jNode.getFromNodes().contains(node));
    }

    public void testGetRandomToNode() {
        DefaultNodeTest.assertNull((Object)this.mNode.getRandomToNode());
        Node node = this.jNode.getRandomToNode();
        DefaultNodeTest.assertTrue((boolean)this.jNode.getToNodes().contains(node));
    }

    public void testRemoveEdgesTo() {
        DefaultEdge defaultEdge = new DefaultEdge(this.mNode, this.iNode);
        this.mNode.addOutEdge(defaultEdge);
        DefaultEdge defaultEdge2 = new DefaultEdge(this.mNode, this.iNode);
        this.mNode.addOutEdge(defaultEdge2);
        DefaultNodeTest.assertEquals((int)2, (int)this.mNode.getOutEdges().size());
        this.mNode.removeEdgesTo(this.iNode);
        DefaultNodeTest.assertEquals((int)0, (int)this.mNode.getOutEdges().size());
        DefaultNodeTest.assertTrue((!this.mNode.hasEdgeToOrFrom(this.iNode) ? 1 : 0) != 0);
    }

    public void testRemoveEdgesFrom() {
        DefaultEdge defaultEdge = new DefaultEdge(this.iNode, this.mNode);
        this.mNode.addInEdge(defaultEdge);
        DefaultEdge defaultEdge2 = new DefaultEdge(this.iNode, this.mNode);
        this.mNode.addInEdge(defaultEdge2);
        DefaultNodeTest.assertEquals((int)2, (int)this.mNode.getInEdges().size());
        this.mNode.removeEdgesFrom(this.iNode);
        DefaultNodeTest.assertEquals((int)0, (int)this.mNode.getInEdges().size());
        DefaultNodeTest.assertTrue((!this.mNode.hasEdgeToOrFrom(this.iNode) ? 1 : 0) != 0);
    }

    public void testNumOutEdges() {
        DefaultNodeTest.assertEquals((int)2, (int)this.iNode.getNumOutEdges());
    }

    public void testNumInEdges() {
        DefaultNodeTest.assertEquals((int)2, (int)this.kNode.getNumInEdges());
    }

    public void testHasEdgeTo() {
        DefaultNodeTest.assertTrue((boolean)this.iNode.hasEdgeTo(this.lNode));
        DefaultNodeTest.assertTrue((!this.iNode.hasEdgeTo(this.mNode) ? 1 : 0) != 0);
    }

    public void testHasEdgeFrom() {
        DefaultNodeTest.assertTrue((boolean)this.iNode.hasEdgeFrom(this.kNode));
        DefaultNodeTest.assertTrue((!this.iNode.hasEdgeFrom(this.mNode) ? 1 : 0) != 0);
    }

    public void testGetEdgesTo() {
        HashSet hashSet = this.lNode.getEdgesTo(this.iNode);
        DefaultNodeTest.assertTrue((boolean)hashSet.contains(this.edge8));
        DefaultNodeTest.assertEquals((int)1, (int)hashSet.size());
        DefaultNodeTest.assertNull((Object)this.mNode.getEdgesTo(this.iNode));
    }

    public void testGetEdgesFrom() {
        DefaultEdge defaultEdge = new DefaultEdge(this.jNode, this.kNode);
        this.kNode.addInEdge(defaultEdge);
        HashSet hashSet = this.kNode.getEdgesFrom(this.jNode);
        DefaultNodeTest.assertEquals((int)2, (int)hashSet.size());
        DefaultNodeTest.assertNull((Object)this.mNode.getEdgesFrom(this.iNode));
    }

    public void testEdgeUpdates() {
        DefaultNodeTest.assertTrue((boolean)this.iNode.hasEdgeTo(this.lNode));
        this.edge1.setTo(this.mNode);
        DefaultNodeTest.assertEquals((int)1, (int)this.mNode.getInDegree());
        this.mNode.addInEdge(this.edge1);
        DefaultNodeTest.assertEquals((int)1, (int)this.mNode.getInDegree());
        DefaultNodeTest.assertTrue((!this.iNode.hasEdgeTo(this.lNode) ? 1 : 0) != 0);
        DefaultNodeTest.assertTrue((boolean)this.iNode.hasEdgeTo(this.mNode));
        DefaultNodeTest.assertEquals((int)2, (int)this.iNode.getOutDegree());
        this.iNode.addOutEdge(this.edge1);
        DefaultNodeTest.assertEquals((int)2, (int)this.iNode.getOutDegree());
        DefaultNodeTest.assertTrue((boolean)this.iNode.hasEdgeFrom(this.lNode));
        this.edge8.setFrom(this.mNode);
        DefaultNodeTest.assertEquals((int)1, (int)this.mNode.getOutDegree());
        this.mNode.addOutEdge(this.edge8);
        DefaultNodeTest.assertEquals((int)1, (int)this.mNode.getOutDegree());
        DefaultNodeTest.assertTrue((!this.iNode.hasEdgeFrom(this.lNode) ? 1 : 0) != 0);
        DefaultNodeTest.assertTrue((boolean)this.mNode.hasEdgeFrom(this.iNode));
        DefaultNodeTest.assertEquals((int)2, (int)this.iNode.getInDegree());
        this.iNode.addInEdge(this.edge8);
        DefaultNodeTest.assertEquals((int)2, (int)this.iNode.getInDegree());
    }

    public void testRandomRewire() {
        Random.setSeed(1000L);
        Random.createUniform();
        List list = NetworkFactory.getNetwork("uchicago/src/sim/test/krackhardt_advice.dl", 0, class$uchicago$src$sim$network$DefaultNode == null ? (class$uchicago$src$sim$network$DefaultNode = DefaultNodeTest.class$("uchicago.src.sim.network.DefaultNode")) : class$uchicago$src$sim$network$DefaultNode, class$uchicago$src$sim$network$DefaultEdge == null ? (class$uchicago$src$sim$network$DefaultEdge = DefaultNodeTest.class$("uchicago.src.sim.network.DefaultEdge")) : class$uchicago$src$sim$network$DefaultEdge, 0);
        DefaultNodeTest.assertTrue((!NetUtilities.isMultiplexNet(list) ? 1 : 0) != 0);
        NetUtilities.randomRewire(list, 0.2);
        DefaultNodeTest.assertTrue((!NetUtilities.isMultiplexNet(list) ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(class$uchicago$src$sim$test$DefaultNodeTest == null ? (class$uchicago$src$sim$test$DefaultNodeTest = DefaultNodeTest.class$("uchicago.src.sim.test.DefaultNodeTest")) : class$uchicago$src$sim$test$DefaultNodeTest);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

