/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import uchicago.src.sim.engine.SimpleModel;
import uchicago.src.sim.parameter.ParameterSetter;
import uchicago.src.sim.parameter.ParameterSetterFactory;

public class DefaultParameterTest
extends TestCase {
    private TestSimModel simModel;
    private ParameterSetter setter;
    static /* synthetic */ Class class$uchicago$src$sim$test$DefaultParameterTest;

    public DefaultParameterTest(String string) {
        super(string);
    }

    public void setUp() {
        try {
            this.setter = ParameterSetterFactory.createParameterSetter("./TestParams.txt");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.simModel = new TestSimModel();
    }

    public void testSetParams() {
        this.setter.setModelParameters(this.simModel);
        DefaultParameterTest.assertEquals((int)10, (int)this.simModel.getIntA());
        DefaultParameterTest.assertEquals((Object)"bob", (Object)this.simModel.getStrB());
        DefaultParameterTest.assertEquals((boolean)true, (boolean)this.simModel.isBooleanC());
        DefaultParameterTest.assertEquals((float)2342.2341f, (float)this.simModel.getFloatD(), (float)0.0f);
    }

    public void testNextParams() {
        int n = 0;
        int n2 = 1;
        int n3 = 10;
        boolean bl = true;
        String string = "bob";
        while (this.setter.hasNext()) {
            this.setter.setNextModelParameters(this.simModel);
            if (!this.setter.hasNext()) break;
            DefaultParameterTest.assertEquals((float)2342.2341f, (float)this.simModel.getFloatD(), (float)0.0f);
            bl = n2 % 2 != 0;
            if (n2 == 3) {
                string = "bill";
            }
            if (n2 == 5) {
                string = "cormac";
            }
            if (n2 == 7) {
                n3 += 10;
                string = "bob";
                bl = true;
                n2 = 1;
            }
            DefaultParameterTest.assertEquals((String)("count = " + n2), (int)n3, (int)this.simModel.getIntA());
            DefaultParameterTest.assertEquals((String)("count = " + n2), (Object)string, (Object)this.simModel.getStrB());
            DefaultParameterTest.assertEquals((String)("count = " + n2), (boolean)bl, (boolean)this.simModel.isBooleanC());
            ++n2;
            ++n;
        }
        DefaultParameterTest.assertEquals((int)18, (int)n);
    }

    public void testGetDynNames() {
        ArrayList arrayList = this.setter.getDynamicParameterNames();
        DefaultParameterTest.assertEquals((int)3, (int)arrayList.size());
        DefaultParameterTest.assertTrue((boolean)arrayList.contains("IntA"));
        DefaultParameterTest.assertTrue((boolean)arrayList.contains("StrB"));
        DefaultParameterTest.assertTrue((boolean)arrayList.contains("BooleanC"));
    }

    public void testIsParameter() {
        DefaultParameterTest.assertTrue((boolean)this.setter.isParameter("inta"));
        DefaultParameterTest.assertTrue((boolean)this.setter.isParameter("IntA"));
        DefaultParameterTest.assertTrue((!this.setter.isParameter("foo") ? 1 : 0) != 0);
    }

    public void testDefaultModelParameters() {
        Hashtable hashtable = this.setter.getDefaultModelParameters(this.simModel);
        DefaultParameterTest.assertEquals((int)5, (int)hashtable.size());
        DefaultParameterTest.assertEquals(hashtable.get("StrB"), (Object)"bob");
        DefaultParameterTest.assertEquals(hashtable.get("IntA"), (Object)"10.0");
        DefaultParameterTest.assertEquals(hashtable.get("BooleanC"), (Object)"true");
        DefaultParameterTest.assertEquals(hashtable.get("FloatD"), (Object)"2342.23423");
    }

    public static Test suite() {
        return new TestSuite(class$uchicago$src$sim$test$DefaultParameterTest == null ? (class$uchicago$src$sim$test$DefaultParameterTest = DefaultParameterTest.class$("uchicago.src.sim.test.DefaultParameterTest")) : class$uchicago$src$sim$test$DefaultParameterTest);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class TestSimModel
    extends SimpleModel {
        private int intA = 0;
        private String strB = "foo";
        private boolean booleanC = false;
        private float floatD = 3.21f;

        public TestSimModel() {
            this.params = new String[]{"IntA", "StrB", "BooleanC", "FloatD"};
        }

        public int getIntA() {
            return this.intA;
        }

        public void setIntA(int n) {
            this.intA = n;
        }

        public String getStrB() {
            return this.strB;
        }

        public void setStrB(String string) {
            this.strB = string;
        }

        public boolean isBooleanC() {
            return this.booleanC;
        }

        public void setBooleanC(boolean bl) {
            this.booleanC = bl;
        }

        public float getFloatD() {
            return this.floatD;
        }

        public void setFloatD(float f) {
            this.floatD = f;
        }
    }
}

