/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.test;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import uchicago.src.sim.engine.DefaultGroup;
import uchicago.src.sim.engine.Group;

public class GroupTest
extends TestCase {
    private Group group;
    private ArrayList list;
    static /* synthetic */ Class class$uchicago$src$sim$test$GroupTest;

    public GroupTest(String string) {
        super(string);
    }

    public void setUp() {
        this.list = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            this.list.add(new GroupItem(i));
        }
        this.group = new DefaultGroup(this.list, "run");
    }

    public void testSize() {
        GroupTest.assertEquals((int)10, (int)this.group.size());
    }

    public void testIsEmpty() {
        GroupTest.assertTrue((!this.group.isEmpty() ? 1 : 0) != 0);
        this.group.clear();
        GroupTest.assertTrue((boolean)this.group.isEmpty());
    }

    public void testAdd() {
        this.group.add(new GroupItem(11));
        this.group.add(new GroupItem(12));
        GroupTest.assertEquals((int)12, (int)this.group.size());
    }

    public void testStep() {
        GroupItem groupItem;
        Iterator iterator = this.group.iterator();
        while (iterator.hasNext()) {
            groupItem = (GroupItem)iterator.next();
            GroupTest.assertEquals((int)0, (int)groupItem.getRunCount());
        }
        this.group.step();
        iterator = this.group.iterator();
        while (iterator.hasNext()) {
            groupItem = (GroupItem)iterator.next();
            GroupTest.assertEquals((int)1, (int)groupItem.getRunCount());
        }
    }

    public void testMin() {
        int n = (int)this.group.min("getVal");
        GroupTest.assertEquals((int)0, (int)n);
        this.group.add(new GroupItem(-10));
        n = (int)this.group.min("getVal");
        GroupTest.assertEquals((int)-10, (int)n);
    }

    public void testMax() {
        int n = (int)this.group.max("getVal");
        GroupTest.assertEquals((int)9, (int)n);
        this.group.add(new GroupItem(100));
        n = (int)this.group.max("getVal");
        GroupTest.assertEquals((int)100, (int)n);
    }

    public void testAvg() {
        double d = this.group.avg("getVal");
        GroupTest.assertEquals((double)4.5, (double)d, (double)0.0);
    }

    public void testMinItem() {
        GroupItem groupItem = (GroupItem)this.group.iterator().next();
        List list = this.group.getItemWithMinValue("getVal");
        GroupTest.assertEquals((int)1, (int)list.size());
        GroupTest.assertEquals((Object)groupItem, list.get(0));
        GroupItem groupItem2 = new GroupItem(0);
        this.group.add(groupItem2);
        list = this.group.getItemWithMinValue("getVal");
        GroupTest.assertEquals((int)2, (int)list.size());
        GroupTest.assertTrue((boolean)list.contains(groupItem));
        GroupTest.assertTrue((boolean)list.contains(groupItem2));
        GroupItem groupItem3 = new GroupItem(-1000);
        this.group.add(groupItem3);
        list = this.group.getItemWithMinValue("getVal");
        GroupTest.assertEquals((int)1, (int)list.size());
        GroupTest.assertEquals((Object)groupItem3, list.get(0));
    }

    public void testMaxItem() {
        GroupItem groupItem = new GroupItem(1000);
        this.group.add(groupItem);
        List list = this.group.getItemWithMaxValue("getVal");
        GroupTest.assertEquals((int)1, (int)list.size());
        GroupTest.assertEquals((Object)groupItem, list.get(0));
        GroupItem groupItem2 = new GroupItem(1000);
        this.group.add(groupItem2);
        list = this.group.getItemWithMaxValue("getVal");
        GroupTest.assertEquals((int)2, (int)list.size());
        GroupTest.assertTrue((boolean)list.contains(groupItem));
        GroupTest.assertTrue((boolean)list.contains(groupItem2));
    }

    public void testCall() {
        GroupItem groupItem;
        Iterator iterator = this.group.iterator();
        while (iterator.hasNext()) {
            groupItem = (GroupItem)iterator.next();
            GroupTest.assertEquals((int)0, (int)groupItem.getRunCount());
        }
        this.group.call("run");
        iterator = this.group.iterator();
        while (iterator.hasNext()) {
            groupItem = (GroupItem)iterator.next();
            GroupTest.assertEquals((int)1, (int)groupItem.getRunCount());
        }
    }

    public static Test suite() {
        return new TestSuite(class$uchicago$src$sim$test$GroupTest == null ? (class$uchicago$src$sim$test$GroupTest = GroupTest.class$("uchicago.src.sim.test.GroupTest")) : class$uchicago$src$sim$test$GroupTest);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class GroupItem {
        int val;
        int runCount = 0;

        public GroupItem(int n) {
            this.val = n;
        }

        public void run() {
            ++this.runCount;
        }

        public int getRunCount() {
            return this.runCount;
        }

        public int getVal() {
            return this.val;
        }

        public void setVal(int n) {
            this.val = n;
        }
    }
}

