/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import uchicago.src.sim.engine.ActionQueue;
import uchicago.src.sim.engine.BasicAction;

public class QueueTest
extends TestCase {
    private ActionQueue queue;
    static /* synthetic */ Class class$uchicago$src$sim$test$QueueTest;

    public QueueTest(String string) {
        super(string);
    }

    public void setUp() {
        this.queue = new ActionQueue(10);
        TestQueueAction testQueueAction = new TestQueueAction();
        testQueueAction.setNextTime(3.2);
        this.queue.insert(testQueueAction);
        testQueueAction = new TestQueueAction();
        testQueueAction.setNextTime(1.3);
        this.queue.insert(testQueueAction);
        testQueueAction = new TestQueueAction();
        testQueueAction.setNextTime(100.0);
        this.queue.insert(testQueueAction);
        testQueueAction = new TestQueueAction();
        testQueueAction.setNextTime(0.2343);
        this.queue.insert(testQueueAction);
        testQueueAction = new TestQueueAction();
        testQueueAction.setNextTime(10.3);
        this.queue.insert(testQueueAction);
    }

    public void testSize() {
        QueueTest.assertTrue((this.queue.size() == 5 ? 1 : 0) != 0);
        ActionQueue actionQueue = new ActionQueue();
        QueueTest.assertTrue((actionQueue.size() == 0 ? 1 : 0) != 0);
    }

    public void testIsEmpty() {
        QueueTest.assertTrue((!this.queue.isEmpty() ? 1 : 0) != 0);
        ActionQueue actionQueue = new ActionQueue();
        QueueTest.assertTrue((boolean)actionQueue.isEmpty());
    }

    public void testGetMin() {
        BasicAction basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)0.2343, (double)basicAction.getNextTime(), (double)0.0);
        basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)1.3, (double)basicAction.getNextTime(), (double)0.0);
        basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)3.2, (double)basicAction.getNextTime(), (double)0.0);
        basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)10.3, (double)basicAction.getNextTime(), (double)0.0);
        basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)100.0, (double)basicAction.getNextTime(), (double)0.0);
        QueueTest.assertEquals((int)0, (int)this.queue.size());
        QueueTest.assertTrue((boolean)this.queue.isEmpty());
    }

    public void testPeekMin() {
        BasicAction basicAction = this.queue.peekMin();
        QueueTest.assertEquals((double)0.2343, (double)basicAction.getNextTime(), (double)0.0);
        basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)0.2343, (double)basicAction.getNextTime(), (double)0.0);
    }

    public void testToss() {
        TestQueueAction testQueueAction = new TestQueueAction();
        testQueueAction.setNextTime(-32.0);
        this.queue.toss(testQueueAction);
        BasicAction basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)-32.0, (double)basicAction.getNextTime(), (double)0.0);
        basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)0.2343, (double)basicAction.getNextTime(), (double)0.0);
        basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)1.3, (double)basicAction.getNextTime(), (double)0.0);
        testQueueAction = new TestQueueAction();
        testQueueAction.setNextTime(-32.0);
        this.queue.toss(testQueueAction);
        testQueueAction = new TestQueueAction();
        testQueueAction.setNextTime(40.0);
        this.queue.insert(testQueueAction);
        basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)-32.0, (double)basicAction.getNextTime(), (double)0.0);
        basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)3.2, (double)basicAction.getNextTime(), (double)0.0);
        basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)10.3, (double)basicAction.getNextTime(), (double)0.0);
        basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)40.0, (double)basicAction.getNextTime(), (double)0.0);
        basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)100.0, (double)basicAction.getNextTime(), (double)0.0);
        QueueTest.assertEquals((int)0, (int)this.queue.size());
        QueueTest.assertTrue((boolean)this.queue.isEmpty());
    }

    public void testClear() {
        this.queue.clear();
        TestQueueAction testQueueAction = new TestQueueAction();
        testQueueAction.setNextTime(3.2);
        this.queue.insert(testQueueAction);
        testQueueAction = new TestQueueAction();
        testQueueAction.setNextTime(1.3);
        this.queue.insert(testQueueAction);
        QueueTest.assertEquals((int)2, (int)this.queue.size());
        BasicAction basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)1.3, (double)basicAction.getNextTime(), (double)0.0);
        basicAction = this.queue.popMin();
        QueueTest.assertEquals((double)3.2, (double)basicAction.getNextTime(), (double)0.0);
    }

    public static Test suite() {
        return new TestSuite(class$uchicago$src$sim$test$QueueTest == null ? (class$uchicago$src$sim$test$QueueTest = QueueTest.class$("uchicago.src.sim.test.QueueTest")) : class$uchicago$src$sim$test$QueueTest);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TestQueueAction
    extends BasicAction {
        TestQueueAction() {
        }

        public void execute() {
        }
    }
}

