/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import uchicago.src.sim.engine.SimpleModel;
import uchicago.src.sim.parameter.ParameterSetter;
import uchicago.src.sim.parameter.ParameterSetterFactory;

public class RPLParameterTest
extends TestCase {
    private TestSimModel simModel;
    private ParameterSetter setter;
    static /* synthetic */ Class class$uchicago$src$sim$test$RPLParameterTest;

    public RPLParameterTest(String string) {
        super(string);
    }

    public void setUp() {
        try {
            this.setter = ParameterSetterFactory.createParameterSetter("./test.rpl");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.simModel = new TestSimModel();
    }

    public void testIsConstant() {
        boolean bl = this.setter.isConstant("BooleanC");
        RPLParameterTest.assertTrue((boolean)bl);
        bl = this.setter.isConstant("booleanc");
        RPLParameterTest.assertTrue((boolean)bl);
        bl = this.setter.isConstant("DoubleE");
        RPLParameterTest.assertTrue((!bl ? 1 : 0) != 0);
    }

    public void testIsParameter() {
        boolean bl = this.setter.isParameter("DoubleE");
        RPLParameterTest.assertTrue((boolean)bl);
        bl = this.setter.isParameter("doubleE");
        RPLParameterTest.assertTrue((boolean)bl);
        bl = this.setter.isParameter("booleanc");
        RPLParameterTest.assertTrue((boolean)bl);
    }

    public void testGetDynamicParameterNames() {
        ArrayList arrayList = this.setter.getDynamicParameterNames();
        RPLParameterTest.assertTrue((boolean)arrayList.contains("IntA"));
        RPLParameterTest.assertTrue((boolean)arrayList.contains("StrB"));
        RPLParameterTest.assertTrue((boolean)arrayList.contains("FloatD"));
        RPLParameterTest.assertTrue((boolean)arrayList.contains("DoubleE"));
        RPLParameterTest.assertTrue((!arrayList.contains("BooleanC") ? 1 : 0) != 0);
    }

    public void testSetModelParams() {
        this.setter.setModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Cormac", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
    }

    public void testNext() {
        boolean bl = this.setter.hasNext();
        RPLParameterTest.assertTrue((boolean)bl);
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Cormac", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)false, (boolean)this.simModel.isBooleanC());
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Nick", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Caitrin", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"foo", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)false, (boolean)this.simModel.isBooleanC());
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"foo", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)1.5, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"foo", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)2.0, (double)this.simModel.getDoubleE(), (double)0.0);
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)2, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Cormac", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)false, (boolean)this.simModel.isBooleanC());
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)2, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Nick", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)2, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Caitrin", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)2, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"foo", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)false, (boolean)this.simModel.isBooleanC());
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)2, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"foo", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)1.5, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)2, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"foo", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)2.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)false, (boolean)this.simModel.isBooleanC());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)-1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Cormac", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)true, (boolean)this.simModel.isBooleanC());
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)-1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Nick", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)true, (boolean)this.simModel.isBooleanC());
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)3.0f, (float)this.simModel.getFloatD(), (float)0.0f);
        RPLParameterTest.assertEquals((int)-1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Caitrin", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)true, (boolean)this.simModel.isBooleanC());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((double)-21.2, (double)this.simModel.getFloatD(), (double)0.1f);
        RPLParameterTest.assertEquals((int)1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Cormac", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)false, (boolean)this.simModel.isBooleanC());
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((double)-21.2, (double)this.simModel.getFloatD(), (double)0.1f);
        RPLParameterTest.assertEquals((int)1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Nick", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((double)-21.2, (double)this.simModel.getFloatD(), (double)0.1f);
        RPLParameterTest.assertEquals((int)1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Caitrin", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((double)-21.2, (double)this.simModel.getFloatD(), (double)0.1f);
        RPLParameterTest.assertEquals((int)1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"foo", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)false, (boolean)this.simModel.isBooleanC());
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((double)-21.2, (double)this.simModel.getFloatD(), (double)0.1f);
        RPLParameterTest.assertEquals((int)1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"foo", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)1.5, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((double)-21.2, (double)this.simModel.getFloatD(), (double)0.1f);
        RPLParameterTest.assertEquals((int)1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"foo", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)2.0, (double)this.simModel.getDoubleE(), (double)0.0);
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((double)-21.2, (double)this.simModel.getFloatD(), (double)0.1f);
        RPLParameterTest.assertEquals((int)2, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Cormac", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)false, (boolean)this.simModel.isBooleanC());
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((double)-21.2, (double)this.simModel.getFloatD(), (double)0.1f);
        RPLParameterTest.assertEquals((int)2, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Nick", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((double)-21.2, (double)this.simModel.getFloatD(), (double)0.1f);
        RPLParameterTest.assertEquals((int)2, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Caitrin", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((double)-21.2, (double)this.simModel.getFloatD(), (double)0.1f);
        RPLParameterTest.assertEquals((int)2, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"foo", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)false, (boolean)this.simModel.isBooleanC());
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((double)-21.2, (double)this.simModel.getFloatD(), (double)0.1f);
        RPLParameterTest.assertEquals((int)2, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"foo", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)1.5, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((double)-21.2, (double)this.simModel.getFloatD(), (double)0.1f);
        RPLParameterTest.assertEquals((int)2, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"foo", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)2.0, (double)this.simModel.getDoubleE(), (double)0.0);
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((double)-21.2, (double)this.simModel.getFloatD(), (double)0.1f);
        RPLParameterTest.assertEquals((int)-1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Cormac", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)true, (boolean)this.simModel.isBooleanC());
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((double)-21.2, (double)this.simModel.getFloatD(), (double)0.1f);
        RPLParameterTest.assertEquals((int)-1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Nick", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)true, (boolean)this.simModel.isBooleanC());
        RPLParameterTest.assertTrue((boolean)this.setter.hasNext());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((double)-21.2, (double)this.simModel.getFloatD(), (double)0.1f);
        RPLParameterTest.assertEquals((int)-1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"Caitrin", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)true, (boolean)this.simModel.isBooleanC());
        this.simModel.setup();
        this.setter.setNextModelParameters(this.simModel);
        RPLParameterTest.assertEquals((float)-1.0f, (float)this.simModel.getFloatD(), (float)0.1f);
        RPLParameterTest.assertEquals((int)-1, (int)this.simModel.getIntA());
        RPLParameterTest.assertEquals((Object)"foo", (Object)this.simModel.getStrB());
        RPLParameterTest.assertEquals((double)-1.0, (double)this.simModel.getDoubleE(), (double)0.0);
        RPLParameterTest.assertEquals((boolean)true, (boolean)this.simModel.isBooleanC());
        RPLParameterTest.assertTrue((!this.setter.hasNext() ? 1 : 0) != 0);
    }

    public void testGetParam() {
        this.simModel.setup();
        Object object = this.setter.getParameterValue("IntA", this.simModel);
        RPLParameterTest.assertEquals((int)1, (int)((Integer)object));
        object = this.setter.getParameterValue("BooleanC", this.simModel);
        RPLParameterTest.assertEquals((Object)Boolean.FALSE, (Object)object);
    }

    public void testGetDefaultModelParams() {
        this.simModel.setup();
        Hashtable hashtable = this.setter.getDefaultModelParameters(this.simModel);
        RPLParameterTest.assertEquals((Object)new Integer(1), hashtable.get("IntA"));
        System.out.println(hashtable.get("FloatD").getClass());
        RPLParameterTest.assertEquals((Object)new Float(3.0f), hashtable.get("FloatD"));
        RPLParameterTest.assertEquals((Object)new String("Cormac"), hashtable.get("StrB"));
        RPLParameterTest.assertEquals((Object)new Double(1.0), hashtable.get("DoubleE"));
        RPLParameterTest.assertEquals((Object)Boolean.FALSE, hashtable.get("BooleanC"));
        RPLParameterTest.assertTrue((boolean)hashtable.containsKey("RngSeed"));
        RPLParameterTest.assertEquals((Object)new Integer(123), hashtable.get("FooInt"));
    }

    public static Test suite() {
        return new TestSuite(class$uchicago$src$sim$test$RPLParameterTest == null ? (class$uchicago$src$sim$test$RPLParameterTest = RPLParameterTest.class$("uchicago.src.sim.test.RPLParameterTest")) : class$uchicago$src$sim$test$RPLParameterTest);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class TestSimModel
    extends SimpleModel {
        public static final int INT_ONE = 1;
        public static final int INT_FIVE = 5;
        private int intA = -1;
        private String strB = "foo";
        private boolean booleanC = false;
        private float floatD = -1.0f;
        private double doubleE = -1.0;
        private int fooInt = 123;

        public TestSimModel() {
            this.params = new String[]{"IntA", "StrB", "BooleanC", "FloatD", "DoubleE", "FooInt"};
        }

        public int getIntA() {
            return this.intA;
        }

        public void setIntA(int n) {
            this.intA = n;
        }

        public String getStrB() {
            return this.strB;
        }

        public void setStrB(String string) {
            this.strB = string;
        }

        public boolean isBooleanC() {
            return this.booleanC;
        }

        public void setBooleanC(boolean bl) {
            this.booleanC = bl;
        }

        public float getFloatD() {
            return this.floatD;
        }

        public void setFloatD(float f) {
            this.floatD = f;
        }

        public double getDoubleE() {
            return this.doubleE;
        }

        public void setDoubleE(double d) {
            this.doubleE = d;
        }

        public int getFooInt() {
            return this.fooInt;
        }

        public void setFooInt(int n) {
            this.fooInt = n;
        }

        public void setup() {
            this.strB = "foo";
            this.doubleE = -1.0;
            this.booleanC = true;
            this.floatD = -1.0f;
            this.intA = -1;
            this.fooInt = 123;
        }
    }
}

