/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.test;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import uchicago.src.sim.engine.Schedule;
import uchicago.src.sim.test.ScheduleTestAgent;
import uchicago.src.sim.util.Random;

public class ScheduleListTest
extends TestCase {
    private ArrayList list = new ArrayList();
    private Schedule schedule;
    private String order;
    private String newOrder;
    static /* synthetic */ Class class$uchicago$src$sim$test$ScheduleListTest;

    public ScheduleListTest(String string) {
        super(string);
    }

    public void setUp() {
        int n;
        Random.createUniform();
        this.schedule = new Schedule();
        this.list = new ArrayList();
        for (n = 0; n < 20; ++n) {
            this.list.add(new ScheduleTestAgent(n, this.schedule));
        }
        this.order = new String();
        for (n = 0; n < 20; ++n) {
            ScheduleTestAgent scheduleTestAgent = (ScheduleTestAgent)this.list.get(n);
            this.order = this.order + scheduleTestAgent.getId() + " ";
        }
    }

    private String getTicks() {
        return ((ScheduleTestAgent)this.list.get(0)).getTicks();
    }

    private void orderComp() {
        this.orderComp(10);
    }

    private void orderComp(int n) {
        this.runSchedule(n);
        this.newOrder = "";
        for (int i = 0; i < 20; ++i) {
            ScheduleTestAgent scheduleTestAgent = (ScheduleTestAgent)this.list.get(i);
            this.newOrder = this.newOrder + scheduleTestAgent.getId() + " ";
        }
    }

    public void testAtRnd() {
        this.schedule.scheduleActionAtRnd(3.0, this.list, "printId");
        this.orderComp();
        ScheduleListTest.assertTrue((String)"shuffled list == unshuffled list", (!this.newOrder.equals(this.order) ? 1 : 0) != 0);
        ScheduleListTest.assertTrue((boolean)"3.0 ".equals(this.getTicks()));
    }

    public void testAtRndLast() {
        this.schedule.scheduleActionAtRnd(4.0, (List)this.list, "printId", Schedule.LAST);
        this.orderComp();
        ScheduleListTest.assertTrue((String)"shuffled list == unshuffled list", (!this.newOrder.equals(this.order) ? 1 : 0) != 0);
        ScheduleListTest.assertTrue((boolean)"4.0 ".equals(this.getTicks()));
    }

    public void testIntervalRnd() {
        this.schedule.scheduleActionAtIntervalRnd(3.0, this.list, "printId");
        this.orderComp(3);
        ScheduleListTest.assertTrue((String)"shuffled list == unshuffled list", (!this.newOrder.equals(this.order) ? 1 : 0) != 0);
        ScheduleListTest.assertTrue((boolean)"3.0 6.0 9.0 ".equals(this.getTicks()));
    }

    public void testIntervalLastRnd() {
        this.schedule.scheduleActionAtIntervalRnd(3.0, (List)this.list, "printId", Schedule.LAST);
        this.orderComp(3);
        ScheduleListTest.assertTrue((String)"shuffled list == unshuffled list", (!this.newOrder.equals(this.order) ? 1 : 0) != 0);
        ScheduleListTest.assertTrue((boolean)"3.0 6.0 9.0 ".equals(this.getTicks()));
    }

    public void testBeginningRnd() {
        this.schedule.scheduleActionBeginningRnd(1.0, this.list, "printId");
        this.orderComp();
        ScheduleListTest.assertTrue((String)"shuffled list == unshuffled list", (!this.newOrder.equals(this.order) ? 1 : 0) != 0);
        ScheduleListTest.assertTrue((boolean)"1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 ".equals(this.getTicks()));
    }

    public void testOrder() {
        String string = "";
        for (int i = 0; i < 20; ++i) {
            ScheduleTestAgent scheduleTestAgent = (ScheduleTestAgent)this.list.get(i);
            string = string + scheduleTestAgent.getId() + " ";
        }
        ScheduleListTest.assertTrue((String)"unshuffled != unshuffled", (boolean)this.order.equals(string));
    }

    public void runSchedule(int n) {
        for (int i = 0; i < n; ++i) {
            this.schedule.execute();
        }
    }

    public void runSchedule() {
        this.runSchedule(10);
    }

    public static Test suite() {
        return new TestSuite(class$uchicago$src$sim$test$ScheduleListTest == null ? (class$uchicago$src$sim$test$ScheduleListTest = ScheduleListTest.class$("uchicago.src.sim.test.ScheduleListTest")) : class$uchicago$src$sim$test$ScheduleListTest);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

