/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import uchicago.src.sim.topology.graph.AbstractGraph;
import uchicago.src.sim.topology.graph.DefaultEdge;
import uchicago.src.sim.topology.graph.Edge;
import uchicago.src.sim.topology.graph.EdgeType;

public class UndirectedGraph
extends AbstractGraph {
    private HashMap relations;
    private Set con;

    public UndirectedGraph(Set set, String string) {
        this.con = set;
        this.type = string;
        this.relations = new HashMap();
    }

    public UndirectedGraph(Set set) {
        this(set, "");
    }

    public boolean areAdjacent(Object object, Object object2) {
        return this.getEdgeSet(object).contains(this.getQuery(object, object2));
    }

    public void insertEdge(Object object, Object object2, double d) {
        DefaultEdge defaultEdge = new DefaultEdge(object, object2);
        DefaultEdge defaultEdge2 = new DefaultEdge(object2, object);
        this.getEdgeSet(object).add(defaultEdge);
        this.getEdgeSet(object2).add(defaultEdge2);
    }

    public void insertEdge(Object object, Object object2) {
        this.insertEdge(object, object2, 1.0);
    }

    protected Set getEdgeSet(Object object) {
        LinkedHashSet linkedHashSet = (LinkedHashSet)this.relations.get(object);
        if (linkedHashSet == null) {
            linkedHashSet = new LinkedHashSet();
            this.relations.put(object, linkedHashSet);
        }
        return linkedHashSet;
    }

    public void insertEdge(Edge edge) {
        this.getEdgeSet(edge.getElementOne()).add(edge);
        this.getEdgeSet(edge.getElementTwo()).add(edge);
    }

    public void removeEdge(Edge edge) {
        Set set = this.getEdgeSet(edge.getElementOne());
        Set set2 = this.getEdgeSet(edge.getElementTwo());
        set.remove(edge);
        set2.remove(edge);
    }

    public void removeEdge(Object object, Object object2) {
        Edge edge = this.getQuery(object, object2);
        Set set = this.getEdgeSet(object);
        Set set2 = this.getEdgeSet(object2);
        set.remove(edge);
        edge = this.getQuery(object2, object);
        set2.remove(edge);
    }

    public void makeUndirected(Edge edge) {
        throw new UnsupportedOperationException("All edges in DefaultGraph must beUndirected");
    }

    public boolean isUndirected(Edge edge) {
        return true;
    }

    public boolean reverseDirection(Edge edge) {
        throw new UnsupportedOperationException("All edges in an DefaultGraph are Undirected");
    }

    public void setDirectionFrom(Edge edge, Object object) {
        throw new UnsupportedOperationException("You can't set the directionality in an undirected Graph");
    }

    public List getAdjacentNodes(Object object, EdgeType edgeType) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Set set = this.getEdgeSet(object);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            arrayList.add(edge.getElementTwo());
        }
        return arrayList;
    }

    public boolean areAdjacent(Object object, Object object2, EdgeType edgeType) {
        return this.areAdjacent(object, object2);
    }

    public List getEdges(Object object, EdgeType edgeType) {
        return new ArrayList(this.getEdgeSet(object));
    }

    public Edge getEdge(Object object, Object object2) {
        Iterator iterator = this.getEdgeSet(object).iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (!edge.getElementTwo().equals(object2)) continue;
            return edge;
        }
        return null;
    }

    public int degree(Object object, EdgeType edgeType) {
        return this.getEdgeSet(object).size();
    }

    public Iterator iterator() {
        return this.con.iterator();
    }

    public double distance(Object object, Object object2) {
        if (this.areAdjacent(object, object2)) {
            return this.getEdge(object, object2).getStrength();
        }
        return Double.MAX_VALUE;
    }

    public int size() {
        return this.con.size();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UndirectedGraph)) {
            return false;
        }
        UndirectedGraph undirectedGraph = (UndirectedGraph)object;
        if (this.relations != null ? !this.relations.equals(undirectedGraph.relations) : undirectedGraph.relations != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(undirectedGraph.type) : undirectedGraph.type != null);
    }

    public int hashCode() {
        int n = this.relations != null ? this.relations.hashCode() : 0;
        n = 29 * n + (this.type != null ? this.type.hashCode() : 0);
        return n;
    }

    public String toString() {
        return this.getClass().getName() + " of type: " + this.type + " with degree " + this.degree() + ".";
    }

    public int degree() {
        Iterator iterator = this.relations.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            n = ((Set)iterator.next()).size();
        }
        return n / 2;
    }

    private Edge getQuery(Object object, Object object2) {
        return null;
    }

    public List getAdjacentNodes(Object object, double d, EdgeType edgeType) {
        return null;
    }

    public Set getNodes() {
        return this.con;
    }
}

