/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.graph.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import uchicago.src.sim.topology.Context;
import uchicago.src.sim.topology.DefaultContext;
import uchicago.src.sim.topology.RelationTopology;
import uchicago.src.sim.topology.graph.EdgeType;
import uchicago.src.sim.topology.graph.Graph;
import uchicago.src.sim.topology.graph.UndirectedGraph;

public class GraphTest
extends TestCase {
    Context c = new DefaultContext();
    TestObject one = new TestObject("1");
    TestObject two = new TestObject("2");
    TestObject three = new TestObject("3");
    TestObject four = new TestObject("4");
    TestObject five = new TestObject("5");
    TestObject six = new TestObject("6");
    TestObject seven = new TestObject("7");
    TestObject eight = new TestObject("8");
    TestObject nine = new TestObject("9");
    TestObject ten = new TestObject("10");
    static /* synthetic */ Class class$uchicago$src$sim$topology$graph$test$GraphTest;

    public GraphTest(String string) {
        super(string);
        this.setup();
    }

    public void setup() {
        this.c.add((Object)this.one);
        this.c.add((Object)this.two);
        this.c.add((Object)this.three);
        this.c.add((Object)this.four);
        this.c.add((Object)this.five);
        this.c.add((Object)this.six);
        this.c.add((Object)this.seven);
        this.c.add((Object)this.eight);
        this.c.add((Object)this.nine);
        this.c.add((Object)this.ten);
        this.c.addRelationType((RelationTopology)new UndirectedGraph((Set)this.c, "TestRelation"));
        this.c.addRelation((Object)this.one, (Object)this.three, "TestRelation", 1.0);
        this.c.addRelation((Object)this.three, (Object)this.four, "TestRelation", 1.0);
        this.c.addRelation((Object)this.one, (Object)this.seven, "TestRelation", 1.0);
        this.c.addRelation((Object)this.seven, (Object)this.eight, "TestRelation", 1.0);
        this.c.addRelation((Object)this.eight, (Object)this.ten, "TestRelation", 1.0);
        this.c.addRelation((Object)this.three, (Object)this.five, "TestRelation", 1.0);
        this.c.addRelation((Object)this.two, (Object)this.nine, "TestRelation", 1.0);
        this.c.addRelation((Object)this.two, (Object)this.five, "TestRelation", 1.0);
        this.c.addRelation((Object)this.six, (Object)this.five, "TestRelation", 1.0);
    }

    public void testNeighbors() {
        System.out.println("One test");
        List list = this.c.getRelated((Object)this.one, "TestRelation", 1.0);
        GraphTest.assertEquals((int)2, (int)list.size());
        ArrayList<TestObject> arrayList = new ArrayList<TestObject>();
        arrayList.add(this.three);
        arrayList.add(this.seven);
        for (int i = 0; i < list.size(); ++i) {
            GraphTest.assertEquals(list.get(i), arrayList.get(i));
        }
    }

    public void testExtentNeighbors() {
        System.out.println("Three test");
        List list = this.c.getRelated((Object)this.one, "TestRelation", 3.0);
        GraphTest.assertEquals((int)8, (int)list.size());
        ArrayList<TestObject> arrayList = new ArrayList<TestObject>();
        arrayList.add(this.three);
        arrayList.add(this.seven);
        arrayList.add(this.four);
        arrayList.add(this.five);
        arrayList.add(this.eight);
        arrayList.add(this.two);
        arrayList.add(this.six);
        arrayList.add(this.ten);
        for (int i = 0; i < list.size(); ++i) {
            GraphTest.assertEquals(list.get(i), arrayList.get(i));
        }
    }

    public void testGraph() {
        Graph graph = (Graph)this.c.getRelationTopology("TestRelation");
        int n = graph.degree(this.one, EdgeType.ALL);
        GraphTest.assertEquals((int)2, (int)n);
        n = graph.degree(this.six, EdgeType.ALL);
        GraphTest.assertEquals((int)1, (int)n);
    }

    public void testAdjacent() {
        GraphTest.assertTrue((boolean)this.c.areRelated((Object)this.one, (Object)this.three, 1.0, "TestRelation"));
    }

    public void testRemove() {
        this.c.removeRelation((Object)this.two, (Object)this.five, "TestRelation");
        GraphTest.assertTrue((!this.c.areRelated((Object)this.one, (Object)this.five, 1.0, "TestRelation") ? 1 : 0) != 0);
        this.c.addRelation((Object)this.one, (Object)this.five, "TestRelation", 1.0);
    }

    public static Test suite() {
        return new TestSuite(class$uchicago$src$sim$topology$graph$test$GraphTest == null ? (class$uchicago$src$sim$topology$graph$test$GraphTest = GraphTest.class$("uchicago.src.sim.topology.graph.test.GraphTest")) : class$uchicago$src$sim$topology$graph$test$GraphTest);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GraphTest.suite());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TestObject {
        String name;

        public TestObject(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

