/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.graph.util;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import uchicago.src.sim.topology.graph.EdgeType;
import uchicago.src.sim.topology.graph.Graph;
import uchicago.src.sim.topology.graph.util.Queue;

public class BreadthFirstSearch
implements Iterator,
Serializable {
    static final long serialVersionUID = 979864041242197157L;
    private Graph graph;
    private Queue gray;
    private Set black;
    private Set white;

    public BreadthFirstSearch(Graph graph, Object object) {
        this.init(graph, object);
    }

    public BreadthFirstSearch(Graph graph) {
        this.init(graph, graph.getNodes().iterator().next());
    }

    private void init(Graph graph, Object object) {
        this.graph = graph;
        this.white = new HashSet(graph.getNodes());
        this.gray = new Queue();
        this.black = new HashSet();
        this.gray.enqueue(object);
        this.white.remove(object);
    }

    public boolean hasNext() {
        if (this.gray.size() <= 0 && !this.white.isEmpty()) {
            Object e = this.white.iterator().next();
            this.gray.enqueue(e);
            this.white.remove(e);
        }
        return this.gray.size() > 0;
    }

    public Object next() {
        Object object = this.gray.dequeue();
        Iterator iterator = this.graph.getAdjacentNodes(object, EdgeType.ALL).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.gray.contains(e) || this.black.contains(e)) continue;
            this.gray.enqueue(e);
        }
        return object;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

