/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.graph.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import uchicago.src.sim.topology.graph.EdgeType;
import uchicago.src.sim.topology.graph.Graph;
import uchicago.src.sim.topology.graph.util.EdgeClassification;

public class DepthFirstSearch
implements Iterator,
Serializable {
    static final long serialVersionUID = -8943919637144475940L;
    private Graph graph;
    private Stack gray;
    private Set white;
    private Map classifications;
    boolean acyclic = true;

    public DepthFirstSearch(Graph graph) {
        Object e = graph.getNodes().iterator().next();
        this.init(graph, e);
    }

    public DepthFirstSearch(Graph graph, Object object) {
        this.init(graph, object);
    }

    private void init(Graph graph, Object object) {
        this.graph = graph;
        this.gray = new Stack();
        this.classifications = new HashMap();
        this.white = new HashSet(graph.getNodes());
        this.gray.push(object);
        this.white.remove(object);
        this.classifications.put(object, EdgeClassification.FORWARD_EDGE);
    }

    public EdgeClassification getClassification(Object object) {
        return (EdgeClassification)this.classifications.get(object);
    }

    public boolean hasNext() {
        if (this.gray.isEmpty() && !this.white.isEmpty()) {
            Object e = this.white.iterator().next();
            this.gray.push(e);
            this.white.remove(e);
        }
        return !this.gray.isEmpty();
    }

    public Object next() {
        Object e = this.gray.pop();
        List list = this.graph.getAdjacentNodes(e, EdgeType.ALL);
        for (int i = list.size() - 1; i >= 0; --i) {
            Object e2 = list.get(i);
            if (this.gray.contains(e2)) {
                this.classifications.put(e2, EdgeClassification.BACK_EDGE);
                continue;
            }
            if (this.white.contains(e2)) {
                this.gray.push(e2);
                this.white.remove(e2);
                this.classifications.put(e2, EdgeClassification.TREE_EDGE);
                continue;
            }
            this.classifications.put(e2, EdgeClassification.FORWARD_EDGE);
        }
        return e;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

