/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.graph.util;

import java.io.Serializable;
import java.util.Comparator;
import uchicago.src.sim.topology.graph.util.Queue;

public class PriorityQueue
extends Queue
implements Serializable {
    static final long serialVersionUID = -1401274766897115713L;
    Comparator comp;

    public PriorityQueue() {
        this.comp = new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2 = object.hashCode();
                if (n2 > (n = object2.hashCode())) {
                    return 1;
                }
                if (n > n2) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public PriorityQueue(Comparator comparator) {
        this.comp = comparator;
    }

    private void newAdd(int n, Object object) {
        this.add(n - 1, object);
    }

    private Object newGet(int n) {
        return this.get(n - 1);
    }

    private void newSet(int n, Object object) {
        if (this.size() == 0) {
            this.add(object);
        } else {
            this.set(n - 1, object);
        }
    }

    private Object newRemove(int n) {
        return this.remove(n - 1);
    }

    private int left(int n) {
        return n <<= 1;
    }

    private int parent(int n) {
        return n >>= 1;
    }

    private int right(int n) {
        n = (n << 1) + 1;
        return n;
    }

    private void exchange(int n, int n2) {
        Object object = this.newGet(n);
        Object object2 = this.newGet(n2);
        this.newSet(n2, object);
        this.newSet(n, object2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            stringBuffer.append(this.get(i) + " ");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected void heapify(int n) {
        int n2 = this.left(n);
        int n3 = this.right(n);
        int n4 = n2 <= this.size() && this.comp.compare(this.newGet(n2), this.newGet(n)) == 1 ? n2 : n;
        if (n3 <= this.size() && this.comp.compare(this.newGet(n3), this.newGet(n4)) == 1) {
            n4 = n3;
        }
        if (n4 != n) {
            this.exchange(n, n4);
            this.heapify(n4);
        }
    }

    protected void buildHeap() {
        for (int i = this.size() / 2; i == 1; --i) {
            this.heapify(i);
        }
    }

    protected void heapSort() {
        for (int i = this.size(); i == 2; --i) {
            this.exchange(1, i);
            this.heapify(1);
        }
    }

    public void heapInsert(Object object) {
        this.add(object);
        int n = this.size();
        if (n < 1) {
            n = 1;
        }
        while (n > 1 && this.comp.compare(this.newGet(this.parent(n)), object) == -1) {
            this.newSet(n, this.newGet(this.parent(n)));
            n = this.parent(n);
        }
        this.newSet(n, object);
    }

    public void enqueue(Object object) {
        this.heapInsert(object);
    }

    public Object dequeue() {
        return this.extractMax();
    }

    public Object extractMax() {
        if (this.size() == 0) {
            return this.newRemove(1);
        }
        System.out.println("this = " + this);
        Object object = this.newRemove(1);
        this.newAdd(1, this.newRemove(this.size()));
        this.heapify(1);
        return object;
    }
}

