/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.space.d2;

import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import uchicago.src.collection.BaseMatrix;
import uchicago.src.sim.gui.Drawable;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.space.Torus;
import uchicago.src.sim.topology.space.Agent;
import uchicago.src.sim.topology.space.Location;
import uchicago.src.sim.topology.space.Space;
import uchicago.src.sim.topology.space.d2.AbstractObject2DTopology;
import uchicago.src.sim.topology.space.d2.Object2DLocation;
import uchicago.src.sim.topology.space.d2.Object2DSpace;

public abstract class AbstractObject2DSpace
extends AbstractObject2DTopology
implements Object2DSpace {
    protected BaseMatrix matrix = null;

    public AbstractObject2DSpace(String string) {
        super(string);
    }

    public void removeLocation(Location location) {
        Object2DLocation object2DLocation;
        Location location2;
        if (location instanceof Object2DLocation && (location2 = (Location)this.matrix.remove(this.xnorm((object2DLocation = (Object2DLocation)location).getX()), this.ynorm(object2DLocation.getY()))) != null) {
            location2.clear();
        }
    }

    public void removeLocation(int n, int n2) {
        Location location = (Location)this.matrix.remove(this.xnorm(n), this.ynorm(n2));
        if (location != null) {
            location.clear();
        }
    }

    public abstract Location getLocation(int var1, int var2);

    public Location getLocation(Object object) {
        return (Location)this.locations.get(object);
    }

    public BaseMatrix getMatrix() {
        return this.matrix;
    }

    public double[] getSize() {
        return new double[]{this.getMatrix().getNumCols(), this.getMatrix().getNumRows()};
    }

    public int getSizeX() {
        return this.getMatrix().getNumCols();
    }

    public int getSizeY() {
        return this.getMatrix().getNumRows();
    }

    public void trim() {
        for (int i = 0; i < this.getSizeX(); ++i) {
            for (int j = 0; j < this.getSizeY(); ++j) {
                Object2DLocation object2DLocation = (Object2DLocation)this.getMatrix().get(i, j);
                if (object2DLocation == null || !object2DLocation.isEmpty()) continue;
                this.getMatrix().remove(i, j);
            }
        }
        this.getMatrix().trim();
    }

    public int xnorm(int n) {
        if (n < 0 || n >= this.getSizeX()) {
            if (this instanceof Torus) {
                while (n < 0) {
                    n += this.getSizeX();
                }
                return n % this.getSizeX();
            }
            throw new IndexOutOfBoundsException("x coordinate is out of bounds");
        }
        return n;
    }

    public int ynorm(int n) {
        if (n < 0 || n >= this.getSizeY()) {
            if (this instanceof Torus) {
                while (n < 0) {
                    n += this.getSizeY();
                }
                return n % this.getSizeY();
            }
            throw new IndexOutOfBoundsException("y coordinate is out of bounds");
        }
        return n;
    }

    public class Abstract2DLocation
    implements Object2DLocation,
    Drawable {
        protected Collection elements;
        protected int capacity = Integer.MAX_VALUE;
        protected int x;
        protected int y;

        protected Abstract2DLocation(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Object2DLocation)) {
                return false;
            }
            Object2DLocation object2DLocation = (Object2DLocation)object;
            return this.x == object2DLocation.getX() && this.y == object2DLocation.getY() && ((Object)this.elements).equals(object);
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + this.x;
            n = 37 * n + this.y;
            n = 37 * n + ((Object)this.elements).hashCode();
            return n;
        }

        public String toString() {
            return "(x: " + this.x + " y: " + this.y + ")";
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public void setCapacity(int n) {
            this.capacity = n;
        }

        public boolean isFull() {
            return this.size() >= this.capacity;
        }

        public Space getSpace() {
            return AbstractObject2DSpace.this;
        }

        public boolean addAll(Collection collection) {
            boolean bl = !collection.isEmpty();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                bl = !this.add(iterator.next()) ? false : bl;
            }
            return bl;
        }

        public boolean add(Object object) {
            boolean bl = false;
            if (!this.isFull()) {
                bl = this.elements.add(object);
            }
            if (bl) {
                if (!this.isEmpty()) {
                    AbstractObject2DSpace.this.getMatrix().put(this.x, this.y, this);
                }
                if (object instanceof Agent) {
                    ((Agent)object).setLocation(this);
                }
            }
            return bl;
        }

        public boolean remove(Object object) {
            boolean bl = this.elements.remove(object);
            if (bl) {
                if (object instanceof Agent) {
                    ((Agent)object).setLocation(null);
                }
                if (this.isEmpty()) {
                    AbstractObject2DSpace.this.removeLocation(this.x, this.y);
                }
            }
            return bl;
        }

        public void clear() {
            if (!this.isEmpty()) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    iterator.remove();
                }
            }
            this.elements.clear();
        }

        public boolean removeAll(Collection collection) {
            boolean bl = !collection.isEmpty();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!collection.contains(e)) continue;
                bl = true;
                iterator.remove();
            }
            return bl;
        }

        public boolean retainAll(Collection collection) {
            boolean bl = collection.isEmpty();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (collection.contains(e)) continue;
                bl = true;
                iterator.remove();
            }
            return bl;
        }

        public void draw(SimGraphics simGraphics) {
            simGraphics.drawHollowRect(Color.lightGray);
        }

        public boolean contains(Object object) {
            return this.elements.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this.elements.containsAll(collection);
        }

        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        public Iterator iterator() {
            Iterator iterator = this.elements.iterator();
            return new Iterator(this, iterator){
                private Object o;
                private final /* synthetic */ Iterator val$iter;
                private final /* synthetic */ Abstract2DLocation this$1;
                {
                    this.this$1 = abstract2DLocation;
                    this.val$iter = iterator;
                    this.o = null;
                }

                public boolean hasNext() {
                    return this.val$iter.hasNext();
                }

                public Object next() {
                    this.o = this.val$iter.next();
                    return this.o;
                }

                public void remove() {
                    this.val$iter.remove();
                    if (this.o instanceof Agent) {
                        ((Agent)this.o).setLocation(null);
                    }
                    if (this.this$1.isEmpty()) {
                        Abstract2DLocation.access$000(this.this$1).removeLocation(this.this$1.x, this.this$1.y);
                    }
                }
            };
        }

        public int size() {
            return this.elements.size();
        }

        public Object[] toArray() {
            return this.elements.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.elements.toArray(objectArray);
        }

        static /* synthetic */ AbstractObject2DSpace access$000(Abstract2DLocation abstract2DLocation) {
            return abstract2DLocation.AbstractObject2DSpace.this;
        }
    }
}

