/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.space.d2;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uchicago.src.sim.space.Torus;
import uchicago.src.sim.topology.space.AbstractNeighborhood;
import uchicago.src.sim.topology.space.Agent;
import uchicago.src.sim.topology.space.Location;
import uchicago.src.sim.topology.space.LocationIterator;
import uchicago.src.sim.topology.space.NeighborIterator;
import uchicago.src.sim.topology.space.Neighborhood;
import uchicago.src.sim.topology.space.Space;
import uchicago.src.sim.topology.space.d2.Object2DLocation;
import uchicago.src.sim.topology.space.d2.Object2DSpace;

public class MooreNeighborhood
extends AbstractNeighborhood
implements Neighborhood {
    protected Log log = null;
    protected Object2DSpace space;

    public MooreNeighborhood(String string, Object2DSpace object2DSpace) {
        super(string);
        this.space = object2DSpace;
        this.log = LogFactory.getLog(this.getClass());
    }

    public MooreNeighborhood(Object2DSpace object2DSpace) {
        super("Moore Neighborhood");
        this.space = object2DSpace;
        this.log = LogFactory.getLog(this.getClass());
    }

    protected Space getSpace() {
        return this.space;
    }

    public double distance(Object object, Object object2) {
        double d = Double.NaN;
        Object2DLocation object2DLocation = null;
        Object2DLocation object2DLocation2 = null;
        if (object instanceof Object2DLocation) {
            object2DLocation = (Object2DLocation)object;
        } else if (object instanceof Agent) {
            object2DLocation = (Object2DLocation)((Agent)object).getLocation();
        }
        if (object2 instanceof Object2DLocation) {
            object2DLocation2 = (Object2DLocation)object2;
        } else if (object2 instanceof Agent) {
            object2DLocation2 = (Object2DLocation)((Agent)object2).getLocation();
        }
        if (object2DLocation != null && object2DLocation2 != null) {
            d = Math.min(Math.abs(object2DLocation2.getX() - object2DLocation.getX()), Math.abs(object2DLocation2.getY() - object2DLocation.getY()));
        }
        return d;
    }

    public int getNeighborhoodSize(Location location, int n, boolean bl) {
        return (int)Math.pow(2 * n + 1, 2.0) - (bl ? 0 : 1);
    }

    public boolean isFull(Location location, int n, boolean bl) {
        return false;
    }

    public int getAgentCount(Location location, int n, boolean bl) {
        return 0;
    }

    public NeighborIterator neighborIterator(Location location, int n, boolean bl) {
        return new NeighborIteratorImpl(location, n, bl);
    }

    public LocationIterator locationsIterator(Location location, int n, boolean bl) {
        return new MooreLocationIteratorImpl(location, n, bl);
    }

    public LocationIterator emptyLocationsIterator(Location location, int n, boolean bl) {
        return new AvailableLocationIterator(location, n, bl);
    }

    public LocationIterator occupiedLocationsIterator(Location location, int n, boolean bl) {
        return new OccupiedIterator(location, n, bl);
    }

    private class NeighborIteratorImpl
    implements NeighborIterator {
        protected OccupiedIterator masterIter = null;
        protected Iterator currentIter = null;

        public NeighborIteratorImpl(Location location, int n, boolean bl) {
            this.masterIter = new OccupiedIterator(location, n, bl);
            if (this.masterIter.hasNext()) {
                this.currentIter = ((Object2DLocation)this.masterIter.next()).iterator();
            }
        }

        public boolean hasNext() {
            if (this.currentIter == null) {
                return false;
            }
            while (this.masterIter.hasNext() && !this.currentIter.hasNext()) {
                this.currentIter = ((Object2DLocation)this.masterIter.next()).iterator();
            }
            return this.masterIter.hasNext() && this.currentIter.hasNext();
        }

        public Object next() {
            if (this.hasNext()) {
                return this.currentIter.next();
            }
            return null;
        }

        public void remove() {
            if (this.currentIter != null) {
                this.currentIter.remove();
            }
        }

        public int currentDirection() {
            return this.masterIter.currentDirection;
        }

        public int currentDistance() {
            return this.masterIter.currentDistance;
        }
    }

    private class AvailableLocationIterator
    extends MooreLocationIteratorImpl {
        public AvailableLocationIterator(Location location, int n, boolean bl) {
            super(location, n, bl);
        }

        protected boolean testNext(int n, int n2) {
            return MooreNeighborhood.this.space.getLocation(n, n2).size() == 0;
        }
    }

    private class OccupiedIterator
    extends MooreLocationIteratorImpl {
        public OccupiedIterator(Location location, int n, boolean bl) {
            super(location, n, bl);
        }

        protected boolean testNext(int n, int n2) {
            return MooreNeighborhood.this.space.getLocation(n, n2).size() != 0;
        }
    }

    private class MooreLocationIteratorImpl
    implements LocationIterator {
        protected int currentDirection = 0;
        protected int currentDistance = 0;
        protected Object2DLocation location = null;
        protected Object2DLocation current = null;
        protected int ring = 0;
        protected int extent = 0;
        protected int cursorX = 0;
        protected int cursorY = 0;
        protected int quadrant = 0;
        protected int xMax = 0;
        protected int xMin = 0;
        protected int yMax = 0;
        protected int yMin = 0;

        public MooreLocationIteratorImpl(Location location, int n, boolean bl) {
            this.location = (Object2DLocation)location;
            this.extent = n;
            if (bl) {
                this.ring = 0;
                this.quadrant = -1;
            } else {
                this.ring = 1;
                this.quadrant = 0;
            }
            this.xMax = this.location.getX() + this.ring;
            this.xMin = this.location.getX() - this.ring;
            this.yMax = this.location.getY() + this.ring;
            this.yMin = this.location.getY() - this.ring;
            this.cursorX = this.xMin;
            this.cursorY = this.yMax;
        }

        protected void logState() {
            MooreNeighborhood.this.log.debug((Object)" ");
            MooreNeighborhood.this.log.debug((Object)("ring=" + this.ring));
            MooreNeighborhood.this.log.debug((Object)("extent=" + this.extent));
            MooreNeighborhood.this.log.debug((Object)("cursorX=" + this.cursorX));
            MooreNeighborhood.this.log.debug((Object)("cursorY=" + this.cursorY));
            MooreNeighborhood.this.log.debug((Object)("octant=" + this.quadrant));
            MooreNeighborhood.this.log.debug((Object)" ");
        }

        protected boolean testNext(int n, int n2) {
            return true;
        }

        public boolean hasNext() {
            while (this.ring <= this.extent) {
                if (!(MooreNeighborhood.this.space instanceof Torus)) {
                    if (this.cursorX >= 0 && this.cursorX < MooreNeighborhood.this.space.getSizeX() && this.cursorY >= 0 && this.cursorY < MooreNeighborhood.this.space.getSizeY()) {
                        if (this.testNext(MooreNeighborhood.this.space.xnorm(this.cursorX), MooreNeighborhood.this.space.ynorm(this.cursorY))) break;
                        this.incrementCursor();
                        continue;
                    }
                    this.incrementCursor();
                    continue;
                }
                if (this.testNext(MooreNeighborhood.this.space.xnorm(this.cursorX), MooreNeighborhood.this.space.ynorm(this.cursorY))) break;
                this.incrementCursor();
            }
            return this.ring <= this.extent;
        }

        private void incrementCursor() {
            switch (this.quadrant) {
                case 0: {
                    if (this.cursorX < this.xMax) {
                        ++this.cursorX;
                    }
                    if (this.cursorX != this.xMax) break;
                    this.quadrant = 1;
                    break;
                }
                case 1: {
                    if (this.cursorY > this.yMin) {
                        --this.cursorY;
                    }
                    if (this.cursorY != this.yMin) break;
                    this.quadrant = 2;
                    break;
                }
                case 2: {
                    if (this.cursorX > this.xMin) {
                        --this.cursorX;
                    }
                    if (this.cursorX != this.xMin) break;
                    this.quadrant = 3;
                    break;
                }
                case 3: {
                    if (this.cursorY < this.yMax) {
                        ++this.cursorY;
                    }
                    if (this.cursorY != this.yMax) break;
                    ++this.ring;
                    this.quadrant = 0;
                    this.xMax = this.location.getX() + this.ring;
                    this.xMin = this.location.getX() - this.ring;
                    this.yMax = this.location.getY() + this.ring;
                    this.yMin = this.location.getY() - this.ring;
                    this.cursorX = this.xMin;
                    this.cursorY = this.yMax;
                    break;
                }
                default: {
                    ++this.ring;
                    this.quadrant = 0;
                    this.xMax = this.location.getX() + this.ring;
                    this.xMin = this.location.getX() - this.ring;
                    this.yMax = this.location.getY() + this.ring;
                    this.yMin = this.location.getY() - this.ring;
                    this.cursorX = this.xMin;
                    this.cursorY = this.yMax;
                }
            }
        }

        public Object next() {
            return this.nextLocation();
        }

        public Location nextLocation() {
            try {
                if (this.ring <= this.extent) {
                    this.current = (Object2DLocation)MooreNeighborhood.this.space.getLocation(MooreNeighborhood.this.space.xnorm(this.cursorX), MooreNeighborhood.this.space.ynorm(this.cursorY));
                    this.currentDirection = this.quadrant;
                    this.currentDistance = this.ring;
                    this.logState();
                    this.incrementCursor();
                    return this.current;
                }
                return null;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            this.current.clear();
        }

        public int currentDirection() {
            return this.currentDirection;
        }

        public int currentDistance() {
            return this.currentDistance;
        }
    }
}

