/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.space.d2;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import uchicago.src.collection.NewMatrix;
import uchicago.src.sim.topology.space.Location;
import uchicago.src.sim.topology.space.d2.AbstractObject2DSpace;
import uchicago.src.sim.topology.space.d2.Object2DLocation;
import uchicago.src.sim.topology.space.d2.Object2DSpace;
import uchicago.src.sim.util.SimUtilities;

public class Object2DGrid
extends AbstractObject2DSpace
implements Object2DSpace {
    public static final int PGM_ASCII = 0;

    public Object2DGrid(int n, int n2) {
        this("Object2DGrid", n, n2);
    }

    public Object2DGrid(String string, int n, int n2) {
        super(string);
        this.matrix = new NewMatrix(n, n2);
    }

    public Object2DGrid(InputStream inputStream) {
        this("Object2DGrid", inputStream);
    }

    public Object2DGrid(String string, InputStream inputStream) {
        super(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.init(bufferedReader);
    }

    public Object2DGrid(String string, String string2) {
        super(string);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
            this.init(bufferedReader);
        }
        catch (IOException iOException) {
            SimUtilities.showError("Error Reading image file", iOException);
            iOException.printStackTrace();
        }
    }

    public Object2DGrid(String string) {
        this("Object2DGrid", string);
    }

    public Location getLocation(int n, int n2) {
        Location location = (Location)this.getMatrix().get(this.xnorm(n), this.ynorm(n2));
        if (location == null) {
            location = new Object2DLocationImpl(this.xnorm(n), this.ynorm(n2));
        }
        return location;
    }

    protected void init(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            if (!string.equals("P2")) {
                throw new UnsupportedEncodingException("File is not in PGM ascii format");
            }
            string = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = Integer.valueOf(stringTokenizer.nextToken());
            int n2 = Integer.valueOf(stringTokenizer.nextToken());
            stringTokenizer = null;
            bufferedReader.readLine();
            string = "";
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                string = string + string2 + " ";
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            stringTokenizer = new StringTokenizer(string);
            this.matrix = new NewMatrix(n, n2);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.getLocation(i, j).add(Double.valueOf(stringTokenizer.nextToken()));
                }
            }
        }
        catch (IOException iOException) {
            SimUtilities.showError("Error Reading image file", iOException);
            iOException.printStackTrace();
            System.exit(0);
        }
    }

    public class Object2DLocationImpl
    extends AbstractObject2DSpace.Abstract2DLocation
    implements Object2DLocation {
        protected Object2DLocationImpl(int n, int n2) {
            super(n, n2);
            this.capacity = 1;
            this.elements = new ArrayList();
        }
    }
}

