/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.space.d3;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uchicago.src.sim.space.Torus;
import uchicago.src.sim.topology.space.AbstractNeighborhood;
import uchicago.src.sim.topology.space.Agent;
import uchicago.src.sim.topology.space.Location;
import uchicago.src.sim.topology.space.LocationIterator;
import uchicago.src.sim.topology.space.NeighborIterator;
import uchicago.src.sim.topology.space.Neighborhood;
import uchicago.src.sim.topology.space.Space;
import uchicago.src.sim.topology.space.d3.Object3DLocation;
import uchicago.src.sim.topology.space.d3.Object3DSpace;

public class Moore3DNeighborhood
extends AbstractNeighborhood
implements Neighborhood {
    protected Object3DSpace space;
    protected Log log = LogFactory.getLog(this.getClass());

    public Moore3DNeighborhood(String string, Object3DSpace object3DSpace) {
        super(string);
        this.space = object3DSpace;
    }

    public Moore3DNeighborhood(Object3DSpace object3DSpace) {
        super("Moore Neighborhood");
    }

    protected Space getSpace() {
        return this.space;
    }

    public double distance(Object object, Object object2) {
        double d = Double.NaN;
        Object3DLocation object3DLocation = null;
        Object3DLocation object3DLocation2 = null;
        if (object instanceof Object3DLocation) {
            object3DLocation = (Object3DLocation)object;
        } else if (object instanceof Agent) {
            object3DLocation = (Object3DLocation)((Agent)object).getLocation();
        }
        if (object2 instanceof Object3DLocation) {
            object3DLocation2 = (Object3DLocation)object2;
        } else if (object2 instanceof Agent) {
            object3DLocation2 = (Object3DLocation)((Agent)object2).getLocation();
        }
        if (object3DLocation != null && object3DLocation2 != null) {
            d = Math.min(Math.abs(object3DLocation2.getX() - object3DLocation.getX()), Math.abs(object3DLocation2.getY() - object3DLocation.getY()));
        }
        return d;
    }

    public int getNeighborhoodSize(Location location, int n, boolean bl) {
        return (int)Math.pow(2 * n + 1, 2.0) - (bl ? 0 : 1);
    }

    public boolean isFull(Location location, int n, boolean bl) {
        return false;
    }

    public int getAgentCount(Location location, int n, boolean bl) {
        return 0;
    }

    public NeighborIterator neighborIterator(Location location, int n, boolean bl) {
        return new NeighborIteratorImpl(location, n, bl);
    }

    public LocationIterator locationsIterator(Location location, int n, boolean bl) {
        return new MooreLocationIteratorImpl(location, n, bl);
    }

    public LocationIterator emptyLocationsIterator(Location location, int n, boolean bl) {
        return new AvailableLocationIterator(location, n, bl);
    }

    public LocationIterator occupiedLocationsIterator(Location location, int n, boolean bl) {
        return new OccupiedIterator(location, n, bl);
    }

    private class NeighborIteratorImpl
    implements NeighborIterator {
        protected OccupiedIterator masterIter = null;
        protected Iterator currentIter = null;

        public NeighborIteratorImpl(Location location, int n, boolean bl) {
            this.masterIter = new OccupiedIterator(location, n, bl);
            if (this.masterIter.hasNext()) {
                this.currentIter = ((Object3DLocation)this.masterIter.next()).iterator();
            }
        }

        public boolean hasNext() {
            if (this.currentIter == null) {
                return false;
            }
            while (this.masterIter.hasNext() && !this.currentIter.hasNext()) {
                this.currentIter = ((Object3DLocation)this.masterIter.next()).iterator();
            }
            return this.masterIter.hasNext() && this.currentIter.hasNext();
        }

        public Object next() {
            if (this.hasNext()) {
                return this.currentIter.next();
            }
            return null;
        }

        public void remove() {
            if (this.currentIter != null) {
                this.currentIter.remove();
            }
        }

        public int currentDirection() {
            return this.masterIter.currentDirection;
        }

        public int currentDistance() {
            return this.masterIter.currentDistance;
        }
    }

    private class AvailableLocationIterator
    extends MooreLocationIteratorImpl {
        public AvailableLocationIterator(Location location, int n, boolean bl) {
            super(location, n, bl);
        }

        protected boolean testNext(int n, int n2, int n3) {
            return Moore3DNeighborhood.this.space.getLocation(n, n2, n3).size() == 0;
        }
    }

    private class OccupiedIterator
    extends MooreLocationIteratorImpl {
        public OccupiedIterator(Location location, int n, boolean bl) {
            super(location, n, bl);
        }

        protected boolean testNext(int n, int n2, int n3) {
            return Moore3DNeighborhood.this.space.getLocation(n, n2, n3).size() != 0;
        }
    }

    private class MooreLocationIteratorImpl
    implements LocationIterator {
        protected int currentDirection = 0;
        protected int currentDistance = 0;
        protected Object3DLocation location = null;
        protected Object3DLocation current = null;
        protected int ring = 0;
        protected int extent = 0;
        protected int cursorX = 0;
        protected int cursorY = 0;
        protected int cursorZ = 0;
        protected int zone = -1;
        protected int xMax = 0;
        protected int xMin = 0;
        protected int yMax = 0;
        protected int yMin = 0;
        protected int zMax = 0;
        protected int zMin = 0;
        protected boolean includeOrigin = false;

        public MooreLocationIteratorImpl(Location location, int n, boolean bl) {
            this.location = (Object3DLocation)location;
            this.extent = n;
            this.includeOrigin = bl;
            if (this.includeOrigin) {
                this.ring = 0;
                this.zone = -1;
            } else {
                this.ring = 1;
                this.zone = 0;
            }
            this.xMax = this.location.getX() + this.ring;
            this.xMin = this.location.getX() - this.ring;
            this.yMax = this.location.getY() + this.ring;
            this.yMin = this.location.getY() - this.ring;
            this.zMax = this.location.getZ() + this.ring;
            this.zMin = this.location.getZ() - this.ring;
            this.cursorX = this.xMin;
            this.cursorY = this.yMax;
            this.cursorZ = this.zMin;
        }

        protected void logState() {
            Moore3DNeighborhood.this.log.debug((Object)" ");
            Moore3DNeighborhood.this.log.debug((Object)("ring=" + this.ring));
            Moore3DNeighborhood.this.log.debug((Object)("extent=" + this.extent));
            Moore3DNeighborhood.this.log.debug((Object)("cursorX=" + this.cursorX));
            Moore3DNeighborhood.this.log.debug((Object)("cursorY=" + this.cursorY));
            Moore3DNeighborhood.this.log.debug((Object)("cursorZ=" + this.cursorZ));
            Moore3DNeighborhood.this.log.debug((Object)("octant=" + this.zone));
            Moore3DNeighborhood.this.log.debug((Object)" ");
        }

        protected boolean testNext(int n, int n2, int n3) {
            return true;
        }

        public boolean hasNext() {
            while (this.ring <= this.extent) {
                if (!(Moore3DNeighborhood.this.space instanceof Torus)) {
                    if (this.cursorX >= 0 && this.cursorX < Moore3DNeighborhood.this.space.getSizeX() && this.cursorY >= 0 && this.cursorY < Moore3DNeighborhood.this.space.getSizeY() && this.cursorZ >= 0 && this.cursorZ < Moore3DNeighborhood.this.space.getSizeZ()) {
                        if (this.testNext(Moore3DNeighborhood.this.space.xnorm(this.cursorX), Moore3DNeighborhood.this.space.ynorm(this.cursorY), Moore3DNeighborhood.this.space.znorm(this.cursorZ))) break;
                        this.incrementCursor();
                        continue;
                    }
                    this.incrementCursor();
                    continue;
                }
                if (this.testNext(Moore3DNeighborhood.this.space.xnorm(this.cursorX), Moore3DNeighborhood.this.space.ynorm(this.cursorY), Moore3DNeighborhood.this.space.znorm(this.cursorZ))) break;
                this.incrementCursor();
            }
            return this.ring <= this.extent;
        }

        private void incrementCursor() {
            switch (this.zone) {
                case 0: {
                    if (this.cursorX < this.xMax) {
                        ++this.cursorX;
                    }
                    if (this.cursorX != this.xMax) break;
                    this.zone = 1;
                    break;
                }
                case 1: {
                    if (this.cursorY > this.yMin) {
                        --this.cursorY;
                    }
                    if (this.cursorY != this.yMin) break;
                    this.zone = 2;
                    break;
                }
                case 2: {
                    if (this.cursorX > this.xMin) {
                        --this.cursorX;
                    }
                    if (this.cursorX != this.xMin) break;
                    this.zone = 3;
                    break;
                }
                case 3: {
                    if (this.cursorY < this.yMax) {
                        ++this.cursorY;
                    }
                    if (this.cursorY != this.yMax) break;
                    this.zone = 0;
                    if (this.cursorZ == this.zMax) {
                        ++this.ring;
                        this.xMax = this.location.getX() + this.ring;
                        this.xMin = this.location.getX() - this.ring;
                        this.yMax = this.location.getY() + this.ring;
                        this.yMin = this.location.getY() - this.ring;
                        this.zMax = this.location.getZ() + this.ring;
                        this.zMin = this.location.getZ() - this.ring;
                        this.cursorX = this.xMin;
                        this.cursorY = this.yMax;
                        this.cursorZ = this.zMin;
                        break;
                    }
                    ++this.cursorZ;
                    break;
                }
                default: {
                    ++this.ring;
                    this.zone = 0;
                    this.xMax = this.location.getX() + this.ring;
                    this.xMin = this.location.getX() - this.ring;
                    this.yMax = this.location.getY() + this.ring;
                    this.yMin = this.location.getY() - this.ring;
                    this.zMax = this.location.getZ() + this.ring;
                    this.zMin = this.location.getZ() - this.ring;
                    this.cursorX = this.xMin;
                    this.cursorY = this.yMax;
                    this.cursorZ = this.zMax;
                }
            }
        }

        public Object next() {
            return this.nextLocation();
        }

        public Location nextLocation() {
            try {
                if (this.ring <= this.extent) {
                    this.current = (Object3DLocation)Moore3DNeighborhood.this.space.getLocation(Moore3DNeighborhood.this.space.xnorm(this.cursorX), Moore3DNeighborhood.this.space.ynorm(this.cursorY), Moore3DNeighborhood.this.space.znorm(this.cursorZ));
                    this.currentDirection = this.zone;
                    this.currentDistance = this.ring;
                    this.logState();
                    this.incrementCursor();
                    return this.current;
                }
                return null;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            this.current.clear();
        }

        public int currentDirection() {
            return this.currentDirection;
        }

        public int currentDistance() {
            return this.currentDistance;
        }
    }
}

