/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.space2;

import java.util.List;
import java.util.Vector;
import uchicago.src.sim.space.Torus;
import uchicago.src.sim.topology.space2.AbstractDiscrete2DTopology;
import uchicago.src.sim.topology.space2.Discrete2DSpace;
import uchicago.src.sim.topology.space2.Location;

public class MooreTopology
extends AbstractDiscrete2DTopology {
    public static String type = "MOORE";

    public MooreTopology(Discrete2DSpace discrete2DSpace) {
        super(discrete2DSpace);
        this.torus = discrete2DSpace instanceof Torus;
    }

    public List getRelations(int n, int n2, int[] nArray, boolean bl) {
        if (nArray.length != 2) {
            throw new IllegalArgumentException("Moore neighborhoods require an extents array of 2 integers");
        }
        int n3 = nArray[0];
        int n4 = nArray[1];
        Vector<Object> vector = new Vector<Object>(n3 * n4 * 4 + n3 * 2 + n4 * 2);
        int n5 = n3;
        int n6 = n3;
        if (!this.torus) {
            if (n + n6 > this.space.getSizeX() - 1) {
                n6 = this.space.getSizeX() - 1 - n;
            }
            if (n - n5 < 0) {
                n5 = n;
            }
        }
        int n7 = n4;
        int n8 = n4;
        if (!this.torus) {
            if (n2 + n8 > this.space.getSizeY() - 1) {
                n8 = this.space.getSizeY() - 1 - n2;
            }
            if (n2 - n7 < 0) {
                n7 = n2;
            }
        }
        for (int i = n2 - n7; i <= n2 + n8; ++i) {
            for (int j = n - n5; j <= n + n6; ++j) {
                if (i == n2 && j == n) continue;
                Object object = this.space.getObjectAt(j, i);
                if (bl) {
                    vector.add(object);
                    continue;
                }
                if (object == null) continue;
                vector.add(object);
            }
        }
        return vector;
    }

    public List getRelations(Object object) {
        Location location = this.space.getLocation(object);
        return this.getRelations(location.getX(), location.getY(), new int[]{1, 1}, false);
    }

    public String getRelationType() {
        return type;
    }

    public void setRelationType(String string) {
        type = string;
    }

    public List getRelations(Object object, double d) {
        Location location = this.space.getLocation(object);
        return this.getRelations(location.getX(), location.getY(), new int[]{(int)d, (int)d}, false);
    }

    public double distance(Object object, Object object2) {
        Location location = this.space.getLocation(object);
        Location location2 = this.space.getLocation(object2);
        int n = location.getX();
        int n2 = location2.getX();
        int n3 = location.getY();
        int n4 = location2.getY();
        return this.lineBresenham(n, n3, n2, n4);
    }

    private int lineBresenham(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = 0;
        int n8 = n4 - n2;
        int n9 = n3 - n;
        if (n8 < 0) {
            n8 = -n8;
            n6 = -1;
        } else {
            n6 = 1;
        }
        if (n9 < 0) {
            n9 = -n9;
            n5 = -1;
        } else {
            n5 = 1;
        }
        if ((n9 <<= 1) > (n8 <<= 1)) {
            int n10 = n8 - (n9 >> 1);
            while (n != n3) {
                if (n10 >= 0) {
                    n2 += n6;
                    n10 -= n9;
                }
                n += n5;
                n10 += n8;
                ++n7;
            }
        } else {
            int n11 = n9 - (n8 >> 1);
            while (n2 != n4) {
                if (n11 >= 0) {
                    n += n5;
                    n11 -= n8;
                }
                n2 += n6;
                n11 += n9;
                ++n7;
            }
        }
        return n7;
    }
}

