/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.space2;

import java.util.ArrayList;
import java.util.List;
import uchicago.src.sim.topology.ModifyableTopology;
import uchicago.src.sim.topology.space2.Discrete2DSpace;
import uchicago.src.sim.topology.space2.Location;
import uchicago.src.sim.util.Random;

public class OccupationTopology
implements ModifyableTopology {
    private Discrete2DSpace space;
    public static String type = "OCCUPATION";

    public OccupationTopology(Discrete2DSpace discrete2DSpace) {
        this.space = discrete2DSpace;
    }

    public void addRelation(Object object, Object object2, double d) {
        Location location = null;
        if (object2 instanceof Location) {
            location = (Location)object2;
            this.space.putObjectAt(location.getX(), location.getY(), object);
        } else if (object instanceof Location) {
            location = (Location)object;
            this.space.putObjectAt(location.getX(), location.getY(), object2);
        } else {
            throw new IllegalArgumentException("OccupationTopology requires a Location Object");
        }
    }

    public void removeRelation(Object object, Object object2) {
        Location location = null;
        if (object2 instanceof Location) {
            location = (Location)object2;
            this.space.putObjectAt(location.getX(), location.getY(), null);
        } else if (object instanceof Location) {
            location = (Location)object;
            this.space.putObjectAt(location.getX(), location.getY(), null);
        } else {
            throw new IllegalArgumentException("OccupationTopology requires a Location Object");
        }
    }

    public boolean insertElement(Object object) {
        int n = 0;
        int n2 = Random.uniform.nextIntFromTo(0, this.space.getSizeX() - 1);
        int n3 = Random.uniform.nextIntFromTo(0, this.space.getSizeY() - 1);
        while (this.space.getObjectAt(n2, n3) != null) {
            n2 = Random.uniform.nextIntFromTo(0, this.space.getSizeX() - 1);
            n3 = Random.uniform.nextIntFromTo(0, this.space.getSizeY() - 1);
            if (n < 50) continue;
            return false;
        }
        this.space.putObjectAt(n2, n3, object);
        return true;
    }

    public boolean removeElement(Object object) {
        Location location = this.space.getLocation(object);
        if (location == null) {
            return false;
        }
        this.space.putObjectAt(location.getX(), location.getY(), null);
        return true;
    }

    public List getRelations(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!(object instanceof Location)) {
            arrayList.add(this.space.getLocation(object));
            return arrayList;
        }
        Location location = (Location)object;
        arrayList.add(this.space.getObjectAt(location.getX(), location.getY()));
        return arrayList;
    }

    public List getRelations(Object object, double d) {
        return this.getRelations(object);
    }

    public String getRelationType() {
        return type;
    }

    public double distance(Object object, Object object2) {
        if (this.space.getLocation(object).equals(object2) || this.space.getLocation(object2).equals(object)) {
            return 1.0;
        }
        return -1.0;
    }

    public void setRelationType(String string) {
        type = string;
    }
}

