/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.topology.space2;

import java.util.List;
import java.util.Vector;
import uchicago.src.sim.space.Torus;
import uchicago.src.sim.topology.space2.AbstractDiscrete2DTopology;
import uchicago.src.sim.topology.space2.Discrete2DSpace;
import uchicago.src.sim.topology.space2.Location;

public class VonNeumannTopology
extends AbstractDiscrete2DTopology {
    public static String type = "VON_NEUMANN";

    public VonNeumannTopology(Discrete2DSpace discrete2DSpace) {
        super(discrete2DSpace);
        this.torus = discrete2DSpace instanceof Torus;
    }

    public List getRelations(int n, int n2, int[] nArray, boolean bl) {
        Object object;
        int n3;
        Object object2;
        int n4;
        if (nArray.length != 2) {
            throw new IllegalArgumentException("Von Neumann neighborhoods require an extents array of 2 integers");
        }
        int n5 = nArray[0];
        int n6 = nArray[1];
        Vector<Object> vector = new Vector<Object>(n5 * 2 + n6 * 2);
        int n7 = n5;
        int n8 = n5;
        if (!this.torus) {
            if (n - n7 < 0) {
                n7 = n;
            }
            if (n + n8 > this.space.getSizeX() - 1) {
                n8 = this.space.getSizeX() - 1 - n;
            }
        }
        for (n4 = n - n7; n4 < n; ++n4) {
            object2 = this.space.getObjectAt(n4, n2);
            if (bl) {
                vector.add(object2);
                continue;
            }
            if (object2 == null) continue;
            vector.add(object2);
        }
        for (n4 = n + n8; n4 > n; --n4) {
            object2 = this.space.getObjectAt(n4, n2);
            if (bl) {
                vector.add(object2);
                continue;
            }
            if (object2 == null) continue;
            vector.add(object2);
        }
        n4 = n6;
        int n9 = n6;
        if (!this.torus) {
            if (n2 + n9 > this.space.getSizeY() - 1) {
                n9 = this.space.getSizeY() - 1 - n2;
            }
            if (n2 - n4 < 0) {
                n4 = n2;
            }
        }
        for (n3 = n2 - n4; n3 < n2; ++n3) {
            object = this.space.getObjectAt(n, n3);
            if (bl) {
                vector.add(object);
                continue;
            }
            if (object == null) continue;
            vector.add(object);
        }
        for (n3 = n2 + n9; n3 > n2; --n3) {
            object = this.space.getObjectAt(n, n3);
            if (bl) {
                vector.add(object);
                continue;
            }
            if (object == null) continue;
            vector.add(object);
        }
        return vector;
    }

    public List getRelations(Object object) {
        Location location = null;
        location = !(object instanceof Location) ? this.space.getLocation(object) : (Location)object;
        return this.getRelations(location.getX(), location.getY(), new int[]{1, 1}, false);
    }

    public List getRelations(Object object, double d) {
        Location location = this.space.getLocation(object);
        return this.getRelations(location.getX(), location.getY(), new int[]{(int)d, (int)d}, false);
    }

    public String getRelationType() {
        return type;
    }

    public double distance(Object object, Object object2) {
        Location location = this.space.getLocation(object);
        Location location2 = this.space.getLocation(object2);
        int n = Math.abs(location.getX() - location2.getX());
        int n2 = Math.abs(location.getY() - location2.getY());
        return n + n2;
    }

    public void setRelationType(String string) {
        type = string;
    }
}

