/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import uchicago.src.reflector.IntrospectFrame;
import uchicago.src.reflector.IntrospectPanel;
import uchicago.src.sim.engine.CustomProbeable;
import uchicago.src.sim.gui.Named;
import uchicago.src.sim.util.IntroFrameAdapter;
import uchicago.src.sim.util.ProbeListener;
import uchicago.src.sim.util.SimUtilities;

public class ProbeUtilities {
    private static HashMap probePanelMap = new HashMap();
    private static IntrospectPanel modelPanel;
    private static ArrayList probedList;
    private static ArrayList listeners;

    public static void probe(final Object object) {
        IntrospectFrame introspectFrame;
        Object object2;
        String string = "";
        if (object instanceof Named) {
            object2 = (Named)object;
            string = object2.getName();
        }
        if (object instanceof CustomProbeable) {
            object2 = (CustomProbeable)object;
            introspectFrame = new IntrospectFrame(object, string, object2.getProbedProperties());
        } else {
            introspectFrame = new IntrospectFrame(object, string);
        }
        introspectFrame.addWindowListener(new IntroFrameAdapter(object, listeners));
        object2 = new Runnable(){

            public void run() {
                try {
                    ProbeUtilities.addProbePanel(object, introspectFrame.display());
                }
                catch (Exception exception) {
                    SimUtilities.showError("Probing error", exception);
                    exception.printStackTrace();
                    System.exit(0);
                }
            }
        };
        SwingUtilities.invokeLater((Runnable)object2);
    }

    public static List getProbedObjects() {
        return Collections.unmodifiableList(probedList);
    }

    public static void addModelProbePanel(IntrospectPanel introspectPanel) {
        modelPanel = introspectPanel;
    }

    public static void removeModelProbePanel() {
        modelPanel = null;
    }

    public static void updateModelProbePanel() {
        if (modelPanel == null) {
            throw new RuntimeException("ModelPanel is null");
        }
        modelPanel.reset();
    }

    public static void addProbePanel(Object object, IntrospectPanel introspectPanel) {
        probedList.add(object);
        probePanelMap.put(object, introspectPanel);
    }

    public static void removeProbePanel(Object object) {
        probedList.remove(object);
        probePanelMap.remove(object);
    }

    public static void clearProbePanels() {
        modelPanel = null;
        probedList.clear();
        probePanelMap.clear();
        listeners.clear();
    }

    public static void updateProbePanel(Object object) {
        IntrospectPanel introspectPanel = (IntrospectPanel)probePanelMap.get(object);
        if (introspectPanel != null) {
            introspectPanel.reset();
        }
    }

    public static void updateProbePanels() {
        Iterator iterator = probePanelMap.values().iterator();
        while (iterator.hasNext()) {
            IntrospectPanel introspectPanel = (IntrospectPanel)iterator.next();
            introspectPanel.reset();
        }
    }

    public static void addProbeListener(ProbeListener probeListener) {
        listeners.add(probeListener);
    }

    static {
        probedList = new ArrayList();
        listeners = new ArrayList();
    }
}

