/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.util;

import cern.jet.random.Beta;
import cern.jet.random.Binomial;
import cern.jet.random.BreitWigner;
import cern.jet.random.BreitWignerMeanSquare;
import cern.jet.random.ChiSquare;
import cern.jet.random.Distributions;
import cern.jet.random.Empirical;
import cern.jet.random.EmpiricalWalker;
import cern.jet.random.Exponential;
import cern.jet.random.ExponentialPower;
import cern.jet.random.Gamma;
import cern.jet.random.HyperGeometric;
import cern.jet.random.Hyperbolic;
import cern.jet.random.Logarithmic;
import cern.jet.random.NegativeBinomial;
import cern.jet.random.Normal;
import cern.jet.random.Poisson;
import cern.jet.random.PoissonSlow;
import cern.jet.random.StudentT;
import cern.jet.random.Uniform;
import cern.jet.random.VonMises;
import cern.jet.random.Zeta;
import cern.jet.random.engine.MersenneTwister;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import java.util.Date;
import uchicago.src.sim.stats.Pareto;

public class Random {
    public static final int LINEAR_INTERPOLATION = 0;
    public static final int NO_INTERPOLATIONN = 1;
    private static long rngSeed;
    private static RandomElement generator;
    public static Beta beta;
    public static Binomial binomial;
    public static BreitWigner breitWigner;
    public static BreitWignerMeanSquare breitWignerMeanSquare;
    public static ChiSquare chiSquare;
    public static Empirical empirical;
    public static EmpiricalWalker empiricalWalker;
    public static Exponential exponential;
    public static ExponentialPower exponentialPower;
    public static Gamma gamma;
    public static Hyperbolic hyperbolic;
    public static HyperGeometric hyperGeometric;
    public static Logarithmic logarithmic;
    public static NegativeBinomial negativeBinomial;
    public static Normal normal;
    public static Pareto pareto;
    public static Poisson poisson;
    public static PoissonSlow poissonSlow;
    public static StudentT studentT;
    public static Uniform uniform;
    public static VonMises vonMises;
    public static Zeta zeta;

    public static double geometricPdf(int n, double d) {
        return Distributions.geometricPdf(n, d);
    }

    public static double nextBurr1(double d, int n) {
        return Distributions.nextBurr1(d, n, generator);
    }

    public static double nextBurr2(double d, double d2, int n) {
        return Distributions.nextBurr2(d, d2, n, generator);
    }

    public static double nextCauchy() {
        return Distributions.nextCauchy(generator);
    }

    public static double nextErlang(double d, double d2) {
        return Distributions.nextErlang(d, d2, generator);
    }

    public static int nextGeometric(double d) {
        return Distributions.nextGeometric(d, generator);
    }

    public static double nextLambda(double d, double d2) {
        return Distributions.nextLambda(d, d2, generator);
    }

    public static double nextLaplace() {
        return Distributions.nextLaplace(generator);
    }

    public static double nextLogistic() {
        return Distributions.nextLogistic(generator);
    }

    public static double nextPowLaw(double d, double d2) {
        return Distributions.nextPowLaw(d, d2, generator);
    }

    public static double nextTriangular() {
        return Distributions.nextTriangular(generator);
    }

    public static double nextWeibull(double d, double d2) {
        return Distributions.nextWeibull(d, d2, generator);
    }

    public static int nextZipfInt(double d) {
        return Distributions.nextZipfInt(d, generator);
    }

    public static void createZeta(double d, double d2) {
        zeta = new Zeta(d, d2, generator);
    }

    public static void createVonMises(double d) {
        vonMises = new VonMises(d, generator);
    }

    public static void createPareto(double d, double d2) {
        pareto = new Pareto(d, d2, generator);
    }

    public static void createUniform(double d, double d2) {
        uniform = new Uniform(d, d2, generator);
    }

    public static void createUniform() {
        uniform = new Uniform(generator);
    }

    public static void createStudentT(double d) {
        studentT = new StudentT(d, generator);
    }

    public static void createPoissonSlow(double d) {
        poissonSlow = new PoissonSlow(d, generator);
    }

    public static void createPoisson(double d) {
        poisson = new Poisson(d, generator);
    }

    public static void createNormal(double d, double d2) {
        normal = new Normal(d, d2, generator);
    }

    public static void createNegativeBinomial(int n, double d) {
        negativeBinomial = new NegativeBinomial(n, d, generator);
    }

    public static void createLogarithmic(double d) {
        logarithmic = new Logarithmic(d, generator);
    }

    public static void createHyperGeometric(int n, int n2, int n3) {
        hyperGeometric = new HyperGeometric(n, n2, n3, generator);
    }

    public static void createHyperbolic(double d, double d2) {
        hyperbolic = new Hyperbolic(d, d2, generator);
    }

    public static void createGamma(double d, double d2) {
        gamma = new Gamma(d, d2, generator);
    }

    public static void createExponentialPower(double d) {
        exponentialPower = new ExponentialPower(d, generator);
    }

    public static void createExponential(double d) {
        exponential = new Exponential(d, generator);
    }

    public static void createEmpiricalWalker(double[] dArray, int n) {
        empiricalWalker = new EmpiricalWalker(dArray, n, generator);
    }

    public static void createEmpirical(double[] dArray, int n) {
        empirical = new Empirical(dArray, n, generator);
    }

    public static void createChiSquare(double d) {
        chiSquare = new ChiSquare(d, generator);
    }

    public static void createBreitWignerMeanSquareState(double d, double d2, double d3) {
        breitWignerMeanSquare = new BreitWignerMeanSquare(d, d2, d3, generator);
    }

    public static void createBreitWigner(double d, double d2, double d3) {
        breitWigner = new BreitWigner(d, d2, d3, generator);
    }

    public static void createBinomial(int n, double d) {
        binomial = new Binomial(n, d, generator);
    }

    public static void createBeta(double d, double d2) {
        beta = new Beta(d, d2, generator);
    }

    public static RandomElement generateNewSeed() {
        Date date = new Date();
        rngSeed = date.getTime();
        generator = new MersenneTwister(date);
        Random.invalidateDists();
        return generator;
    }

    public static RandomElement getGenerator() {
        return generator;
    }

    public static RandomElement getGenerator(long l) {
        rngSeed = l;
        generator = new MersenneTwister((int)l);
        Random.invalidateDists();
        return generator;
    }

    public static void setSeed(long l) {
        Random.getGenerator(l);
    }

    private static void invalidateDists() {
        beta = null;
        binomial = null;
        breitWigner = null;
        breitWignerMeanSquare = null;
        chiSquare = null;
        empirical = null;
        empiricalWalker = null;
        exponential = null;
        exponentialPower = null;
        gamma = null;
        hyperbolic = null;
        hyperGeometric = null;
        logarithmic = null;
        negativeBinomial = null;
        normal = null;
        poisson = null;
        poissonSlow = null;
        studentT = null;
        uniform = null;
        vonMises = null;
        zeta = null;
    }

    public static long getSeed() {
        return rngSeed;
    }

    static {
        Date date = new Date();
        rngSeed = date.getTime();
        generator = new MersenneTwister(date);
    }
}

