/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.util;

import cern.jet.random.Uniform;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import uchicago.src.sim.util.Random;

public class SimUtilities {
    private static double[] sinArray = new double[360];
    private static double[] cosArray = new double[360];

    private SimUtilities() {
    }

    public static void shuffle(List list) {
        if (Random.uniform == null) {
            Random.createUniform();
        }
        for (int i = list.size(); i > 1; --i) {
            SimUtilities.swap(list, i - 1, Random.uniform.nextIntFromTo(0, i - 1));
        }
    }

    public static void shuffle(List list, Uniform uniform) {
        for (int i = list.size(); i > 1; --i) {
            SimUtilities.swap(list, i - 1, uniform.nextIntFromTo(0, i - 1));
        }
    }

    public static void shuffle(double[] dArray, Uniform uniform) {
        for (int i = dArray.length; i > 1; --i) {
            SimUtilities.swap(dArray, i - 1, uniform.nextIntFromTo(0, i - 1));
        }
    }

    private static void swap(List list, int n, int n2) {
        Object e = list.get(n);
        list.set(n, list.get(n2));
        list.set(n2, e);
    }

    private static void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    public static double[] getPointFromHeadingAndDistance(int n, int n2) {
        double d = sinArray[n] * (double)n2;
        double d2 = cosArray[n] * (double)n2;
        double[] dArray = new double[]{d2, d};
        return dArray;
    }

    public static int norm(int n, int n2) {
        if (n < 0 || n > n2 - 1) {
            while (n < 0) {
                n += n2;
            }
            return n % n2;
        }
        return n;
    }

    public static void showMessage(String string) {
        try {
            JFrame jFrame = new JFrame();
            JOptionPane.showMessageDialog(jFrame, string, "Repast Message", 1);
            jFrame.dispose();
        }
        catch (InternalError internalError) {
            System.out.println("Repast Message: " + string);
        }
    }

    public static void showError(String string, Exception exception) {
        SimUtilities.logException(string, exception);
        try {
            JFrame jFrame = new JFrame();
            String string2 = string + "\nSee repast.log for details";
            JOptionPane.showMessageDialog(jFrame, string2, "Repast Error", 0);
            jFrame.dispose();
        }
        catch (InternalError internalError) {
            System.out.println("Repast Error: see ./repast.log for details");
        }
        System.out.println(string);
        exception.printStackTrace();
    }

    public static void logException(String string, Exception exception) {
        PrintWriter printWriter = null;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("./repast.log"));
            printWriter = new PrintWriter(bufferedWriter);
            printWriter.println(string);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            if (printWriter.checkError()) {
                printWriter.flush();
                printWriter.close();
                System.err.println("Error while writing error log");
            }
        }
        catch (Exception exception2) {
            try {
                printWriter.flush();
                printWriter.close();
                System.err.println("Error while writing error log");
                exception2.printStackTrace();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
    }

    static {
        for (int i = 0; i < 360; ++i) {
            SimUtilities.sinArray[i] = Math.sin((double)i * (Math.PI / 180));
            SimUtilities.cosArray[i] = Math.cos((double)i * (Math.PI / 180));
        }
    }
}

